/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.google.common.collect.Sets;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.foundation.utility.Lang;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class MaterialChecklist {
    public static final int MAX_ENTRIES_PER_PAGE = 5;
    public Object2IntMap<Item> gathered = new Object2IntArrayMap();
    public Object2IntMap<Item> required = new Object2IntArrayMap();
    public Object2IntMap<Item> damageRequired = new Object2IntArrayMap();
    public boolean blocksNotLoaded;

    public void warnBlockNotLoaded() {
        this.blocksNotLoaded = true;
    }

    public void require(ItemRequirement requirement) {
        if (requirement.isEmpty()) {
            return;
        }
        if (requirement.isInvalid()) {
            return;
        }
        for (ItemStack stack : requirement.requiredItems) {
            if (requirement.getUsage() == ItemRequirement.ItemUseType.DAMAGE) {
                this.putOrIncrement(this.damageRequired, stack);
            }
            if (requirement.getUsage() != ItemRequirement.ItemUseType.CONSUME) continue;
            this.putOrIncrement(this.required, stack);
        }
    }

    private void putOrIncrement(Object2IntMap<Item> map, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == Items.field_190931_a) {
            return;
        }
        if (map.containsKey((Object)item)) {
            map.put((Object)item, map.getInt((Object)item) + stack.func_190916_E());
        } else {
            map.put((Object)item, stack.func_190916_E());
        }
    }

    public void collect(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (this.required.containsKey((Object)item) || this.damageRequired.containsKey((Object)item)) {
            if (this.gathered.containsKey((Object)item)) {
                this.gathered.put((Object)item, this.gathered.getInt((Object)item) + stack.func_190916_E());
            } else {
                this.gathered.put((Object)item, stack.func_190916_E());
            }
        }
    }

    public ItemStack createItem() {
        StringTextComponent textComponent;
        ItemStack book = new ItemStack((IItemProvider)Items.field_151164_bB);
        CompoundNBT tag = book.func_196082_o();
        ListNBT pages = new ListNBT();
        int itemsWritten = 0;
        if (this.blocksNotLoaded) {
            textComponent = new StringTextComponent("\n" + TextFormatting.RED);
            textComponent = textComponent.func_150257_a((ITextComponent)Lang.createTranslationTextComponent("materialChecklist.blocksNotLoaded", new Object[0]));
            pages.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)textComponent)));
        }
        ArrayList keys = new ArrayList(Sets.union((Set)this.required.keySet(), (Set)this.damageRequired.keySet()));
        Collections.sort(keys, (item1, item2) -> {
            String name1 = item1.getRegistryName().func_110623_a();
            String name2 = item2.getRegistryName().func_110623_a();
            return name1.compareTo(name2);
        });
        textComponent = new StringTextComponent("");
        ArrayList<Item> completed = new ArrayList<Item>();
        for (Item item : keys) {
            int amount = this.getRequiredAmount(item);
            if (this.gathered.containsKey((Object)item)) {
                amount -= this.gathered.getInt((Object)item);
            }
            if (amount <= 0) {
                completed.add(item);
                continue;
            }
            if (itemsWritten == 5) {
                itemsWritten = 0;
                textComponent = textComponent.func_150257_a(new StringTextComponent("\n >>>").func_211708_a(TextFormatting.BLUE));
                pages.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)textComponent)));
                textComponent = new StringTextComponent("");
            }
            ++itemsWritten;
            textComponent.func_150257_a(this.entry(new ItemStack((IItemProvider)item), amount, true));
        }
        for (Item item : completed) {
            if (itemsWritten == 5) {
                itemsWritten = 0;
                textComponent = textComponent.func_150257_a(new StringTextComponent("\n >>>").func_211708_a(TextFormatting.DARK_GREEN));
                pages.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)textComponent)));
                textComponent = new StringTextComponent("");
            }
            ++itemsWritten;
            textComponent.func_150257_a(this.entry(new ItemStack((IItemProvider)item), this.getRequiredAmount(item), false));
        }
        pages.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)textComponent)));
        tag.func_218657_a("pages", (INBT)pages);
        tag.func_74778_a("author", "Schematicannon");
        tag.func_74778_a("title", TextFormatting.BLUE + "Material Checklist");
        textComponent = Lang.createTranslationTextComponent("materialChecklist", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.BLUE).func_150217_b(Boolean.FALSE));
        book.func_190925_c("display").func_74778_a("Name", ITextComponent.Serializer.func_150696_a((ITextComponent)textComponent));
        book.func_77982_d(tag);
        return book;
    }

    public int getRequiredAmount(Item item) {
        int amount = this.required.getOrDefault((Object)item, 0);
        if (this.damageRequired.containsKey((Object)item)) {
            amount = (int)((double)amount + Math.ceil((float)this.damageRequired.getInt((Object)item) / (float)new ItemStack((IItemProvider)item).func_77958_k()));
        }
        return amount;
    }

    private ITextComponent entry(ItemStack item, int amount, boolean unfinished) {
        int stacks = amount / 64;
        int remainder = amount % 64;
        TranslationTextComponent tc = new TranslationTextComponent(item.func_77977_a(), new Object[0]);
        if (!unfinished) {
            tc.func_150258_a(" \u2714");
        }
        tc.func_211708_a(unfinished ? TextFormatting.BLUE : TextFormatting.DARK_GREEN);
        return tc.func_150258_a("\n" + TextFormatting.BLACK + " x" + amount + TextFormatting.GRAY + " | " + stacks + "\u25a4 +" + remainder + "\n");
    }
}

