/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.schematics.block.SchematicTableTileEntity;
import com.simibubi.create.content.schematics.item.SchematicItem;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CSchematics;
import com.simibubi.create.foundation.utility.FilesHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;

public class ServerSchematicLoader {
    private Map<String, SchematicUploadEntry> activeUploads = new HashMap<String, SchematicUploadEntry>();

    public String getSchematicPath() {
        return "schematics/uploaded";
    }

    public void tick() {
        HashSet<String> deadEntries = new HashSet<String>();
        for (String upload : this.activeUploads.keySet()) {
            SchematicUploadEntry entry = this.activeUploads.get(upload);
            if (entry.idleTime++ <= (Integer)this.getConfig().schematicIdleTimeout.get()) continue;
            Create.logger.warn("Schematic Upload timed out: " + upload);
            deadEntries.add(upload);
        }
        deadEntries.forEach(this::cancelUpload);
    }

    public void shutdown() {
        new HashSet<String>(this.activeUploads.keySet()).forEach(this::cancelUpload);
    }

    public void handleNewUpload(ServerPlayerEntity player, String schematic, long size, BlockPos pos) {
        String playerPath = this.getSchematicPath() + "/" + player.func_146103_bH().getName();
        String playerSchematicId = player.func_146103_bH().getName() + "/" + schematic;
        FilesHelper.createFolderIfMissing(playerPath);
        if (!schematic.endsWith(".nbt")) {
            Create.logger.warn("Attempted Schematic Upload with non-supported Format: " + playerSchematicId);
            return;
        }
        Path playerSchematicsPath = Paths.get(this.getSchematicPath(), player.func_146103_bH().getName()).toAbsolutePath();
        Path uploadPath = playerSchematicsPath.resolve(schematic).normalize();
        if (!uploadPath.startsWith(playerSchematicsPath)) {
            Create.logger.warn("Attempted Schematic Upload with directory escape: {}", (Object)playerSchematicId);
            return;
        }
        if (!this.validateSchematicSizeOnServer(player, size)) {
            return;
        }
        if (this.activeUploads.containsKey(playerSchematicId)) {
            return;
        }
        try {
            long count;
            SchematicTableTileEntity table = this.getTable(player.func_130014_f_(), pos);
            if (table == null) {
                return;
            }
            Files.deleteIfExists(uploadPath);
            try (Stream<Path> list = Files.list(Paths.get(playerPath, new String[0]));){
                count = list.count();
            }
            if (count >= (long)((Integer)this.getConfig().maxSchematics.get()).intValue()) {
                Stream<Path> list2 = Files.list(Paths.get(playerPath, new String[0]));
                Optional<Path> lastFilePath = list2.filter(f -> !Files.isDirectory(f, new LinkOption[0])).min(Comparator.comparingLong(f -> f.toFile().lastModified()));
                list2.close();
                if (lastFilePath.isPresent()) {
                    Files.deleteIfExists(lastFilePath.get());
                }
            }
            OutputStream writer = Files.newOutputStream(uploadPath, new OpenOption[0]);
            this.activeUploads.put(playerSchematicId, new SchematicUploadEntry(writer, size, (World)player.func_71121_q(), pos));
            table.startUpload(schematic);
        }
        catch (IOException e) {
            Create.logger.error("Exception Thrown when starting Upload: " + playerSchematicId);
            e.printStackTrace();
        }
    }

    protected boolean validateSchematicSizeOnServer(ServerPlayerEntity player, long size) {
        Integer maxFileSize = (Integer)this.getConfig().maxTotalSchematicSize.get();
        if (size > (long)(maxFileSize * 1000)) {
            player.func_145747_a(new TranslationTextComponent("create.schematics.uploadTooLarge", new Object[0]).func_150257_a((ITextComponent)new StringTextComponent(" (" + size / 1000L + " KB).")));
            player.func_145747_a(new TranslationTextComponent("create.schematics.maxAllowedSize", new Object[0]).func_150257_a((ITextComponent)new StringTextComponent(" " + maxFileSize + " KB")));
            return false;
        }
        return true;
    }

    public CSchematics getConfig() {
        return AllConfigs.SERVER.schematics;
    }

    public void handleWriteRequest(ServerPlayerEntity player, String schematic, byte[] data) {
        String playerSchematicId = player.func_146103_bH().getName() + "/" + schematic;
        if (this.activeUploads.containsKey(playerSchematicId)) {
            SchematicUploadEntry entry = this.activeUploads.get(playerSchematicId);
            entry.bytesUploaded += (long)data.length;
            if (data.length > (Integer)this.getConfig().maxSchematicPacketSize.get()) {
                Create.logger.warn("Oversized Upload Packet received: " + playerSchematicId);
                this.cancelUpload(playerSchematicId);
                return;
            }
            if (entry.bytesUploaded > entry.totalBytes) {
                Create.logger.warn("Received more data than Expected: " + playerSchematicId);
                this.cancelUpload(playerSchematicId);
                return;
            }
            try {
                entry.stream.write(data);
                entry.idleTime = 0;
                SchematicTableTileEntity table = this.getTable(entry.world, entry.tablePos);
                if (table == null) {
                    return;
                }
                table.uploadingProgress = (float)((double)entry.bytesUploaded / (double)entry.totalBytes);
                table.sendUpdate = true;
            }
            catch (IOException e) {
                Create.logger.error("Exception Thrown when uploading Schematic: " + playerSchematicId);
                e.printStackTrace();
                this.cancelUpload(playerSchematicId);
            }
        }
    }

    protected void cancelUpload(String playerSchematicId) {
        if (!this.activeUploads.containsKey(playerSchematicId)) {
            return;
        }
        SchematicUploadEntry entry = this.activeUploads.remove(playerSchematicId);
        try {
            entry.stream.close();
            Files.deleteIfExists(Paths.get(this.getSchematicPath(), playerSchematicId));
            Create.logger.warn("Cancelled Schematic Upload: " + playerSchematicId);
        }
        catch (IOException e) {
            Create.logger.error("Exception Thrown when cancelling Upload: " + playerSchematicId);
            e.printStackTrace();
        }
        BlockPos pos = entry.tablePos;
        if (pos == null) {
            return;
        }
        SchematicTableTileEntity table = this.getTable(entry.world, pos);
        if (table != null) {
            table.finishUpload();
        }
    }

    public SchematicTableTileEntity getTable(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof SchematicTableTileEntity)) {
            return null;
        }
        SchematicTableTileEntity table = (SchematicTableTileEntity)te;
        return table;
    }

    public void handleFinishedUpload(ServerPlayerEntity player, String schematic) {
        String playerSchematicId = player.func_146103_bH().getName() + "/" + schematic;
        if (this.activeUploads.containsKey(playerSchematicId)) {
            try {
                this.activeUploads.get((Object)playerSchematicId).stream.close();
                SchematicUploadEntry removed = this.activeUploads.remove(playerSchematicId);
                World world = removed.world;
                BlockPos pos = removed.tablePos;
                Create.logger.info("New Schematic Uploaded: " + playerSchematicId);
                if (pos == null) {
                    return;
                }
                BlockState blockState = world.func_180495_p(pos);
                if (AllBlocks.SCHEMATIC_TABLE.get() != blockState.func_177230_c()) {
                    return;
                }
                SchematicTableTileEntity table = this.getTable(world, pos);
                if (table == null) {
                    return;
                }
                table.finishUpload();
                table.inventory.setStackInSlot(1, SchematicItem.create(schematic, player.func_146103_bH().getName()));
            }
            catch (IOException e) {
                Create.logger.error("Exception Thrown when finishing Upload: " + playerSchematicId);
                e.printStackTrace();
            }
        }
    }

    public void handleInstantSchematic(ServerPlayerEntity player, String schematic, World world, BlockPos pos, BlockPos bounds) {
        String playerPath = this.getSchematicPath() + "/" + player.func_146103_bH().getName();
        String playerSchematicId = player.func_146103_bH().getName() + "/" + schematic;
        FilesHelper.createFolderIfMissing(playerPath);
        if (!schematic.endsWith(".nbt")) {
            Create.logger.warn("Attempted Schematic Upload with non-supported Format: {}", (Object)playerSchematicId);
            return;
        }
        Path schematicPath = Paths.get(this.getSchematicPath(), new String[0]).toAbsolutePath();
        Path path = schematicPath.resolve(playerSchematicId).normalize();
        if (!path.startsWith(schematicPath)) {
            Create.logger.warn("Attempted Schematic Upload with directory escape: {}", (Object)playerSchematicId);
            return;
        }
        if (!AllItems.SCHEMATIC_AND_QUILL.isIn(player.func_184614_ca())) {
            return;
        }
        try {
            long count;
            Files.deleteIfExists(path);
            try (Stream<Path> list = Files.list(Paths.get(playerPath, new String[0]));){
                count = list.count();
            }
            if (count >= (long)((Integer)this.getConfig().maxSchematics.get()).intValue()) {
                Stream<Path> list2 = Files.list(Paths.get(playerPath, new String[0]));
                Optional<Path> lastFilePath = list2.filter(f -> !Files.isDirectory(f, new LinkOption[0])).min(Comparator.comparingLong(f -> f.toFile().lastModified()));
                list2.close();
                if (lastFilePath.isPresent()) {
                    Files.deleteIfExists(lastFilePath.get());
                }
            }
            Template t = new Template();
            t.func_186254_a(world, pos, bounds, true, Blocks.field_150350_a);
            try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
                CompoundNBT nbttagcompound = t.func_189552_a(new CompoundNBT());
                CompressedStreamTools.func_74799_a((CompoundNBT)nbttagcompound, (OutputStream)outputStream);
                player.func_184611_a(Hand.MAIN_HAND, SchematicItem.create(schematic, player.func_146103_bH().getName()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            Create.logger.error("Exception Thrown in direct Schematic Upload: " + playerSchematicId);
            e.printStackTrace();
        }
    }

    public class SchematicUploadEntry {
        public World world;
        public BlockPos tablePos;
        public OutputStream stream;
        public long bytesUploaded;
        public long totalBytes;
        public int idleTime;

        public SchematicUploadEntry(OutputStream stream, long totalBytes, World world, BlockPos tablePos) {
            this.stream = stream;
            this.totalBytes = totalBytes;
            this.tablePos = tablePos;
            this.world = world;
            this.bytesUploaded = 0L;
            this.idleTime = 0;
        }
    }
}

