/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.block;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.logistics.block.inventories.CreativeCrateBlock;
import com.simibubi.create.content.schematics.block.SchematicannonContainer;
import com.simibubi.create.content.schematics.block.SchematicannonTileEntity;
import com.simibubi.create.content.schematics.packet.ConfigureSchematicannonPacket;
import com.simibubi.create.foundation.gui.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.gui.widgets.IconButton;
import com.simibubi.create.foundation.gui.widgets.Indicator;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class SchematicannonScreen
extends AbstractSimiContainerScreen<SchematicannonContainer> {
    private static final AllGuiTextures BG_BOTTOM = AllGuiTextures.SCHEMATICANNON_BOTTOM;
    private static final AllGuiTextures BG_TOP = AllGuiTextures.SCHEMATICANNON_TOP;
    protected Vector<Indicator> replaceLevelIndicators;
    protected Vector<IconButton> replaceLevelButtons;
    protected IconButton skipMissingButton;
    protected Indicator skipMissingIndicator;
    protected IconButton skipTilesButton;
    protected Indicator skipTilesIndicator;
    protected IconButton playButton;
    protected Indicator playIndicator;
    protected IconButton pauseButton;
    protected Indicator pauseIndicator;
    protected IconButton resetButton;
    protected Indicator resetIndicator;
    private List<Rectangle2d> extraAreas;
    protected List<Widget> placementSettingWidgets;
    private final String title = Lang.translate("gui.schematicannon.title", new Object[0]);
    private final String listPrinter = Lang.translate("gui.schematicannon.listPrinter", new Object[0]);
    private final String _gunpowderLevel = "gui.schematicannon.gunpowderLevel";
    private final String _shotsRemaining = "gui.schematicannon.shotsRemaining";
    private final String _showSettings = "gui.schematicannon.showOptions";
    private final String _shotsRemainingWithBackup = "gui.schematicannon.shotsRemainingWithBackup";
    private final String _slotGunpowder = "gui.schematicannon.slot.gunpowder";
    private final String _slotListPrinter = "gui.schematicannon.slot.listPrinter";
    private final String _slotSchematic = "gui.schematicannon.slot.schematic";
    private final String optionEnabled = Lang.translate("gui.schematicannon.optionEnabled", new Object[0]);
    private final String optionDisabled = Lang.translate("gui.schematicannon.optionDisabled", new Object[0]);
    private final ItemStack renderedItem = AllBlocks.SCHEMATICANNON.asStack();
    private IconButton confirmButton;
    private IconButton showSettingsButton;
    private Indicator showSettingsIndicator;

    public SchematicannonScreen(SchematicannonContainer container, PlayerInventory inventory, ITextComponent p_i51105_3_) {
        super(container, inventory, p_i51105_3_);
        this.placementSettingWidgets = new ArrayList<Widget>();
    }

    protected void init() {
        this.setWindowSize(SchematicannonScreen.BG_TOP.width + 50, SchematicannonScreen.BG_BOTTOM.height + SchematicannonScreen.BG_TOP.height + 80);
        super.init();
        int x = this.field_147003_i + 20;
        int y = this.field_147009_r;
        this.widgets.clear();
        this.playButton = new IconButton(x + 75, y + 86, AllIcons.I_PLAY);
        this.playIndicator = new Indicator(x + 75, y + 79, "");
        this.pauseButton = new IconButton(x + 93, y + 86, AllIcons.I_PAUSE);
        this.pauseIndicator = new Indicator(x + 93, y + 79, "");
        this.resetButton = new IconButton(x + 111, y + 86, AllIcons.I_STOP);
        this.resetIndicator = new Indicator(x + 111, y + 79, "");
        this.resetIndicator.state = Indicator.State.RED;
        Collections.addAll(this.widgets, new AbstractSimiWidget[]{this.playButton, this.playIndicator, this.pauseButton, this.pauseIndicator, this.resetButton, this.resetIndicator});
        this.extraAreas = new ArrayList<Rectangle2d>();
        this.extraAreas.add(new Rectangle2d(this.field_147003_i + 240, this.field_147009_r + 88, 84, 113));
        this.confirmButton = new IconButton(x + 180, this.field_147009_r + 117, AllIcons.I_CONFIRM);
        this.widgets.add(this.confirmButton);
        this.showSettingsButton = new IconButton(this.field_147003_i + 29, this.field_147009_r + 117, AllIcons.I_PLACEMENT_SETTINGS);
        this.showSettingsButton.setToolTip(Lang.translate("gui.schematicannon.showOptions", new Object[0]));
        this.widgets.add(this.showSettingsButton);
        this.showSettingsIndicator = new Indicator(this.field_147003_i + 29, this.field_147009_r + 111, "");
        this.widgets.add(this.showSettingsIndicator);
        this.tick();
    }

    private void initPlacementSettings() {
        this.widgets.removeAll(this.placementSettingWidgets);
        this.placementSettingWidgets.clear();
        if (this.placementSettingsHidden()) {
            return;
        }
        int x = this.field_147003_i + 20;
        int y = this.field_147009_r;
        this.replaceLevelButtons = new Vector(4);
        this.replaceLevelIndicators = new Vector(4);
        ImmutableList icons = ImmutableList.of((Object)AllIcons.I_DONT_REPLACE, (Object)AllIcons.I_REPLACE_SOLID, (Object)AllIcons.I_REPLACE_ANY, (Object)AllIcons.I_REPLACE_EMPTY);
        ImmutableList toolTips = ImmutableList.of((Object)Lang.translate("gui.schematicannon.option.dontReplaceSolid", new Object[0]), (Object)Lang.translate("gui.schematicannon.option.replaceWithSolid", new Object[0]), (Object)Lang.translate("gui.schematicannon.option.replaceWithAny", new Object[0]), (Object)Lang.translate("gui.schematicannon.option.replaceWithEmpty", new Object[0]));
        for (int i = 0; i < 4; ++i) {
            this.replaceLevelIndicators.add(new Indicator(x + 33 + i * 18, y + 111, ""));
            this.replaceLevelButtons.add(new IconButton(x + 33 + i * 18, y + 117, (AllIcons)icons.get(i)));
            this.replaceLevelButtons.get(i).setToolTip((String)toolTips.get(i));
        }
        this.placementSettingWidgets.addAll(this.replaceLevelButtons);
        this.placementSettingWidgets.addAll(this.replaceLevelIndicators);
        this.skipMissingButton = new IconButton(x + 111, y + 117, AllIcons.I_SKIP_MISSING);
        this.skipMissingButton.setToolTip(Lang.translate("gui.schematicannon.option.skipMissing", new Object[0]));
        this.skipMissingIndicator = new Indicator(x + 111, y + 111, "");
        Collections.addAll(this.placementSettingWidgets, new AbstractSimiWidget[]{this.skipMissingButton, this.skipMissingIndicator});
        this.skipTilesButton = new IconButton(x + 129, y + 117, AllIcons.I_SKIP_TILES);
        this.skipTilesButton.setToolTip(Lang.translate("gui.schematicannon.option.skipTileEntities", new Object[0]));
        this.skipTilesIndicator = new Indicator(x + 129, y + 111, "");
        Collections.addAll(this.placementSettingWidgets, new AbstractSimiWidget[]{this.skipTilesButton, this.skipTilesIndicator});
        this.widgets.addAll(this.placementSettingWidgets);
    }

    protected boolean placementSettingsHidden() {
        return this.showSettingsIndicator.state == Indicator.State.OFF;
    }

    public void tick() {
        SchematicannonTileEntity te = ((SchematicannonContainer)this.field_147002_h).getTileEntity();
        if (!this.placementSettingsHidden()) {
            for (int replaceMode = 0; replaceMode < this.replaceLevelButtons.size(); ++replaceMode) {
                this.replaceLevelIndicators.get((int)replaceMode).state = replaceMode == te.replaceMode ? Indicator.State.ON : Indicator.State.OFF;
            }
            this.skipMissingIndicator.state = te.skipMissing ? Indicator.State.ON : Indicator.State.OFF;
            this.skipTilesIndicator.state = !te.replaceTileEntities ? Indicator.State.ON : Indicator.State.OFF;
        }
        this.playIndicator.state = Indicator.State.OFF;
        this.pauseIndicator.state = Indicator.State.OFF;
        this.resetIndicator.state = Indicator.State.OFF;
        switch (te.state) {
            case PAUSED: {
                this.pauseIndicator.state = Indicator.State.YELLOW;
                this.playButton.active = true;
                this.pauseButton.active = false;
                this.resetButton.active = true;
                break;
            }
            case RUNNING: {
                this.playIndicator.state = Indicator.State.GREEN;
                this.playButton.active = false;
                this.pauseButton.active = true;
                this.resetButton.active = true;
                break;
            }
            case STOPPED: {
                this.resetIndicator.state = Indicator.State.RED;
                this.playButton.active = true;
                this.pauseButton.active = false;
                this.resetButton.active = false;
                break;
            }
        }
        this.handleTooltips();
        super.tick();
    }

    protected void handleTooltips() {
        if (this.placementSettingsHidden()) {
            return;
        }
        for (Widget w : this.placementSettingWidgets) {
            IconButton button;
            if (!(w instanceof IconButton) || (button = (IconButton)w).getToolTip().isEmpty()) continue;
            button.setToolTip(button.getToolTip().get(0));
            button.getToolTip().add(TooltipHelper.holdShift(ItemDescription.Palette.Blue, SchematicannonScreen.hasShiftDown()));
        }
        if (SchematicannonScreen.hasShiftDown()) {
            this.fillToolTip(this.skipMissingButton, this.skipMissingIndicator, "skipMissing");
            this.fillToolTip(this.skipTilesButton, this.skipTilesIndicator, "skipTileEntities");
            this.fillToolTip(this.replaceLevelButtons.get(0), this.replaceLevelIndicators.get(0), "dontReplaceSolid");
            this.fillToolTip(this.replaceLevelButtons.get(1), this.replaceLevelIndicators.get(1), "replaceWithSolid");
            this.fillToolTip(this.replaceLevelButtons.get(2), this.replaceLevelIndicators.get(2), "replaceWithAny");
            this.fillToolTip(this.replaceLevelButtons.get(3), this.replaceLevelIndicators.get(3), "replaceWithEmpty");
        }
    }

    private void fillToolTip(IconButton button, Indicator indicator, String tooltipKey) {
        if (!button.isHovered()) {
            return;
        }
        boolean enabled = indicator.state == Indicator.State.ON;
        List<String> tip = button.getToolTip();
        tip.add(TextFormatting.BLUE + (enabled ? this.optionEnabled : this.optionDisabled));
        tip.addAll(TooltipHelper.cutString(Lang.translate("gui.schematicannon.option." + tooltipKey + ".description", new Object[0]), TextFormatting.GRAY, TextFormatting.GRAY));
    }

    @Override
    protected void renderWindow(int mouseX, int mouseY, float partialTicks) {
        AllGuiTextures.PLAYER_INVENTORY.draw((AbstractGui)this, this.field_147003_i - 10, this.field_147009_r + 145);
        BG_TOP.draw((AbstractGui)this, this.field_147003_i + 20, this.field_147009_r);
        BG_BOTTOM.draw((AbstractGui)this, this.field_147003_i + 20, this.field_147009_r + SchematicannonScreen.BG_TOP.height);
        SchematicannonTileEntity te = ((SchematicannonContainer)this.field_147002_h).getTileEntity();
        this.renderPrintingProgress(te.schematicProgress);
        this.renderFuelBar(te.fuelLevel);
        this.renderChecklistPrinterProgress(te.bookPrintingProgress);
        if (!te.inventory.getStackInSlot(0).func_190926_b()) {
            this.renderBlueprintHighlight();
        }
        GuiGameElement.of(this.renderedItem).at(this.field_147003_i + 230, this.field_147009_r + 110).scale(5.0).render();
        this.font.func_175063_a(this.title, (float)(this.field_147003_i + 80), (float)(this.field_147009_r + 3), 0xFEFEFE);
        String msg = Lang.translate("schematicannon.status." + te.statusMsg, new Object[0]);
        int stringWidth = this.font.func_78256_a(msg);
        if (te.missingItem != null) {
            stringWidth += 15;
            this.itemRenderer.func_175042_a(te.missingItem, this.field_147003_i + 150, this.field_147009_r + 46);
        }
        this.font.func_175063_a(msg, (float)(this.field_147003_i + 20 + 102 - stringWidth / 2), (float)(this.field_147009_r + 50), 0xCCDDFF);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), (float)(this.field_147003_i - 10 + 7), (float)(this.field_147009_r + 145 + 6), 0x666666);
    }

    protected void renderBlueprintHighlight() {
        AllGuiTextures.SCHEMATICANNON_HIGHLIGHT.draw((AbstractGui)this, this.field_147003_i + 20 + 10, this.field_147009_r + 60);
    }

    protected void renderPrintingProgress(float progress) {
        progress = Math.min(progress, 1.0f);
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_PROGRESS;
        this.minecraft.func_110434_K().func_110577_a(sprite.location);
        this.blit(this.field_147003_i + 20 + 44, this.field_147009_r + 64, sprite.startX, sprite.startY, (int)((float)sprite.width * progress), sprite.height);
    }

    protected void renderChecklistPrinterProgress(float progress) {
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_CHECKLIST_PROGRESS;
        this.minecraft.func_110434_K().func_110577_a(sprite.location);
        this.blit(this.field_147003_i + 20 + 154, this.field_147009_r + 20, sprite.startX, sprite.startY, (int)((float)sprite.width * progress), sprite.height);
    }

    protected void renderFuelBar(float amount) {
        AllGuiTextures sprite = AllGuiTextures.SCHEMATICANNON_FUEL;
        if (((SchematicannonContainer)this.field_147002_h).getTileEntity().hasCreativeCrate) {
            AllGuiTextures.SCHEMATICANNON_FUEL_CREATIVE.draw((AbstractGui)this, this.field_147003_i + 20 + 36, this.field_147009_r + 19);
            return;
        }
        this.minecraft.func_110434_K().func_110577_a(sprite.location);
        this.blit(this.field_147003_i + 20 + 36, this.field_147009_r + 19, sprite.startX, sprite.startY, (int)((float)sprite.width * amount), sprite.height);
    }

    @Override
    protected void renderWindowForeground(int mouseX, int mouseY, float partialTicks) {
        SchematicannonTileEntity te = ((SchematicannonContainer)this.field_147002_h).getTileEntity();
        int fuelX = this.field_147003_i + 20 + 36;
        int fuelY = this.field_147009_r + 19;
        if (mouseX >= fuelX && mouseY >= fuelY && mouseX <= fuelX + AllGuiTextures.SCHEMATICANNON_FUEL.width && mouseY <= fuelY + AllGuiTextures.SCHEMATICANNON_FUEL.height) {
            List<String> tooltip = this.getFuelLevelTooltip(te);
            this.renderTooltip(tooltip, mouseX, mouseY);
        }
        if (this.field_147006_u != null && !this.field_147006_u.func_75216_d()) {
            if (this.field_147006_u.field_75222_d == 0) {
                this.renderTooltip(TooltipHelper.cutString(Lang.translate("gui.schematicannon.slot.schematic", new Object[0]), TextFormatting.GRAY, TextFormatting.BLUE), mouseX, mouseY);
            }
            if (this.field_147006_u.field_75222_d == 2) {
                this.renderTooltip(TooltipHelper.cutString(Lang.translate("gui.schematicannon.slot.listPrinter", new Object[0]), TextFormatting.GRAY, TextFormatting.BLUE), mouseX, mouseY);
            }
            if (this.field_147006_u.field_75222_d == 4) {
                this.renderTooltip(TooltipHelper.cutString(Lang.translate("gui.schematicannon.slot.gunpowder", new Object[0]), TextFormatting.GRAY, TextFormatting.BLUE), mouseX, mouseY);
            }
        }
        if (te.missingItem != null) {
            int missingBlockX = this.field_147003_i + 150;
            int missingBlockY = this.field_147009_r + 46;
            if (mouseX >= missingBlockX && mouseY >= missingBlockY && mouseX <= missingBlockX + 16 && mouseY <= missingBlockY + 16) {
                this.renderTooltip(te.missingItem, mouseX, mouseY);
            }
        }
        int paperX = this.field_147003_i + 132;
        int paperY = this.field_147009_r + 19;
        if (mouseX >= paperX && mouseY >= paperY && mouseX <= paperX + 16 && mouseY <= paperY + 16) {
            this.renderTooltip(this.listPrinter, mouseX, mouseY);
        }
        super.renderWindowForeground(mouseX, mouseY, partialTicks);
    }

    protected List<String> getFuelLevelTooltip(SchematicannonTileEntity te) {
        double fuelUsageRate = te.getFuelUsageRate();
        int shotsLeft = (int)((double)te.fuelLevel / fuelUsageRate);
        int shotsLeftWithItems = (int)((double)shotsLeft + (double)te.inventory.getStackInSlot(4).func_190916_E() * (te.getFuelAddedByGunPowder() / fuelUsageRate));
        ArrayList<String> tooltip = new ArrayList<String>();
        if (te.hasCreativeCrate) {
            tooltip.add(Lang.translate("gui.schematicannon.gunpowderLevel", "100"));
            tooltip.add(TextFormatting.DARK_PURPLE + "(" + new TranslationTextComponent(((CreativeCrateBlock)AllBlocks.CREATIVE_CRATE.get()).func_149739_a(), new Object[0]).func_150254_d() + ")");
            return tooltip;
        }
        float f = te.fuelLevel * 100.0f;
        tooltip.add(Lang.translate("gui.schematicannon.gunpowderLevel", "" + (int)f));
        tooltip.add(TextFormatting.GRAY + Lang.translate("gui.schematicannon.shotsRemaining", "" + TextFormatting.BLUE + shotsLeft));
        if (shotsLeftWithItems != shotsLeft) {
            tooltip.add(TextFormatting.GRAY + Lang.translate("gui.schematicannon.shotsRemainingWithBackup", "" + TextFormatting.BLUE + shotsLeftWithItems));
        }
        return tooltip;
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        if (this.showSettingsButton.isHovered()) {
            this.showSettingsIndicator.state = this.placementSettingsHidden() ? Indicator.State.GREEN : Indicator.State.OFF;
            this.initPlacementSettings();
        }
        if (this.confirmButton.isHovered()) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            return true;
        }
        if (!this.placementSettingsHidden()) {
            for (int replaceMode = 0; replaceMode < this.replaceLevelButtons.size(); ++replaceMode) {
                if (!this.replaceLevelButtons.get(replaceMode).isHovered() || ((SchematicannonContainer)this.field_147002_h).getTileEntity().replaceMode == replaceMode) continue;
                this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.values()[replaceMode], true);
            }
            if (this.skipMissingButton.isHovered()) {
                this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.SKIP_MISSING, !((SchematicannonContainer)this.field_147002_h).getTileEntity().skipMissing);
            }
            if (this.skipTilesButton.isHovered()) {
                this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.SKIP_TILES, !((SchematicannonContainer)this.field_147002_h).getTileEntity().replaceTileEntities);
            }
        }
        if (this.playButton.isHovered() && this.playButton.active) {
            this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.PLAY, true);
        }
        if (this.pauseButton.isHovered() && this.pauseButton.active) {
            this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.PAUSE, true);
        }
        if (this.resetButton.isHovered() && this.resetButton.active) {
            this.sendOptionUpdate(ConfigureSchematicannonPacket.Option.STOP, true);
        }
        return super.mouseClicked(x, y, button);
    }

    @Override
    public List<Rectangle2d> getExtraAreas() {
        return this.extraAreas;
    }

    protected void sendOptionUpdate(ConfigureSchematicannonPacket.Option option, boolean set) {
        AllPackets.channel.sendToServer((Object)new ConfigureSchematicannonPacket(option, set));
    }
}

