/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.Create;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.schematics.ClientSchematicLoader;
import com.simibubi.create.content.schematics.client.SchematicPromptScreen;
import com.simibubi.create.content.schematics.packet.InstantSchematicPacket;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.RaycastHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.outliner.Outliner;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import org.apache.commons.io.IOUtils;

public class SchematicAndQuillHandler {
    private Object outlineSlot = new Object();
    private BlockPos firstPos;
    private BlockPos secondPos;
    private BlockPos selectedPos;
    private Direction selectedFace;
    private int range = 10;

    public boolean mouseScrolled(double delta) {
        if (!this.isActive()) {
            return false;
        }
        if (!AllKeys.ctrlDown()) {
            return false;
        }
        if (this.secondPos == null) {
            this.range = (int)MathHelper.func_151237_a((double)((double)this.range + delta), (double)1.0, (double)100.0);
        }
        if (this.selectedFace == null) {
            return true;
        }
        AxisAlignedBB bb = new AxisAlignedBB(this.firstPos, this.secondPos);
        Vec3i vec = this.selectedFace.func_176730_m();
        Vec3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        if (bb.func_72318_a(projectedView)) {
            delta *= -1.0;
        }
        int x = (int)((double)vec.func_177958_n() * delta);
        int y = (int)((double)vec.func_177956_o() * delta);
        int z = (int)((double)vec.func_177952_p() * delta);
        Direction.AxisDirection axisDirection = this.selectedFace.func_176743_c();
        if (axisDirection == Direction.AxisDirection.NEGATIVE) {
            bb = bb.func_72317_d((double)(-x), (double)(-y), (double)(-z));
        }
        double maxX = Math.max(bb.field_72336_d - (double)(x * axisDirection.func_179524_a()), bb.field_72340_a);
        double maxY = Math.max(bb.field_72337_e - (double)(y * axisDirection.func_179524_a()), bb.field_72338_b);
        double maxZ = Math.max(bb.field_72334_f - (double)(z * axisDirection.func_179524_a()), bb.field_72339_c);
        bb = new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, maxX, maxY, maxZ);
        this.firstPos = new BlockPos(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c);
        this.secondPos = new BlockPos(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
        Lang.sendStatus((PlayerEntity)Minecraft.func_71410_x().field_71439_g, "schematicAndQuill.dimensions", (int)bb.func_216364_b() + 1, (int)bb.func_216360_c() + 1, (int)bb.func_216362_d() + 1);
        return true;
    }

    public void onMouseInput(int button, boolean pressed) {
        if (!pressed || button != 1) {
            return;
        }
        if (!this.isActive()) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_225608_bj_()) {
            this.discard();
            return;
        }
        if (this.secondPos != null) {
            ScreenOpener.open(new SchematicPromptScreen());
            return;
        }
        if (this.selectedPos == null) {
            Lang.sendStatus((PlayerEntity)player, "schematicAndQuill.noTarget", new Object[0]);
            return;
        }
        if (this.firstPos != null) {
            this.secondPos = this.selectedPos;
            Lang.sendStatus((PlayerEntity)player, "schematicAndQuill.secondPos", new Object[0]);
            return;
        }
        this.firstPos = this.selectedPos;
        Lang.sendStatus((PlayerEntity)player, "schematicAndQuill.firstPos", new Object[0]);
    }

    public void discard() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        this.firstPos = null;
        this.secondPos = null;
        Lang.sendStatus((PlayerEntity)player, "schematicAndQuill.abort", new Object[0]);
    }

    public void tick() {
        AxisAlignedBB currentSelectionBox;
        if (!this.isActive()) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (AllKeys.ACTIVATE_TOOL.isPressed()) {
            float pt = AnimationTickHolder.getPartialTicks();
            Vec3d targetVec = player.func_174824_e(pt).func_178787_e(player.func_70040_Z().func_186678_a((double)this.range));
            this.selectedPos = new BlockPos(targetVec);
        } else {
            BlockRayTraceResult trace = RaycastHelper.rayTraceRange(player.field_70170_p, (PlayerEntity)player, 75.0);
            if (trace != null && trace.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockPos hit = trace.func_216350_a();
                boolean replaceable = player.field_70170_p.func_180495_p(hit).func_196953_a(new BlockItemUseContext(new ItemUseContext((PlayerEntity)player, Hand.MAIN_HAND, trace)));
                if (trace.func_216354_b().func_176740_k().func_200128_b() && !replaceable) {
                    hit = hit.func_177972_a(trace.func_216354_b());
                }
                this.selectedPos = hit;
            } else {
                this.selectedPos = null;
            }
        }
        this.selectedFace = null;
        if (this.secondPos != null) {
            Vec3d projectedView;
            AxisAlignedBB bb = new AxisAlignedBB(this.firstPos, this.secondPos).func_72321_a(1.0, 1.0, 1.0).func_186662_g((double)0.45f);
            boolean inside = bb.func_72318_a(projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c());
            RaycastHelper.PredicateTraceResult result = RaycastHelper.rayTraceUntil((PlayerEntity)player, 70.0, pos -> inside ^ bb.func_72318_a(VecHelper.getCenterOf((Vec3i)pos)));
            Direction direction = result.missed() ? null : (this.selectedFace = inside ? result.getFacing().func_176734_d() : result.getFacing());
        }
        if ((currentSelectionBox = this.getCurrentSelectionBox()) != null) {
            this.outliner().chaseAABB(this.outlineSlot, currentSelectionBox).colored(6850245).withFaceTextures(AllSpecialTextures.CHECKERED, AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).highlightFace(this.selectedFace);
        }
    }

    private AxisAlignedBB getCurrentSelectionBox() {
        if (this.secondPos == null) {
            if (this.firstPos == null) {
                return this.selectedPos == null ? null : new AxisAlignedBB(this.selectedPos);
            }
            return this.selectedPos == null ? new AxisAlignedBB(this.firstPos) : new AxisAlignedBB(this.firstPos, this.selectedPos).func_72321_a(1.0, 1.0, 1.0);
        }
        return new AxisAlignedBB(this.firstPos, this.secondPos).func_72321_a(1.0, 1.0, 1.0);
    }

    private boolean isActive() {
        return this.isPresent() && AllItems.SCHEMATIC_AND_QUILL.isIn(Minecraft.func_71410_x().field_71439_g.func_184614_ca());
    }

    private boolean isPresent() {
        return Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71462_r == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void saveSchematic(String string, boolean convertImmediately) {
        t = new Template();
        bb = new MutableBoundingBox((Vec3i)this.firstPos, (Vec3i)this.secondPos);
        origin = new BlockPos(bb.field_78897_a, bb.field_78895_b, bb.field_78896_c);
        bounds = new BlockPos(bb.func_78883_b(), bb.func_78882_c(), bb.func_78880_d());
        t.func_186254_a((World)Minecraft.func_71410_x().field_71441_e, origin, bounds, true, Blocks.field_150350_a);
        if (string.isEmpty()) {
            string = Lang.translate("schematicAndQuill.fallbackName", new Object[0]);
        }
        folderPath = "schematics";
        FilesHelper.createFolderIfMissing(folderPath);
        filename = FilesHelper.findFirstValidFilename(string, folderPath, "nbt");
        filepath = folderPath + "/" + filename;
        path = Paths.get(filepath, new String[0]);
        outputStream = null;
        try {
            outputStream = Files.newOutputStream(path, new OpenOption[]{StandardOpenOption.CREATE});
            nbttagcompound = t.func_189552_a(new CompoundNBT());
            CompressedStreamTools.func_74799_a((CompoundNBT)nbttagcompound, (OutputStream)outputStream);
            ** if (outputStream == null) goto lbl-1000
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
                ** if (outputStream == null) goto lbl-1000
            }
            catch (Throwable var13_15) {
                if (outputStream != null) {
                    IOUtils.closeQuietly(outputStream);
                }
                throw var13_15;
            }
lbl-1000:
            // 1 sources

            {
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
lbl-1000:
        // 2 sources

        {
        }
        this.firstPos = null;
        this.secondPos = null;
        Lang.sendStatus((PlayerEntity)Minecraft.func_71410_x().field_71439_g, "schematicAndQuill.saved", new Object[]{filepath});
        if (!convertImmediately) {
            return;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            Create.logger.fatal("Missing Schematic file: " + path.toString());
            return;
        }
        try {
            if (!ClientSchematicLoader.validateSizeLimitation(Files.size(path))) {
                return;
            }
            AllPackets.channel.sendToServer((Object)new InstantSchematicPacket(filename, origin, bounds));
        }
        catch (IOException e) {
            Create.logger.fatal("Error finding Schematic file: " + path.toString());
            e.printStackTrace();
            return;
        }
    }

    private Outliner outliner() {
        return CreateClient.outliner;
    }
}

