/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.render.TileEntityRenderHelper;
import com.simibubi.create.foundation.renderState.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.MatrixStacker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class SchematicRenderer {
    private final Map<RenderType, SuperByteBuffer> bufferCache = new HashMap<RenderType, SuperByteBuffer>(SchematicRenderer.getLayerCount());
    private final Set<RenderType> usedBlockRenderLayers = new HashSet<RenderType>(SchematicRenderer.getLayerCount());
    private final Set<RenderType> startedBufferBuilders = new HashSet<RenderType>(SchematicRenderer.getLayerCount());
    private boolean active;
    private boolean changed = false;
    protected SchematicWorld schematic;
    private BlockPos anchor;

    public void display(SchematicWorld world) {
        this.anchor = world.anchor;
        this.schematic = world;
        this.active = true;
        this.changed = true;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void update() {
        this.changed = true;
    }

    public void tick() {
        if (!this.active) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null || !this.changed) {
            return;
        }
        this.redraw(mc);
        this.changed = false;
    }

    public void render(MatrixStack ms, SuperRenderTypeBuffer buffer) {
        if (!this.active) {
            return;
        }
        buffer.getBuffer(RenderType.func_228639_c_());
        for (RenderType layer : RenderType.func_228661_n_()) {
            if (!this.usedBlockRenderLayers.contains(layer)) continue;
            SuperByteBuffer superByteBuffer = this.bufferCache.get(layer);
            superByteBuffer.renderInto(ms, buffer.getBuffer(layer));
        }
        TileEntityRenderHelper.renderTileEntities(this.schematic, this.schematic.getRenderedTileEntities(), ms, new MatrixStack(), buffer);
    }

    protected void redraw(Minecraft minecraft) {
        this.usedBlockRenderLayers.clear();
        this.startedBufferBuilders.clear();
        SchematicWorld blockAccess = this.schematic;
        BlockRendererDispatcher blockRendererDispatcher = minecraft.func_175602_ab();
        LinkedList blockstates = new LinkedList();
        HashMap buffers = new HashMap();
        MatrixStack ms = new MatrixStack();
        BlockPos.func_229383_a_((MutableBoundingBox)blockAccess.getBounds()).forEach(localPos -> {
            ms.func_227860_a_();
            MatrixStacker.of(ms).translate((Vec3i)localPos);
            BlockPos pos = localPos.func_177971_a((Vec3i)this.anchor);
            BlockState state = blockAccess.func_180495_p(pos);
            for (RenderType blockRenderLayer : RenderType.func_228661_n_()) {
                TileEntity tileEntity;
                if (!RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)blockRenderLayer)) continue;
                ForgeHooksClient.setRenderLayer((RenderType)blockRenderLayer);
                if (!buffers.containsKey(blockRenderLayer)) {
                    buffers.put(blockRenderLayer, new BufferBuilder(DefaultVertexFormats.field_176600_a.func_181719_f()));
                }
                BufferBuilder bufferBuilder = (BufferBuilder)buffers.get(blockRenderLayer);
                if (this.startedBufferBuilders.add(blockRenderLayer)) {
                    bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                }
                if (blockRendererDispatcher.renderModel(state, pos, (ILightReader)blockAccess, ms, (IVertexBuilder)bufferBuilder, true, minecraft.field_71441_e.field_73012_v, (IModelData)((tileEntity = blockAccess.func_175625_s((BlockPos)localPos)) != null ? tileEntity.getModelData() : EmptyModelData.INSTANCE))) {
                    this.usedBlockRenderLayers.add(blockRenderLayer);
                }
                blockstates.add(state);
            }
            ForgeHooksClient.setRenderLayer(null);
            ms.func_227865_b_();
        });
        for (RenderType layer : RenderType.func_228661_n_()) {
            if (!this.startedBufferBuilders.contains(layer)) continue;
            BufferBuilder buf = (BufferBuilder)buffers.get(layer);
            buf.func_178977_d();
            this.bufferCache.put(layer, new SuperByteBuffer(buf));
        }
    }

    private static int getLayerCount() {
        return RenderType.func_228661_n_().size();
    }
}

