/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.events;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllFluids;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.contraptions.KineticDebugger;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.components.flywheel.engine.EngineBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.ChassisRangeDisplay;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingHandlerClient;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingPhysics;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingRenderer;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.components.turntable.TurntableHandler;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.relays.belt.item.BeltConnectorHandler;
import com.simibubi.create.content.curiosities.tools.ExtendoGripRenderHandler;
import com.simibubi.create.content.curiosities.zapper.ZapperItem;
import com.simibubi.create.content.curiosities.zapper.ZapperRenderHandler;
import com.simibubi.create.content.curiosities.zapper.blockzapper.BlockzapperRenderHandler;
import com.simibubi.create.content.curiosities.zapper.terrainzapper.WorldshaperRenderHandler;
import com.simibubi.create.content.logistics.block.depot.EjectorTargetHandler;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPointHandler;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.LeftClickPacket;
import com.simibubi.create.foundation.ponder.PonderTooltipHandler;
import com.simibubi.create.foundation.render.KineticRenderer;
import com.simibubi.create.foundation.render.backend.FastRenderDispatcher;
import com.simibubi.create.foundation.render.backend.RenderWork;
import com.simibubi.create.foundation.renderState.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.tileEntity.behaviour.edgeInteraction.EdgeInteractionRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.linked.LinkRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueHandler;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueRenderer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    private static final String itemPrefix = "item.create";
    private static final String blockPrefix = "block.create";

    @SubscribeEvent
    public static void onTick(TickEvent.ClientTickEvent event) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (!ClientEvents.isGameActive()) {
            return;
        }
        AnimationTickHolder.tick();
        FastRenderDispatcher.tick();
        ScrollValueHandler.tick();
        CreateClient.schematicSender.tick();
        CreateClient.schematicAndQuillHandler.tick();
        CreateClient.schematicHandler.tick();
        ContraptionHandler.tick((World)world);
        CapabilityMinecartController.tick((World)world);
        CouplingPhysics.tick((World)world);
        PonderTooltipHandler.tick();
        ServerSpeedProvider.clientTick();
        BeltConnectorHandler.tick();
        FilteringRenderer.tick();
        LinkRenderer.tick();
        ScrollValueRenderer.tick();
        ChassisRangeDisplay.tick();
        EdgeInteractionRenderer.tick();
        WorldshaperRenderHandler.tick();
        BlockzapperRenderHandler.tick();
        CouplingHandlerClient.tick();
        CouplingRenderer.tickDebugModeRenders();
        KineticDebugger.tick();
        ZapperRenderHandler.tick();
        ExtendoGripRenderHandler.tick();
        ArmInteractionPointHandler.tick();
        EjectorTargetHandler.tick();
        PlacementHelpers.tick();
        CreateClient.outliner.tickOutlines();
        CreateClient.ghostBlocks.tickGhosts();
        ContraptionRenderDispatcher.tick();
    }

    @SubscribeEvent
    public static void onLoadWorld(WorldEvent.Load event) {
        IWorld world = event.getWorld();
        if (world.func_201670_d() && world instanceof ClientWorld) {
            CreateClient.invalidateRenderers();
            AnimationTickHolder.reset();
            KineticRenderer renderer = CreateClient.kineticRenderer.get(world);
            renderer.invalidate();
            ((ClientWorld)world).field_147482_g.forEach(renderer::add);
        }
        IHaveGoggleInformation.numberFormat.update();
    }

    @SubscribeEvent
    public static void onUnloadWorld(WorldEvent.Unload event) {
        if (event.getWorld().func_201670_d()) {
            CreateClient.invalidateRenderers(event.getWorld());
            AnimationTickHolder.reset();
        }
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderWorldLastEvent event) {
        Vec3d cameraPos = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        float pt = AnimationTickHolder.getPartialTicks();
        MatrixStack ms = event.getMatrixStack();
        ms.func_227860_a_();
        ms.func_227861_a_(-cameraPos.func_82615_a(), -cameraPos.func_82617_b(), -cameraPos.func_82616_c());
        SuperRenderTypeBuffer buffer = SuperRenderTypeBuffer.getInstance();
        CouplingRenderer.renderAll(ms, buffer);
        CreateClient.schematicHandler.render(ms, buffer);
        CreateClient.ghostBlocks.renderAll(ms, buffer);
        CreateClient.outliner.renderOutlines(ms, buffer, pt);
        buffer.draw();
        RenderSystem.enableCull();
        ms.func_227865_b_();
        RenderWork.runAll();
        FastRenderDispatcher.endFrame();
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        ClientEvents.onRenderHotbar(new MatrixStack(), (IRenderTypeBuffer)Minecraft.func_71410_x().func_228019_au_().func_228487_b_(), 0xF000F0, OverlayTexture.field_229196_a_);
    }

    public static void onRenderHotbar(MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        CreateClient.schematicHandler.renderOverlay(ms, buffer, light, overlay);
    }

    @SubscribeEvent
    public static void getItemTooltipColor(RenderTooltipEvent.Color event) {
        PonderTooltipHandler.handleTooltipColor(event);
    }

    @SubscribeEvent
    public static void addToItemTooltip(ItemTooltipEvent event) {
        List<String> kineticStats;
        BlockItem item;
        if (!((Boolean)AllConfigs.CLIENT.tooltips.get()).booleanValue()) {
            return;
        }
        if (event.getPlayer() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        String translationKey = stack.func_77973_b().func_77667_c(stack);
        if (!translationKey.startsWith(itemPrefix) && !translationKey.startsWith(blockPrefix)) {
            return;
        }
        if (TooltipHelper.hasTooltip(stack, event.getPlayer())) {
            List itemTooltip = event.getToolTip();
            ArrayList<ITextComponent> toolTip = new ArrayList<ITextComponent>();
            toolTip.add((ITextComponent)itemTooltip.remove(0));
            TooltipHelper.getTooltip(stack).addInformation(toolTip);
            itemTooltip.addAll(0, toolTip);
        }
        if (stack.func_77973_b() instanceof BlockItem && ((item = (BlockItem)stack.func_77973_b()).func_179223_d() instanceof IRotate || item.func_179223_d() instanceof EngineBlock) && !(kineticStats = ItemDescription.getKineticStats(item.func_179223_d())).isEmpty()) {
            event.getToolTip().add(new StringTextComponent(""));
            kineticStats.stream().map(StringTextComponent::new).forEach(event.getToolTip()::add);
        }
        PonderTooltipHandler.addToTooltip(event.getToolTip(), stack);
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (!ClientEvents.isGameActive()) {
            return;
        }
        TurntableHandler.gameRenderTick();
    }

    protected static boolean isGameActive() {
        return Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null;
    }

    @SubscribeEvent
    public static void getFogDensity(EntityViewRenderEvent.FogDensity event) {
        ActiveRenderInfo info = event.getInfo();
        IFluidState fluidState = info.func_216771_k();
        if (fluidState.func_206888_e()) {
            return;
        }
        Fluid fluid = fluidState.func_206886_c();
        if (fluid.func_207187_a((Fluid)AllFluids.CHOCOLATE.get())) {
            event.setDensity(5.0f);
            event.setCanceled(true);
        }
        if (fluid.func_207187_a((Fluid)AllFluids.HONEY.get())) {
            event.setDensity(1.5f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void getFogColor(EntityViewRenderEvent.FogColors event) {
        ActiveRenderInfo info = event.getInfo();
        IFluidState fluidState = info.func_216771_k();
        if (fluidState.func_206888_e()) {
            return;
        }
        Fluid fluid = fluidState.func_206886_c();
        if (fluid.func_207187_a((Fluid)AllFluids.CHOCOLATE.get())) {
            event.setRed(0.3828125f);
            event.setGreen(0.125f);
            event.setBlue(0.125f);
        }
        if (fluid.func_207187_a((Fluid)AllFluids.HONEY.get())) {
            event.setRed(0.9140625f);
            event.setGreen(0.6796875f);
            event.setBlue(0.18359375f);
        }
    }

    @SubscribeEvent
    public static void leftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof ZapperItem) {
            AllPackets.channel.sendToServer((Object)new LeftClickPacket());
        }
    }
}

