/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.advancement;

import com.simibubi.create.content.logistics.InWorldProcessing;
import com.simibubi.create.foundation.advancement.CriterionTriggerBase;
import com.simibubi.create.foundation.advancement.EnumTrigger;
import com.simibubi.create.foundation.advancement.ITriggerable;
import com.simibubi.create.foundation.advancement.RegistryTrigger;
import com.simibubi.create.foundation.advancement.SimpleTrigger;
import com.simibubi.create.foundation.advancement.StringSerializableTrigger;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class AllTriggers {
    private static final List<CriterionTriggerBase<?>> triggers = new LinkedList();
    public static final StringSerializableTrigger<Fluid> INFINITE_FLUID = AllTriggers.add(new RegistryTrigger("infinite_fluid", ForgeRegistries.FLUIDS));
    public static final StringSerializableTrigger<Block> BRACKET_APPLY_TRIGGER = AllTriggers.add(new RegistryTrigger("bracket_apply", ForgeRegistries.BLOCKS));
    public static final StringSerializableTrigger<InWorldProcessing.Type> FAN_PROCESSING = AllTriggers.add(new EnumTrigger<InWorldProcessing.Type>("fan_processing", InWorldProcessing.Type.class));
    public static final SimpleTrigger ROTATION = AllTriggers.simple("rotation");
    public static final SimpleTrigger OVERSTRESSED = AllTriggers.simple("overstressed");
    public static final SimpleTrigger SHIFTING_GEARS = AllTriggers.simple("shifting_gears");
    public static final SimpleTrigger CONNECT_BELT = AllTriggers.simple("connect_belt");
    public static final SimpleTrigger BONK = AllTriggers.simple("bonk");
    public static final SimpleTrigger WATER_WHEEL = AllTriggers.simple("water_wheel");
    public static final SimpleTrigger LAVA_WHEEL = AllTriggers.simple("lava_wheel");
    public static final SimpleTrigger CHOCOLATE_WHEEL = AllTriggers.simple("chocolate_wheel");
    public static final SimpleTrigger DEPLOYER_BOOP = AllTriggers.simple("deployer");
    public static final SimpleTrigger SPEED_READ = AllTriggers.simple("speed_read");
    public static final SimpleTrigger BASIN_THROW = AllTriggers.simple("basin");
    public static final SimpleTrigger PRESS_COMPACT = AllTriggers.simple("compact");
    public static final SimpleTrigger UPGRADED_ZAPPER = AllTriggers.simple("upgraded_zapper");
    public static final SimpleTrigger EXTENDO = AllTriggers.simple("extendo");
    public static final SimpleTrigger GIGA_EXTENDO = AllTriggers.simple("giga_extendo");
    public static final SimpleTrigger MECHANICAL_ARM = AllTriggers.simple("mechanical_arm");
    public static final SimpleTrigger MUSICAL_ARM = AllTriggers.simple("musical_arm");
    public static final SimpleTrigger CUCKOO = AllTriggers.simple("cuckoo");
    public static final SimpleTrigger CASING_SHAFT = AllTriggers.simple("casing_shaft");
    public static final SimpleTrigger CASING_BELT = AllTriggers.simple("casing_belt");
    public static final SimpleTrigger CASING_PIPE = AllTriggers.simple("casing_pipe");
    public static final SimpleTrigger WINDMILL = AllTriggers.simple("windmill");
    public static final SimpleTrigger MAXED_WINDMILL = AllTriggers.simple("maxed_windmill");
    public static final SimpleTrigger PLACE_TUNNEL = AllTriggers.simple("place_tunnel");
    public static final SimpleTrigger CONNECT_TUNNEL = AllTriggers.simple("connect_tunnel");
    public static final SimpleTrigger UPWARD_CHUTE = AllTriggers.simple("upward_chute");
    public static final SimpleTrigger BELT_FUNNEL = AllTriggers.simple("belt_funnel");
    public static final SimpleTrigger BELT_FUNNEL_KISS = AllTriggers.simple("belt_funnel_kiss");
    public static final SimpleTrigger CLOCKWORK_BEARING = AllTriggers.simple("clockwork_bearing");
    public static final SimpleTrigger ARM_MANY_TARGETS = AllTriggers.simple("arm_many_targets");
    public static final SimpleTrigger ARM_BLAZE_BURNER = AllTriggers.simple("arm_blaze_burner");
    public static final SimpleTrigger FLYWHEEL = AllTriggers.simple("flywheel");
    public static final SimpleTrigger OVERSTRESS_FLYWHEEL = AllTriggers.simple("overstress_flywheel");
    public static final SimpleTrigger ITEM_DRAIN = AllTriggers.simple("item_drain");
    public static final SimpleTrigger CHAINED_ITEM_DRAIN = AllTriggers.simple("chained_item_drain");
    public static final SimpleTrigger SPOUT = AllTriggers.simple("spout");
    public static final SimpleTrigger SPOUT_POTION = AllTriggers.simple("spout_potion");
    public static final SimpleTrigger GLASS_PIPE = AllTriggers.simple("glass_pipe");
    public static final SimpleTrigger PIPE_COLLISION = AllTriggers.simple("pipe_collision");
    public static final SimpleTrigger PIPE_SPILL = AllTriggers.simple("pipe_spill");
    public static final SimpleTrigger HOSE_PULLEY = AllTriggers.simple("hose_pulley");
    public static final SimpleTrigger MIXER_MIX = AllTriggers.simple("mixer");

    private static SimpleTrigger simple(String id) {
        return AllTriggers.add(new SimpleTrigger(id));
    }

    private static <T extends CriterionTriggerBase<?>> T add(T instance) {
        triggers.add(instance);
        return instance;
    }

    public static void register() {
        triggers.forEach(CriteriaTriggers::func_192118_a);
    }

    public static void triggerFor(ITriggerable trigger, PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            trigger.trigger((ServerPlayerEntity)player);
        }
    }

    public static void triggerForNearbyPlayers(ITriggerable trigger, World world, BlockPos pos, int range) {
        AllTriggers.triggerForNearbyPlayers(trigger, world, pos, range, player -> true);
    }

    public static void triggerForNearbyPlayers(ITriggerable trigger, World world, BlockPos pos, int range, Predicate<PlayerEntity> playerFilter) {
        if (world == null) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        List<ServerPlayerEntity> players = AllTriggers.getPlayersInRange(world, pos, range);
        players.stream().filter(playerFilter).forEach(trigger::trigger);
    }

    public static List<ServerPlayerEntity> getPlayersInRange(World world, BlockPos pos, int range) {
        return world.func_217357_a(ServerPlayerEntity.class, new AxisAlignedBB(pos).func_186662_g((double)range));
    }
}

