/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block.connected;

import com.simibubi.create.foundation.block.connected.BakedModelWrapperWithData;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;

public class CTModel
extends BakedModelWrapperWithData {
    protected static ModelProperty<CTData> CT_PROPERTY = new ModelProperty();
    private ConnectedTextureBehaviour behaviour;

    public CTModel(IBakedModel originalModel, ConnectedTextureBehaviour behaviour) {
        super(originalModel);
        this.behaviour = behaviour;
    }

    @Override
    protected ModelDataMap.Builder gatherModelData(ModelDataMap.Builder builder, ILightReader world, BlockPos pos, BlockState state) {
        return builder.withInitial(CT_PROPERTY, (Object)this.createCTData(world, pos, state));
    }

    protected CTData createCTData(ILightReader world, BlockPos pos, BlockState state) {
        CTData data = new CTData();
        for (Direction face : Iterate.directions) {
            CTSpriteShiftEntry spriteShift;
            if (!Block.func_176225_a((BlockState)state, (IBlockReader)world, (BlockPos)pos, (Direction)face) && !this.behaviour.buildContextForOccludedDirections() || (spriteShift = this.behaviour.get(state, face)) == null) continue;
            ConnectedTextureBehaviour.CTContext ctContext = this.behaviour.buildContext(world, pos, state, face);
            data.put(face, spriteShift.getTextureIndex(ctContext));
        }
        return data;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(super.getQuads(state, side, rand, extraData));
        if (!extraData.hasProperty(CT_PROPERTY)) {
            return quads;
        }
        CTData data = (CTData)extraData.getData(CT_PROPERTY);
        for (int i = 0; i < quads.size(); ++i) {
            int index;
            BakedQuad quad = (BakedQuad)quads.get(i);
            CTSpriteShiftEntry spriteShift = this.behaviour.get(state, quad.func_178210_d());
            if (spriteShift == null || quad.func_187508_a() != spriteShift.getOriginal() || (index = data.get(quad.func_178210_d())) == -1) continue;
            BakedQuad newQuad = new BakedQuad(Arrays.copyOf(quad.func_178209_a(), quad.func_178209_a().length), quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting());
            VertexFormat format = DefaultVertexFormats.field_176600_a;
            int[] vertexData = newQuad.func_178209_a();
            for (int vertex = 0; vertex < vertexData.length; vertex += format.func_181719_f()) {
                int uvOffset = 4;
                int uIndex = vertex + uvOffset;
                int vIndex = vertex + uvOffset + 1;
                float u = Float.intBitsToFloat(vertexData[uIndex]);
                float v = Float.intBitsToFloat(vertexData[vIndex]);
                vertexData[uIndex] = Float.floatToRawIntBits(spriteShift.getTargetU(u, index));
                vertexData[vIndex] = Float.floatToRawIntBits(spriteShift.getTargetV(v, index));
            }
            quads.set(i, newQuad);
        }
        return quads;
    }

    private class CTData {
        int[] indices = new int[6];

        public CTData() {
            Arrays.fill(this.indices, -1);
        }

        void put(Direction face, int texture) {
            this.indices[face.func_176745_a()] = texture;
        }

        int get(Direction face) {
            return this.indices[face.func_176745_a()];
        }
    }
}

