/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.collision;

import com.simibubi.create.foundation.collision.Matrix3d;
import com.simibubi.create.foundation.collision.OBBCollider;
import net.minecraft.util.math.Vec3d;

public class ContinuousOBBCollider
extends OBBCollider {
    public static ContinuousSeparationManifold separateBBs(Vec3d cA, Vec3d cB, Vec3d eA, Vec3d eB, Matrix3d m, Vec3d motion) {
        ContinuousSeparationManifold mf = new ContinuousSeparationManifold();
        Vec3d diff = cB.func_178788_d(cA);
        m.transpose();
        Vec3d diff2 = m.transform(diff);
        Vec3d motion2 = m.transform(motion);
        m.transpose();
        double a00 = Math.abs(m.m00);
        double a01 = Math.abs(m.m01);
        double a02 = Math.abs(m.m02);
        double a10 = Math.abs(m.m10);
        double a11 = Math.abs(m.m11);
        double a12 = Math.abs(m.m12);
        double a20 = Math.abs(m.m20);
        double a21 = Math.abs(m.m21);
        double a22 = Math.abs(m.m22);
        Vec3d uB0 = new Vec3d(m.m00, m.m10, m.m20);
        Vec3d uB1 = new Vec3d(m.m01, m.m11, m.m21);
        Vec3d uB2 = new Vec3d(m.m02, m.m12, m.m22);
        checkCount = 0;
        mf.stepSeparationAxis = uB1;
        mf.stepSeparation = Double.MAX_VALUE;
        mf.normalSeparation = Double.MAX_VALUE;
        if (!(ContinuousOBBCollider.separate(mf, uA0, diff.field_72450_a, eA.field_72450_a, a00 * eB.field_72450_a + a01 * eB.field_72448_b + a02 * eB.field_72449_c, motion.field_72450_a, true) || ContinuousOBBCollider.separate(mf, uA1, diff.field_72448_b, eA.field_72448_b, a10 * eB.field_72450_a + a11 * eB.field_72448_b + a12 * eB.field_72449_c, motion.field_72448_b, true) || ContinuousOBBCollider.separate(mf, uA2, diff.field_72449_c, eA.field_72449_c, a20 * eB.field_72450_a + a21 * eB.field_72448_b + a22 * eB.field_72449_c, motion.field_72449_c, true) || ContinuousOBBCollider.separate(mf, uB0, diff2.field_72450_a, eA.field_72450_a * a00 + eA.field_72448_b * a10 + eA.field_72449_c * a20, eB.field_72450_a, motion2.field_72450_a, false) || ContinuousOBBCollider.separate(mf, uB1, diff2.field_72448_b, eA.field_72450_a * a01 + eA.field_72448_b * a11 + eA.field_72449_c * a21, eB.field_72448_b, motion2.field_72448_b, false) || ContinuousOBBCollider.separate(mf, uB2, diff2.field_72449_c, eA.field_72450_a * a02 + eA.field_72448_b * a12 + eA.field_72449_c * a22, eB.field_72449_c, motion2.field_72449_c, false))) {
            return mf;
        }
        return null;
    }

    static boolean separate(ContinuousSeparationManifold mf, Vec3d axis, double TL, double rA, double rB, double projectedMotion, boolean axisOfObjA) {
        double dot;
        boolean isBestSeperation;
        boolean discreteCollision;
        ++checkCount;
        double distance = Math.abs(TL);
        double diff = distance - (rA + rB);
        boolean bl = discreteCollision = diff <= 0.0;
        if (!discreteCollision && Math.signum(projectedMotion) == Math.signum(TL)) {
            return true;
        }
        double sTL = Math.signum(TL);
        double seperation = sTL * Math.abs(diff);
        double entryTime = 0.0;
        double exitTime = Double.MAX_VALUE;
        if (!discreteCollision) {
            mf.isDiscreteCollision = false;
            if (Math.abs(seperation) > Math.abs(projectedMotion)) {
                return true;
            }
            entryTime = Math.abs(seperation) / Math.abs(projectedMotion);
            exitTime = (diff + Math.abs(rA) + Math.abs(rB)) / Math.abs(projectedMotion);
            mf.latestCollisionEntryTime = Math.max(entryTime, mf.latestCollisionEntryTime);
            mf.earliestCollisionExitTime = Math.min(exitTime, mf.earliestCollisionExitTime);
        }
        Vec3d normalizedAxis = axis.func_72432_b();
        boolean bl2 = isBestSeperation = distance != 0.0 && -diff <= Math.abs(mf.separation);
        if (axisOfObjA && distance != 0.0 && -diff <= Math.abs(mf.normalSeparation)) {
            mf.normalAxis = normalizedAxis;
            mf.normalSeparation = seperation;
        }
        if ((dot = mf.stepSeparationAxis.func_72430_b(axis)) != 0.0 && discreteCollision) {
            Vec3d cross = axis.func_72431_c(mf.stepSeparationAxis);
            double dotSeparation = Math.signum(dot) * TL - (rA + rB);
            double stepSeparation = -dotSeparation;
            Vec3d stepSeparationVec = axis;
            if (!cross.equals((Object)Vec3d.field_186680_a)) {
                Vec3d sepVec = normalizedAxis.func_186678_a(dotSeparation);
                Vec3d axisPlane = axis.func_72431_c(cross);
                Vec3d stepPlane = mf.stepSeparationAxis.func_72431_c(cross);
                stepSeparationVec = sepVec.func_178788_d(axisPlane.func_186678_a(sepVec.func_72430_b(stepPlane) / axisPlane.func_72430_b(stepPlane)));
                stepSeparation = stepSeparationVec.func_72433_c();
                if (Math.abs(mf.stepSeparation) > Math.abs(stepSeparation) && stepSeparation != 0.0) {
                    mf.stepSeparation = stepSeparation;
                }
            } else if (Math.abs(mf.stepSeparation) > stepSeparation) {
                mf.stepSeparation = stepSeparation;
            }
        }
        if (isBestSeperation) {
            mf.axis = normalizedAxis;
            mf.separation = seperation;
            mf.collisionPosition = normalizedAxis.func_186678_a(Math.signum(TL) * (axisOfObjA ? -rB : -rB) - Math.signum(seperation) * 0.125);
        }
        return false;
    }

    public static class ContinuousSeparationManifold
    extends OBBCollider.SeparationManifold {
        static final double UNDEFINED = -1.0;
        double latestCollisionEntryTime = -1.0;
        double earliestCollisionExitTime = Double.MAX_VALUE;
        boolean isDiscreteCollision = true;
        Vec3d collisionPosition;
        Vec3d stepSeparationAxis;
        double stepSeparation;
        Vec3d normalAxis;
        double normalSeparation;

        public double getTimeOfImpact() {
            if (this.latestCollisionEntryTime == -1.0) {
                return -1.0;
            }
            if (this.latestCollisionEntryTime > this.earliestCollisionExitTime) {
                return -1.0;
            }
            return this.latestCollisionEntryTime;
        }

        public boolean isSurfaceCollision() {
            return true;
        }

        public Vec3d getCollisionNormal() {
            return this.normalAxis == null ? null : this.createSeparationVec(this.normalSeparation, this.normalAxis);
        }

        public Vec3d getCollisionPosition() {
            return this.collisionPosition;
        }

        public Vec3d asSeparationVec(double obbStepHeight) {
            if (this.isDiscreteCollision) {
                if (this.stepSeparation <= obbStepHeight) {
                    return this.createSeparationVec(this.stepSeparation, this.stepSeparationAxis);
                }
                return super.asSeparationVec();
            }
            double t = this.getTimeOfImpact();
            if (t == -1.0) {
                return null;
            }
            return Vec3d.field_186680_a;
        }

        @Override
        public Vec3d asSeparationVec() {
            return this.asSeparationVec(0.0);
        }
    }
}

