/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.collision;

import com.simibubi.create.foundation.collision.ContinuousOBBCollider;
import com.simibubi.create.foundation.collision.Matrix3d;
import com.simibubi.create.foundation.collision.OBBCollider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class OrientedBB {
    Vec3d center;
    Vec3d extents;
    Matrix3d rotation;

    public OrientedBB(AxisAlignedBB bb) {
        this(bb.func_189972_c(), OrientedBB.extentsFromBB(bb), new Matrix3d().asIdentity());
    }

    public OrientedBB() {
        this(Vec3d.field_186680_a, Vec3d.field_186680_a, new Matrix3d().asIdentity());
    }

    public OrientedBB(Vec3d center, Vec3d extents, Matrix3d rotation) {
        this.setCenter(center);
        this.extents = extents;
        this.setRotation(rotation);
    }

    public OrientedBB copy() {
        return new OrientedBB(this.center, this.extents, this.rotation);
    }

    public Vec3d intersect(AxisAlignedBB bb) {
        Vec3d extentsA = OrientedBB.extentsFromBB(bb);
        Vec3d intersects = OBBCollider.separateBBs(bb.func_189972_c(), this.center, extentsA, this.extents, this.rotation);
        return intersects;
    }

    public ContinuousOBBCollider.ContinuousSeparationManifold intersect(AxisAlignedBB bb, Vec3d motion) {
        Vec3d extentsA = OrientedBB.extentsFromBB(bb);
        return ContinuousOBBCollider.separateBBs(bb.func_189972_c(), this.center, extentsA, this.extents, this.rotation, motion);
    }

    private static Vec3d extentsFromBB(AxisAlignedBB bb) {
        return new Vec3d(bb.func_216364_b() / 2.0, bb.func_216360_c() / 2.0, bb.func_216362_d() / 2.0);
    }

    public Matrix3d getRotation() {
        return this.rotation;
    }

    public void setRotation(Matrix3d rotation) {
        this.rotation = rotation;
    }

    public Vec3d getCenter() {
        return this.center;
    }

    public void setCenter(Vec3d center) {
        this.center = center;
    }

    public void move(Vec3d offset) {
        this.setCenter(this.getCenter().func_178787_e(offset));
    }

    public AxisAlignedBB getAsAxisAlignedBB() {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_191194_a(this.center).func_72314_b(this.extents.field_72450_a, this.extents.field_72448_b, this.extents.field_72449_c);
    }
}

