/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.simibubi.create.content.contraptions.components.structureMovement.glue.SuperGlueEntity;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IClearable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.server.ServerWorld;

public class CloneCommand {
    private static final Dynamic2CommandExceptionType CLONE_TOO_BIG_EXCEPTION = new Dynamic2CommandExceptionType((arg1, arg2) -> new TranslationTextComponent("commands.clone.toobig", new Object[]{arg1, arg2}));

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"clone").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197056_a((String)"begin", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"end", (ArgumentType)BlockPosArgument.func_197276_a()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"destination", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197057_a((String)"skipBlocks").executes(ctx -> CloneCommand.doClone((CommandSource)ctx.getSource(), BlockPosArgument.func_197273_a((CommandContext)ctx, (String)"begin"), BlockPosArgument.func_197273_a((CommandContext)ctx, (String)"end"), BlockPosArgument.func_197273_a((CommandContext)ctx, (String)"destination"), false)))).executes(ctx -> CloneCommand.doClone((CommandSource)ctx.getSource(), BlockPosArgument.func_197273_a((CommandContext)ctx, (String)"begin"), BlockPosArgument.func_197273_a((CommandContext)ctx, (String)"end"), BlockPosArgument.func_197273_a((CommandContext)ctx, (String)"destination"), true)))))).executes(ctx -> {
            ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Clones all blocks as well as super glue from the specified area to the target destination"), true);
            return 1;
        });
    }

    private static int doClone(CommandSource source, BlockPos begin, BlockPos end, BlockPos destination, boolean cloneBlocks) throws CommandSyntaxException {
        MutableBoundingBox sourceArea = new MutableBoundingBox((Vec3i)begin, (Vec3i)end);
        BlockPos destinationEnd = destination.func_177971_a(sourceArea.func_175896_b());
        MutableBoundingBox destinationArea = new MutableBoundingBox((Vec3i)destination, (Vec3i)destinationEnd);
        int i = sourceArea.func_78883_b() * sourceArea.func_78882_c() * sourceArea.func_78880_d();
        if (i > 32768) {
            throw CLONE_TOO_BIG_EXCEPTION.create((Object)32768, (Object)i);
        }
        ServerWorld world = source.func_197023_e();
        if (!world.func_175707_a(begin, end) || !world.func_175707_a(destination, destinationEnd)) {
            throw BlockPosArgument.field_197278_b.create();
        }
        BlockPos diffToTarget = new BlockPos(destinationArea.field_78897_a - sourceArea.field_78897_a, destinationArea.field_78895_b - sourceArea.field_78895_b, destinationArea.field_78896_c - sourceArea.field_78896_c);
        int blockPastes = cloneBlocks ? CloneCommand.cloneBlocks(sourceArea, world, diffToTarget) : 0;
        int gluePastes = CloneCommand.cloneGlue(sourceArea, world, diffToTarget);
        if (cloneBlocks) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Successfully cloned " + blockPastes + " Blocks"), true);
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Successfully applied glue " + gluePastes + " times"), true);
        return blockPastes + gluePastes;
    }

    private static int cloneGlue(MutableBoundingBox sourceArea, ServerWorld world, BlockPos diffToTarget) {
        int gluePastes = 0;
        List glue = world.func_217357_a(SuperGlueEntity.class, AxisAlignedBB.func_216363_a((MutableBoundingBox)sourceArea));
        ArrayList newGlue = Lists.newArrayList();
        for (SuperGlueEntity g : glue) {
            BlockPos pos = g.getHangingPosition();
            Direction direction = g.getFacingDirection();
            newGlue.add(Pair.of(pos.func_177971_a((Vec3i)diffToTarget), direction));
        }
        for (Pair p : newGlue) {
            SuperGlueEntity g = new SuperGlueEntity((World)world, (BlockPos)p.getFirst(), (Direction)p.getSecond());
            if (!g.onValidSurface()) continue;
            world.func_217376_c((Entity)g);
            ++gluePastes;
        }
        return gluePastes;
    }

    private static int cloneBlocks(MutableBoundingBox sourceArea, ServerWorld world, BlockPos diffToTarget) {
        TileEntity te;
        int blockPastes = 0;
        ArrayList blocks = Lists.newArrayList();
        ArrayList tileBlocks = Lists.newArrayList();
        for (int z = sourceArea.field_78896_c; z <= sourceArea.field_78892_f; ++z) {
            for (int y = sourceArea.field_78895_b; y <= sourceArea.field_78894_e; ++y) {
                for (int x = sourceArea.field_78897_a; x <= sourceArea.field_78893_d; ++x) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    BlockPos newPos = currentPos.func_177971_a((Vec3i)diffToTarget);
                    CachedBlockInfo cached = new CachedBlockInfo((IWorldReader)world, currentPos, false);
                    BlockState state = cached.func_177509_a();
                    TileEntity te2 = world.func_175625_s(currentPos);
                    if (te2 != null) {
                        CompoundNBT nbt = te2.func_189515_b(new CompoundNBT());
                        tileBlocks.add(new Template.BlockInfo(newPos, state, nbt));
                        continue;
                    }
                    blocks.add(new Template.BlockInfo(newPos, state, null));
                }
            }
        }
        ArrayList allBlocks = Lists.newArrayList();
        allBlocks.addAll(blocks);
        allBlocks.addAll(tileBlocks);
        List reverse = Lists.reverse((List)allBlocks);
        for (Template.BlockInfo info : reverse) {
            te = world.func_175625_s(info.field_186242_a);
            IClearable.func_213131_a((Object)te);
            world.func_180501_a(info.field_186242_a, Blocks.field_180401_cv.func_176223_P(), 2);
        }
        for (Template.BlockInfo info : allBlocks) {
            if (!world.func_180501_a(info.field_186242_a, info.field_186243_b, 2)) continue;
            ++blockPastes;
        }
        for (Template.BlockInfo info : tileBlocks) {
            te = world.func_175625_s(info.field_186242_a);
            if (te != null && info.field_186244_c != null) {
                info.field_186244_c.func_74768_a("x", info.field_186242_a.func_177958_n());
                info.field_186244_c.func_74768_a("y", info.field_186242_a.func_177956_o());
                info.field_186244_c.func_74768_a("z", info.field_186242_a.func_177952_p());
                te.func_145839_a(info.field_186244_c);
                te.func_70296_d();
            }
            world.func_180501_a(info.field_186242_a, info.field_186243_b, 2);
        }
        for (Template.BlockInfo info : reverse) {
            world.func_195592_c(info.field_186242_a, info.field_186243_b.func_177230_c());
        }
        world.func_205220_G_().func_205368_a(sourceArea, diffToTarget);
        return blockPastes;
    }
}

