/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.utility.ColorHelper;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class UIRenderHelper {
    public static Framebuffer framebuffer;

    public static void init() {
        RenderSystem.recordRenderCall(() -> {
            MainWindow mainWindow = Minecraft.func_71410_x().func_228018_at_();
            framebuffer = new Framebuffer(mainWindow.func_198109_k(), mainWindow.func_198091_l(), true, Minecraft.field_142025_a);
            framebuffer.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        });
    }

    public static void prepFramebufferSize() {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        if (UIRenderHelper.framebuffer.field_147621_c != window.func_198109_k() || UIRenderHelper.framebuffer.field_147618_d != window.func_198091_l()) {
            framebuffer.func_216491_a(window.func_198109_k(), window.func_198091_l(), Minecraft.field_142025_a);
        }
    }

    public static void drawFramebuffer(float alpha) {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        float vx = window.func_198107_o();
        float vy = window.func_198087_p();
        float tx = (float)UIRenderHelper.framebuffer.field_147621_c / (float)UIRenderHelper.framebuffer.field_147622_a;
        float ty = (float)UIRenderHelper.framebuffer.field_147618_d / (float)UIRenderHelper.framebuffer.field_147620_b;
        RenderSystem.enableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableLighting();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        framebuffer.func_147612_c();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_225582_a_(0.0, (double)vy, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)vx, (double)vy, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(tx, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)vx, 0.0, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(tx, ty).func_181675_d();
        bufferbuilder.func_225582_a_(0.0, 0.0, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(0.0f, ty).func_181675_d();
        tessellator.func_78381_a();
        framebuffer.func_147606_d();
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
    }

    public static void streak(float angle, int x, int y, int width, int length, int color) {
        int a1 = -1610612736;
        int a2 = Integer.MIN_VALUE;
        int a3 = 0x10000000;
        int a4 = 0;
        int c1 = a1 | (color &= 0xFFFFFF);
        int c2 = a2 | color;
        int c3 = a3 | color;
        int c4 = a4 | color;
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)x, (double)y, (double)0.0);
        RenderSystem.rotatef((float)(angle - 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        UIRenderHelper.streak(width / 2, length, c1, c2, c3, c4);
        RenderSystem.popMatrix();
    }

    private static void streak(int width, int height, int c1, int c2, int c3, int c4) {
        double split1 = 0.5;
        double split2 = 0.75;
        GuiUtils.drawGradientRect((int)0, (int)(-width), (int)0, (int)width, (int)((int)(split1 * (double)height)), (int)c1, (int)c2);
        GuiUtils.drawGradientRect((int)0, (int)(-width), (int)((int)(split1 * (double)height)), (int)width, (int)((int)(split2 * (double)height)), (int)c2, (int)c3);
        GuiUtils.drawGradientRect((int)0, (int)(-width), (int)((int)(split2 * (double)height)), (int)width, (int)height, (int)c3, (int)c4);
    }

    public static void breadcrumbArrow(int x, int y, int width, int height, int indent, int startColor, int endColor) {
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)(x - indent), (double)y, (double)0.0);
        UIRenderHelper.breadcrumbArrow(width, height, indent, startColor, endColor);
        RenderSystem.popMatrix();
    }

    private static void breadcrumbArrow(int width, int height, int indent, int c1, int c2) {
        double x0 = 0.0;
        double y0 = (double)height / 2.0;
        double x1 = indent;
        double y1 = 0.0;
        double x2 = indent;
        double y2 = (double)height / 2.0;
        double x3 = indent;
        double y3 = height;
        double x4 = width;
        double y4 = 0.0;
        double x5 = width;
        double y5 = (double)height / 2.0;
        double x6 = width;
        double y6 = height;
        double x7 = indent + width;
        double y7 = 0.0;
        double x8 = indent + width;
        double y8 = height;
        int fc1 = ColorHelper.mixAlphaColors(c1, c2, 0.0f);
        int fc2 = ColorHelper.mixAlphaColors(c1, c2, (float)indent / ((float)width + 2.0f * (float)indent));
        int fc3 = ColorHelper.mixAlphaColors(c1, c2, (float)(indent + width) / ((float)width + 2.0f * (float)indent));
        int fc4 = ColorHelper.mixAlphaColors(c1, c2, 1.0f);
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(4, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_(x0, y0, 0.0).func_225586_a_(fc1 >> 16 & 0xFF, fc1 >> 8 & 0xFF, fc1 & 0xFF, fc1 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_225582_a_(x1, y1, 0.0).func_225586_a_(fc2 >> 16 & 0xFF, fc2 >> 8 & 0xFF, fc2 & 0xFF, fc2 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_225582_a_(x2, y2, 0.0).func_225586_a_(fc2 >> 16 & 0xFF, fc2 >> 8 & 0xFF, fc2 & 0xFF, fc2 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_225582_a_(x0, y0, 0.0).func_225586_a_(fc1 >> 16 & 0xFF, fc1 >> 8 & 0xFF, fc1 & 0xFF, fc1 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_225582_a_(x2, y2, 0.0).func_225586_a_(fc2 >> 16 & 0xFF, fc2 >> 8 & 0xFF, fc2 & 0xFF, fc2 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_225582_a_(x3, y3, 0.0).func_225586_a_(fc2 >> 16 & 0xFF, fc2 >> 8 & 0xFF, fc2 & 0xFF, fc2 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_225582_a_(x3, y3, 0.0).func_225586_a_(fc2 >> 16 & 0xFF, fc2 >> 8 & 0xFF, fc2 & 0xFF, fc2 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_225582_a_(x1, y1, 0.0).func_225586_a_(fc2 >> 16 & 0xFF, fc2 >> 8 & 0xFF, fc2 & 0xFF, fc2 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_225582_a_(x4, y4, 0.0).func_225586_a_(fc3 >> 16 & 0xFF, fc3 >> 8 & 0xFF, fc3 & 0xFF, fc3 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_225582_a_(x3, y3, 0.0).func_225586_a_(fc2 >> 16 & 0xFF, fc2 >> 8 & 0xFF, fc2 & 0xFF, fc2 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_225582_a_(x4, y4, 0.0).func_225586_a_(fc3 >> 16 & 0xFF, fc3 >> 8 & 0xFF, fc3 & 0xFF, fc3 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_225582_a_(x6, y6, 0.0).func_225586_a_(fc3 >> 16 & 0xFF, fc3 >> 8 & 0xFF, fc3 & 0xFF, fc3 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_225582_a_(x5, y5, 0.0).func_225586_a_(fc3 >> 16 & 0xFF, fc3 >> 8 & 0xFF, fc3 & 0xFF, fc3 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_225582_a_(x4, y4, 0.0).func_225586_a_(fc3 >> 16 & 0xFF, fc3 >> 8 & 0xFF, fc3 & 0xFF, fc3 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_225582_a_(x7, y7, 0.0).func_225586_a_(fc4 >> 16 & 0xFF, fc4 >> 8 & 0xFF, fc4 & 0xFF, fc4 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_225582_a_(x6, y6, 0.0).func_225586_a_(fc3 >> 16 & 0xFF, fc3 >> 8 & 0xFF, fc3 & 0xFF, fc3 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_225582_a_(x5, y5, 0.0).func_225586_a_(fc3 >> 16 & 0xFF, fc3 >> 8 & 0xFF, fc3 & 0xFF, fc3 >> 24 & 0xFF).func_181675_d();
        bufferbuilder.func_225582_a_(x8, y8, 0.0).func_225586_a_(fc4 >> 16 & 0xFF, fc4 >> 8 & 0xFF, fc4 & 0xFF, fc4 >> 24 & 0xFF).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }
}

