/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui.widgets;

import com.simibubi.create.foundation.gui.widgets.ScrollInput;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public class SelectionScrollInput
extends ScrollInput {
    private final String scrollToSelect = Lang.translate("gui.scrollInput.scrollToSelect", new Object[0]);
    protected List<String> options = new ArrayList<String>();

    public SelectionScrollInput(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
    }

    public ScrollInput forOptions(List<String> options) {
        this.options = options;
        this.max = options.size();
        this.updateTooltip();
        return this;
    }

    @Override
    protected void writeToLabel() {
        this.displayLabel.text = this.options.get(this.state);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        return super.mouseScrolled(mouseX, mouseY, -delta);
    }

    @Override
    protected void updateTooltip() {
        this.toolTip.clear();
        this.toolTip.add(TextFormatting.BLUE + this.title);
        int min = Math.min(this.max - 16, this.state - 7);
        int max = Math.max(this.min + 16, this.state + 8);
        min = Math.max(min, this.min);
        max = Math.min(max, this.max);
        if (this.min + 1 == min) {
            --min;
        }
        if (min > this.min) {
            this.toolTip.add(TextFormatting.GRAY + "> ...");
        }
        if (this.max - 1 == max) {
            ++max;
        }
        for (int i = min; i < max; ++i) {
            StringBuilder result = new StringBuilder();
            if (i == this.state) {
                result.append(TextFormatting.WHITE).append("-> ").append(this.options.get(i));
            } else {
                result.append(TextFormatting.GRAY).append("> ").append(this.options.get(i));
            }
            this.toolTip.add(result.toString());
        }
        if (max < this.max) {
            this.toolTip.add(TextFormatting.GRAY + "> ...");
        }
        this.toolTip.add(TextFormatting.DARK_GRAY + "" + TextFormatting.ITALIC + this.scrollToSelect);
    }
}

