/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.ponder.content.PonderTag;
import com.simibubi.create.foundation.ponder.content.PonderTagScreen;
import com.simibubi.create.foundation.ponder.ui.PonderButton;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class NavigatableSimiScreen
extends AbstractSimiScreen {
    public static final String THINK_BACK = "ponder.think_back";
    protected int depthPointX;
    protected int depthPointY;
    public final LerpedFloat transition = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.LINEAR);
    protected final LerpedFloat arrowAnimation = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.075f, LerpedFloat.Chaser.LINEAR);
    protected PonderButton backTrack;

    public NavigatableSimiScreen() {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        this.depthPointX = window.func_198107_o() / 2;
        this.depthPointY = window.func_198087_p() / 2;
    }

    public void onClose() {
        ScreenOpener.clearStack();
        super.onClose();
    }

    public void tick() {
        super.tick();
        this.transition.tickChaser();
        this.arrowAnimation.tickChaser();
    }

    protected void init() {
        super.init();
        this.backTrack = null;
        List<Screen> screenHistory = ScreenOpener.getScreenHistory();
        if (screenHistory.isEmpty()) {
            return;
        }
        if (!(screenHistory.get(0) instanceof NavigatableSimiScreen)) {
            return;
        }
        Screen screen = screenHistory.get(0);
        PonderTag icon = null;
        ItemStack altIcon = null;
        if (screen instanceof PonderUI) {
            altIcon = ((PonderUI)screen).stack;
        }
        if (screen instanceof PonderTagScreen) {
            icon = ((PonderTagScreen)screen).getTag();
        }
        this.backTrack = new PonderButton(31, this.height - 31 - 20, () -> ScreenOpener.openPreviousScreen(this, Optional.empty())).fade(0, -1);
        this.widgets.add(this.backTrack);
        this.backTrack.fade(1.0f);
        if (icon != null) {
            this.backTrack.showing(icon);
        }
        if (altIcon != null) {
            this.backTrack.showing(altIcon);
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (this.backTrack == null) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)500.0);
        if (this.backTrack.isHovered()) {
            this.drawString(this.font, Lang.translate(THINK_BACK, new Object[0]), 15, this.height - 16, -6052957);
            if (MathHelper.func_180185_a((float)this.arrowAnimation.getValue(), (float)this.arrowAnimation.getChaseTarget())) {
                this.arrowAnimation.setValue(1.0);
                this.arrowAnimation.setValue(1.0);
            }
        }
        RenderSystem.popMatrix();
    }

    @Override
    protected void renderWindowBackground(int mouseX, int mouseY, float partialTicks) {
        if (this.transition.getChaseTarget() == 0.0f) {
            this.renderBackground();
            return;
        }
        this.renderBackground();
        Screen lastScreen = ScreenOpener.getPreviouslyRenderedScreen();
        float transitionValue = this.transition.getValue(partialTicks);
        double scale = 1.0 + 0.5 * (double)transitionValue;
        if (lastScreen != null && lastScreen != this && !this.transition.settled()) {
            RenderSystem.pushMatrix();
            UIRenderHelper.framebuffer.func_216493_b(Minecraft.field_142025_a);
            UIRenderHelper.prepFramebufferSize();
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)0.0, (double)0.0, (double)-1000.0);
            UIRenderHelper.framebuffer.func_147610_a(true);
            lastScreen.render(mouseX, mouseY, 10.0f);
            RenderSystem.popMatrix();
            Minecraft.func_71410_x().func_147110_a().func_147610_a(true);
            MainWindow window = Minecraft.func_71410_x().func_228018_at_();
            int dpx = window.func_198107_o() / 2;
            int dpy = window.func_198087_p() / 2;
            if (lastScreen instanceof AbstractSimiScreen) {
                dpx = ((NavigatableSimiScreen)lastScreen).depthPointX;
                dpy = ((NavigatableSimiScreen)lastScreen).depthPointY;
            }
            RenderSystem.translated((double)dpx, (double)dpy, (double)0.0);
            RenderSystem.scaled((double)scale, (double)scale, (double)1.0);
            RenderSystem.translated((double)(-dpx), (double)(-dpy), (double)0.0);
            UIRenderHelper.drawFramebuffer(1.0f - Math.abs(transitionValue));
            RenderSystem.popMatrix();
        }
        scale = transitionValue > 0.0f ? 1.0 - 0.5 * (double)(1.0f - transitionValue) : 1.0 + 0.5 * (double)(1.0f + transitionValue);
        RenderSystem.translated((double)this.depthPointX, (double)this.depthPointY, (double)0.0);
        RenderSystem.scaled((double)scale, (double)scale, (double)1.0);
        RenderSystem.translated((double)(-this.depthPointX), (double)(-this.depthPointY), (double)0.0);
        if (this.backTrack != null) {
            int x = (int)MathHelper.func_219799_g((float)this.arrowAnimation.getValue(partialTicks), (float)-9.0f, (float)21.0f);
            int maxX = this.backTrack.x + this.backTrack.getWidth();
            if (x + 30 < this.backTrack.x) {
                UIRenderHelper.breadcrumbArrow(x + 30, this.height - 51, maxX - (x + 30), 20, 5, 1084922265, 279615897);
            }
            UIRenderHelper.breadcrumbArrow(x, this.height - 51, 30, 20, 5, 1084922265, 279615897);
            UIRenderHelper.breadcrumbArrow(x - 30, this.height - 51, 30, 20, 5, 1084922265, 279615897);
        }
    }

    @Override
    public boolean keyPressed(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (code == 259) {
            ScreenOpener.openPreviousScreen(this, Optional.empty());
            return true;
        }
        return super.keyPressed(code, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void centerScalingOn(int x, int y) {
        this.depthPointX = x;
        this.depthPointY = y;
    }

    public void centerScalingOnMouse() {
        MainWindow w = this.minecraft.func_228018_at_();
        double mouseX = this.minecraft.field_71417_B.func_198024_e() * (double)w.func_198107_o() / (double)w.func_198105_m();
        double mouseY = this.minecraft.field_71417_B.func_198026_f() * (double)w.func_198087_p() / (double)w.func_198083_n();
        this.centerScalingOn((int)mouseX, (int)mouseY);
    }

    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        return false;
    }

    public void shareContextWith(NavigatableSimiScreen other) {
    }

    protected void renderZeloBreadcrumbs(int mouseX, int mouseY, float partialTicks) {
        List<Screen> history = ScreenOpener.getScreenHistory();
        if (history.isEmpty()) {
            return;
        }
        history.add(0, Minecraft.func_71410_x().field_71462_r);
        int spacing = 20;
        List<String> names = history.stream().map(NavigatableSimiScreen::screenTitle).collect(Collectors.toList());
        int bWidth = names.stream().mapToInt(s -> this.font.func_78256_a(s) + spacing).sum();
        MutableInt x = new MutableInt(this.width - bWidth);
        MutableInt y = new MutableInt(this.height - 18);
        MutableBoolean first = new MutableBoolean(true);
        if (x.getValue() < 25) {
            x.setValue(25);
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)600.0);
        names.forEach(s -> {
            int sWidth = this.font.func_78256_a(s);
            UIRenderHelper.breadcrumbArrow(x.getValue(), y.getValue(), sWidth + spacing, 14, spacing / 2, -586149872, 0x44101010);
            this.drawString(this.font, (String)s, x.getValue() + 5, y.getValue() + 3, first.getValue() != false ? -1114130 : -2232577);
            first.setFalse();
            x.add(sWidth + spacing);
        });
        RenderSystem.popMatrix();
    }

    private static String screenTitle(Screen screen) {
        if (screen instanceof NavigatableSimiScreen) {
            return ((NavigatableSimiScreen)screen).getBreadcrumbTitle();
        }
        return "<";
    }

    protected String getBreadcrumbTitle() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

