/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import java.util.HashMap;
import java.util.Map;

public class PonderLocalization {
    static Map<String, String> shared = new HashMap<String, String>();
    static Map<String, Couple<String>> tag = new HashMap<String, Couple<String>>();
    static Map<String, Map<String, String>> specific = new HashMap<String, Map<String, String>>();
    public static final String LANG_PREFIX = "ponder.";

    public static void registerTag(String key, String enUS, String description) {
        tag.put(key, Couple.create(enUS, description));
    }

    public static void registerShared(String key, String enUS) {
        shared.put(key, enUS);
    }

    public static void registerSpecific(String sceneId, String key, String enUS) {
        specific.computeIfAbsent(sceneId, $ -> new HashMap()).put(key, enUS);
    }

    public static String getShared(String key) {
        return Lang.translate(PonderLocalization.langKeyForShared(key), new Object[0]);
    }

    public static String getSpecific(String sceneId, String k) {
        return Lang.translate(PonderLocalization.langKeyForSpecific(sceneId, k), new Object[0]);
    }

    public static String getTag(String key) {
        return Lang.translate(PonderLocalization.langKeyForTag(key), new Object[0]);
    }

    public static String getTagDescription(String key) {
        return Lang.translate(PonderLocalization.langKeyForTagDescription(key), new Object[0]);
    }

    public static JsonElement record() {
        JsonObject object = new JsonObject();
        PonderLocalization.addGeneral(object, "ponder.hold_to_ponder", "Hold [%1$s] to Ponder");
        PonderLocalization.addGeneral(object, "ponder.subject", "Subject of this scene");
        PonderLocalization.addGeneral(object, "ponder.pondering", "Pondering about...");
        PonderLocalization.addGeneral(object, "ponder.identify_mode", "Identify mode active.\nUnpause with [%1$s]");
        PonderLocalization.addGeneral(object, "ponder.associated", "Associated Entries");
        PonderLocalization.addGeneral(object, "ponder.close", "Close");
        PonderLocalization.addGeneral(object, "ponder.identify", "Identify");
        PonderLocalization.addGeneral(object, "ponder.next", "Next Scene");
        PonderLocalization.addGeneral(object, "ponder.previous", "Previous Scene");
        PonderLocalization.addGeneral(object, "ponder.replay", "Replay");
        PonderLocalization.addGeneral(object, "ponder.think_back", "Think Back");
        PonderLocalization.addGeneral(object, "ponder.slow_text", "Comfy Reading");
        shared.forEach((k, v) -> object.addProperty("create." + PonderLocalization.langKeyForShared(k), v));
        tag.forEach((k, v) -> {
            object.addProperty("create." + PonderLocalization.langKeyForTag(k), (String)v.getFirst());
            object.addProperty("create." + PonderLocalization.langKeyForTagDescription(k), (String)v.getSecond());
        });
        specific.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((Map)entry.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(subEntry -> object.addProperty("create." + PonderLocalization.langKeyForSpecific((String)entry.getKey(), (String)subEntry.getKey()), (String)subEntry.getValue())));
        return object;
    }

    private static void addGeneral(JsonObject json, String key, String enUS) {
        json.addProperty("create." + key, enUS);
    }

    protected static String langKeyForSpecific(String sceneId, String k) {
        return LANG_PREFIX + sceneId + "." + k;
    }

    protected static String langKeyForShared(String k) {
        return "ponder.shared." + k;
    }

    protected static String langKeyForTag(String k) {
        return "ponder.tag." + k;
    }

    protected static String langKeyForTagDescription(String k) {
        return "ponder.tag." + k + ".description";
    }
}

