/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.antlr.v4.runtime.misc.IntegerList;

public class PonderProgressBar
extends AbstractSimiWidget {
    LerpedFloat progress;
    LerpedFloat flash;
    PonderUI ponder;

    public PonderProgressBar(PonderUI ponder, int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        this.ponder = ponder;
        this.progress = LerpedFloat.linear().startWithValue(0.0);
        this.flash = LerpedFloat.linear().startWithValue(0.0);
    }

    public void tick() {
        this.progress.chase(this.ponder.getActiveScene().getSceneProgress(), 0.5, LerpedFloat.Chaser.EXP);
        this.progress.tickChaser();
        if (this.isHovered) {
            this.flash();
        }
    }

    public void flash() {
        float value = this.flash.getValue();
        this.flash.setValue(value + (1.0f - value) * 0.2f);
    }

    public void dim() {
        float value = this.flash.getValue();
        this.flash.setValue(value * 0.5f);
    }

    protected boolean clicked(double mouseX, double mouseY) {
        return this.active && this.visible && !this.ponder.getActiveScene().keyframeTimes.isEmpty() && mouseX >= (double)this.x && mouseX < (double)(this.x + this.width + 4) && mouseY >= (double)this.y - 3.0 && mouseY < (double)(this.y + this.height + 20);
    }

    public void onClick(double mouseX, double mouseY) {
        PonderScene activeScene = this.ponder.getActiveScene();
        IntegerList keyframeTimes = activeScene.keyframeTimes;
        int keyframeIndex = this.getHoveredKeyframeIndex(activeScene, mouseX);
        if (keyframeIndex == -1) {
            this.ponder.seekToTime(0);
        } else if (keyframeIndex == keyframeTimes.size()) {
            this.ponder.seekToTime(activeScene.totalTime);
        } else {
            this.ponder.seekToTime(keyframeTimes.get(keyframeIndex));
        }
    }

    public int getHoveredKeyframeIndex(PonderScene activeScene, double mouseX) {
        int keyframeTime;
        IntegerList keyframeTimes = activeScene.keyframeTimes;
        int totalTime = activeScene.totalTime;
        int clickedAtTime = (int)((mouseX - (double)this.x) / ((double)this.width + 4.0) * (double)totalTime);
        int lastKeyframeTime = keyframeTimes.get(keyframeTimes.size() - 1);
        int diffToEnd = totalTime - clickedAtTime;
        int diffToLast = clickedAtTime - lastKeyframeTime;
        if (diffToEnd > 0 && diffToEnd < diffToLast / 2) {
            return keyframeTimes.size();
        }
        int index = -1;
        int i = 0;
        while (i < keyframeTimes.size() && (keyframeTime = keyframeTimes.get(i)) <= clickedAtTime) {
            index = i++;
        }
        return index;
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        this.isHovered = this.clicked(mouseX, mouseY);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)400.0);
        PonderUI.renderBox(this.x, this.y, this.width, this.height, false);
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)(this.x - 2), (double)(this.y - 2), (double)0.0);
        RenderSystem.pushMatrix();
        RenderSystem.scaled((double)((float)(this.width + 4) * this.progress.getValue(partialTicks)), (double)1.0, (double)1.0);
        GuiUtils.drawGradientRect((int)500, (int)0, (int)3, (int)1, (int)4, (int)-2130710819, (int)-2130710819);
        GuiUtils.drawGradientRect((int)500, (int)0, (int)4, (int)1, (int)5, (int)1358950109, (int)1358950109);
        RenderSystem.popMatrix();
        this.renderKeyframes(mouseX, partialTicks);
        RenderSystem.popMatrix();
    }

    private void renderKeyframes(int mouseX, float partialTicks) {
        int hoverStartColor;
        int hoverEndColor;
        int hoverIndex;
        PonderScene activeScene = this.ponder.getActiveScene();
        if (this.isHovered) {
            hoverIndex = this.getHoveredKeyframeIndex(activeScene, mouseX);
            float flashValue = this.flash.getValue(partialTicks) * 3.0f + (float)Math.sin(((float)AnimationTickHolder.getTicks() + partialTicks) / 6.0f);
            hoverEndColor = ColorHelper.applyAlpha(0x70FFFFFF, flashValue);
            hoverStartColor = ColorHelper.applyAlpha(0x30FFFFFF, flashValue);
        } else {
            hoverIndex = -2;
            hoverEndColor = 0;
            hoverStartColor = 0;
        }
        IntegerList keyframeTimes = activeScene.keyframeTimes;
        if (hoverIndex == -1) {
            this.drawKeyframe(activeScene, true, 0, 0, hoverStartColor, hoverEndColor, 8);
        } else if (hoverIndex == keyframeTimes.size()) {
            this.drawKeyframe(activeScene, true, activeScene.totalTime, this.width + 4, hoverStartColor, hoverEndColor, 8);
        }
        for (int i = 0; i < keyframeTimes.size(); ++i) {
            int keyframeTime = keyframeTimes.get(i);
            int keyframePos = (int)((float)keyframeTime / (float)activeScene.totalTime * (float)(this.width + 4));
            boolean selected = i == hoverIndex;
            int startColor = selected ? hoverStartColor : 822079197;
            int endColor = selected ? hoverEndColor : 1627385565;
            int height = selected ? 8 : 4;
            this.drawKeyframe(activeScene, selected, keyframeTime, keyframePos, startColor, endColor, height);
        }
    }

    private void drawKeyframe(PonderScene activeScene, boolean selected, int keyframeTime, int keyframePos, int startColor, int endColor, int height) {
        if (selected) {
            int offset;
            String text;
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            GuiUtils.drawGradientRect((int)500, (int)keyframePos, (int)10, (int)(keyframePos + 1), (int)(10 + height), (int)endColor, (int)startColor);
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)0.0, (double)0.0, (double)400.0);
            if (activeScene.currentTime < keyframeTime) {
                text = ">";
                offset = -1 - font.func_78256_a(text);
            } else {
                text = "<";
                offset = 3;
            }
            font.func_211126_b(text, (float)(keyframePos + offset), 10.0f, endColor);
            RenderSystem.popMatrix();
        }
        GuiUtils.drawGradientRect((int)500, (int)keyframePos, (int)-1, (int)(keyframePos + 1), (int)(2 + height), (int)startColor, (int)endColor);
    }

    public void playDownSound(SoundHandler handler) {
    }
}

