/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.google.common.base.Strings;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.ponder.NavigatableSimiScreen;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderTooltipEvent;

public class PonderTooltipHandler {
    static LerpedFloat holdWProgress = LerpedFloat.linear().startWithValue(0.0);
    static ItemStack hoveredStack = ItemStack.field_190927_a;
    static ItemStack trackingStack = ItemStack.field_190927_a;
    static boolean subject = false;
    static boolean deferTick = false;
    public static final String HOLD_TO_PONDER = "ponder.hold_to_ponder";
    public static final String SUBJECT = "ponder.subject";

    public static void tick() {
        deferTick = true;
    }

    public static void deferredTick() {
        deferTick = false;
        if (hoveredStack.func_190926_b() || trackingStack.func_190926_b()) {
            trackingStack = ItemStack.field_190927_a;
            holdWProgress.startWithValue(0.0);
            return;
        }
        Minecraft instance = Minecraft.func_71410_x();
        Screen currentScreen = instance.field_71462_r;
        float value = holdWProgress.getValue();
        int keyCode = PonderTooltipHandler.ponderKeybind().getKey().func_197937_c();
        long window = instance.func_228018_at_().func_198092_i();
        if (!subject && InputMappings.func_216506_a((long)window, (int)keyCode)) {
            if (value >= 1.0f) {
                if (currentScreen instanceof NavigatableSimiScreen) {
                    ((NavigatableSimiScreen)currentScreen).centerScalingOnMouse();
                }
                ScreenOpener.transitionTo(PonderUI.of(trackingStack));
                holdWProgress.startWithValue(0.0);
                return;
            }
            holdWProgress.setValue(Math.min(1.0f, value + Math.max(0.25f, value) * 0.25f));
        } else {
            holdWProgress.setValue(Math.max(0.0f, value - 0.05f));
        }
        hoveredStack = ItemStack.field_190927_a;
    }

    public static void addToTooltip(List<ITextComponent> toolTip, ItemStack stack) {
        ITextComponent component;
        PonderTooltipHandler.updateHovered(stack);
        if (deferTick) {
            PonderTooltipHandler.deferredTick();
        }
        if (trackingStack != stack) {
            return;
        }
        float renderPartialTicks = Minecraft.func_71410_x().func_184121_ak();
        ITextComponent iTextComponent = component = subject ? Lang.createTranslationTextComponent(SUBJECT, new Object[0]).func_211708_a(TextFormatting.GREEN) : PonderTooltipHandler.makeProgressBar(Math.min(1.0f, holdWProgress.getValue(renderPartialTicks) * 8.0f / 7.0f));
        if (toolTip.size() < 2) {
            toolTip.add(component);
        } else {
            toolTip.add(1, component);
        }
    }

    protected static void updateHovered(ItemStack stack) {
        PonderUI ponderUI;
        Minecraft instance = Minecraft.func_71410_x();
        Screen currentScreen = instance.field_71462_r;
        ItemStack prevStack = trackingStack;
        hoveredStack = ItemStack.field_190927_a;
        subject = false;
        if (currentScreen instanceof PonderUI && stack.func_77969_a((ponderUI = (PonderUI)currentScreen).getSubject())) {
            subject = true;
        }
        if (stack.func_190926_b()) {
            return;
        }
        if (!PonderRegistry.all.containsKey(stack.func_77973_b().getRegistryName())) {
            return;
        }
        if (prevStack.func_190926_b() || !prevStack.func_77969_a(stack)) {
            holdWProgress.startWithValue(0.0);
        }
        hoveredStack = stack;
        trackingStack = stack;
    }

    public static void handleTooltipColor(RenderTooltipEvent.Color event) {
        if (trackingStack != event.getStack()) {
            return;
        }
        if (holdWProgress.getValue() == 0.0f) {
            return;
        }
        float renderPartialTicks = Minecraft.func_71410_x().func_184121_ak();
        int start = event.getOriginalBorderStart();
        int end = event.getOriginalBorderEnd();
        float progress = Math.min(1.0f, holdWProgress.getValue(renderPartialTicks) * 8.0f / 7.0f);
        start = PonderTooltipHandler.getSmoothColorForProgress(progress);
        end = PonderTooltipHandler.getSmoothColorForProgress(progress);
        event.setBorderStart(start | 0xA0000000);
        event.setBorderEnd(end | 0xA0000000);
    }

    private static int getSmoothColorForProgress(float progress) {
        if (progress < 0.5f) {
            return ColorHelper.mixColors(0x5000FF, 0x5555FF, progress * 2.0f);
        }
        return ColorHelper.mixColors(0x5555FF, 0xFFFFFF, (progress - 0.5f) * 2.0f);
    }

    private static ITextComponent makeProgressBar(float progress) {
        String localizedName = PonderTooltipHandler.ponderKeybind().getKeyBinding().func_197978_k();
        String holdW = Lang.createTranslationTextComponent(HOLD_TO_PONDER, new StringTextComponent(localizedName).func_211708_a(TextFormatting.GRAY)).func_211708_a(TextFormatting.DARK_GRAY).func_150254_d();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        float charWidth = fontRenderer.func_78256_a("|");
        float tipWidth = fontRenderer.func_78256_a(holdW);
        int total = (int)(tipWidth / charWidth);
        int current = (int)(progress * (float)total);
        if (progress > 0.0f) {
            String bars = "";
            bars = bars + TextFormatting.GRAY + Strings.repeat((String)"|", (int)current);
            if (progress < 1.0f) {
                bars = bars + TextFormatting.DARK_GRAY + Strings.repeat((String)"|", (int)(total - current));
            }
            return new StringTextComponent(bars);
        }
        return new StringTextComponent(holdW);
    }

    protected static KeyBinding ponderKeybind() {
        return Minecraft.func_71410_x().field_71474_y.field_74351_w;
    }
}

