/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.IScreenRenderable;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.ponder.NavigatableSimiScreen;
import com.simibubi.create.foundation.ponder.PonderProgressBar;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.content.DebugScenes;
import com.simibubi.create.foundation.ponder.content.PonderChapter;
import com.simibubi.create.foundation.ponder.content.PonderTag;
import com.simibubi.create.foundation.ponder.content.PonderTagScreen;
import com.simibubi.create.foundation.ponder.elements.TextWindowElement;
import com.simibubi.create.foundation.ponder.ui.PonderButton;
import com.simibubi.create.foundation.renderState.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.FontHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.Pointing;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.client.ClipboardHelper;
import net.minecraft.client.GameSettings;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.lwjgl.opengl.GL11;

public class PonderUI
extends NavigatableSimiScreen {
    public static int ponderTicks;
    public static float ponderPartialTicksPaused;
    public static final String PONDERING = "ponder.pondering";
    public static final String IDENTIFY_MODE = "ponder.identify_mode";
    public static final String IN_CHAPTER = "ponder.in_chapter";
    public static final String IDENTIFY = "ponder.identify";
    public static final String PREVIOUS = "ponder.previous";
    public static final String CLOSE = "ponder.close";
    public static final String NEXT = "ponder.next";
    public static final String REPLAY = "ponder.replay";
    public static final String SLOW_TEXT = "ponder.slow_text";
    private List<PonderScene> scenes;
    private List<PonderTag> tags;
    private List<PonderButton> tagButtons;
    private List<LerpedFloat> tagFades;
    private LerpedFloat fadeIn;
    ItemStack stack;
    PonderChapter chapter = null;
    private boolean userViewMode;
    private boolean identifyMode;
    private ItemStack hoveredTooltipItem;
    private BlockPos hoveredBlockPos;
    private ClipboardHelper clipboardHelper;
    private BlockPos copiedBlockPos;
    private LerpedFloat finishingFlash;
    private int finishingFlashWarmup = 0;
    private LerpedFloat lazyIndex;
    private int index = 0;
    private PonderTag referredToByTag;
    private PonderButton left;
    private PonderButton right;
    private PonderButton scan;
    private PonderButton chap;
    private PonderButton userMode;
    private PonderButton close;
    private PonderButton replay;
    private PonderButton slowMode;
    private PonderProgressBar progressBar;
    private int skipCooling = 0;
    private int extendedTickLength = 0;
    private int extendedTickTimer = 0;

    public static PonderUI of(ResourceLocation id) {
        return new PonderUI(PonderRegistry.compile(id));
    }

    public static PonderUI of(ItemStack item) {
        return new PonderUI(PonderRegistry.compile(item.func_77973_b().getRegistryName()));
    }

    public static PonderUI of(ItemStack item, PonderTag tag) {
        PonderUI ponderUI = new PonderUI(PonderRegistry.compile(item.func_77973_b().getRegistryName()));
        ponderUI.referredToByTag = tag;
        return ponderUI;
    }

    public static PonderUI of(PonderChapter chapter) {
        PonderUI ui = new PonderUI(PonderRegistry.compile(chapter));
        ui.chapter = chapter;
        return ui;
    }

    PonderUI(List<PonderScene> scenes) {
        ResourceLocation component = scenes.get((int)0).component;
        this.stack = ForgeRegistries.ITEMS.containsKey(component) ? new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(component)) : new ItemStack((IItemProvider)ForgeRegistries.BLOCKS.getValue(component));
        this.tags = new ArrayList<PonderTag>(PonderRegistry.tags.getTags(component));
        this.scenes = scenes;
        if (scenes.isEmpty()) {
            List<PonderStoryBoardEntry> l = Collections.singletonList(new PonderStoryBoardEntry(DebugScenes::empty, "debug/scene_1", new ResourceLocation("minecraft", "stick")));
            scenes.addAll(PonderRegistry.compile(l));
        }
        this.lazyIndex = LerpedFloat.linear().startWithValue(this.index);
        this.fadeIn = LerpedFloat.linear().startWithValue(0.0).chase(1.0, 0.1f, LerpedFloat.Chaser.EXP);
        this.clipboardHelper = new ClipboardHelper();
        this.finishingFlash = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.EXP);
    }

    @Override
    protected void init() {
        this.widgets.clear();
        super.init();
        this.tagButtons = new ArrayList<PonderButton>();
        this.tagFades = new ArrayList<LerpedFloat>();
        this.tags.forEach(t -> {
            int i = this.tagButtons.size();
            int x = 31;
            int y = 81 + i * 30;
            PonderButton b = new PonderButton(x, y, (mouseX, mouseY) -> {
                this.centerScalingOn((int)mouseX, (int)mouseY);
                ScreenOpener.transitionTo(new PonderTagScreen((PonderTag)t));
            }).showing((IScreenRenderable)t);
            this.widgets.add(b);
            this.tagButtons.add(b);
            LerpedFloat chase = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.05f, LerpedFloat.Chaser.exp(0.1));
            this.tagFades.add(chase);
        });
        if (this.chapter != null) {
            this.chap = new PonderButton(this.width - 31 - 24, 31, () -> {}).showing(this.chapter);
            this.widgets.add(this.chap);
        }
        GameSettings bindings = this.minecraft.field_71474_y;
        int spacing = 8;
        int bX = (this.width - 20) / 2 - (70 + 2 * spacing);
        int bY = this.height - 20 - 31;
        int pX = this.width / 2 - 110;
        int pY = bY + 20 + 4;
        int pW = this.width - 2 * pX;
        this.progressBar = new PonderProgressBar(this, pX, pY, pW, 1);
        this.widgets.add(this.progressBar);
        this.scan = new PonderButton(bX, bY, () -> {
            boolean bl = this.identifyMode = !this.identifyMode;
            if (!this.identifyMode) {
                this.scenes.get(this.index).deselect();
            } else {
                ponderPartialTicksPaused = this.minecraft.func_184121_ak();
            }
        }).showing(AllIcons.I_MTD_SCAN).shortcut(bindings.field_74316_C).fade(0, -1);
        this.widgets.add(this.scan);
        this.slowMode = new PonderButton(this.width - 20 - 31, bY, () -> this.setComfyReadingEnabled(!this.isComfyReadingEnabled())).showing(AllIcons.I_MTD_SLOW_MODE).fade(0, -1);
        this.widgets.add(this.slowMode);
        this.left = new PonderButton(bX += 50 + spacing, bY, () -> this.scroll(false)).showing(AllIcons.I_MTD_LEFT).shortcut(bindings.field_74370_x).fade(0, -1);
        this.widgets.add(this.left);
        this.close = new PonderButton(bX += 20 + spacing, bY, this::onClose).showing(AllIcons.I_MTD_CLOSE).shortcut(bindings.field_151445_Q).fade(0, -1);
        this.widgets.add(this.close);
        this.right = new PonderButton(bX += 20 + spacing, bY, () -> this.scroll(true)).showing(AllIcons.I_MTD_RIGHT).shortcut(bindings.field_74366_z).fade(0, -1);
        this.widgets.add(this.right);
        this.replay = new PonderButton(bX += 50 + spacing, bY, this::replay).showing(AllIcons.I_MTD_REPLAY).shortcut(bindings.field_74368_y).fade(0, -1);
        this.widgets.add(this.replay);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.skipCooling > 0) {
            --this.skipCooling;
        }
        if (this.referredToByTag != null) {
            for (int i = 0; i < this.scenes.size(); ++i) {
                PonderScene ponderScene = this.scenes.get(i);
                if (!ponderScene.tags.contains(this.referredToByTag)) continue;
                if (i == this.index) break;
                this.scenes.get(this.index).fadeOut();
                this.index = i;
                this.scenes.get(this.index).begin();
                this.lazyIndex.chase(this.index, 0.25, LerpedFloat.Chaser.EXP);
                this.identifyMode = false;
                break;
            }
            this.referredToByTag = null;
        }
        this.lazyIndex.tickChaser();
        this.fadeIn.tickChaser();
        this.finishingFlash.tickChaser();
        PonderScene activeScene = this.scenes.get(this.index);
        this.extendedTickLength = 0;
        if (this.isComfyReadingEnabled()) {
            activeScene.forEachVisible(TextWindowElement.class, twe -> {
                this.extendedTickLength = 2;
            });
        }
        if (this.extendedTickTimer == 0) {
            float lazyIndexValue;
            if (!this.identifyMode) {
                ++ponderTicks;
                if (this.skipCooling == 0) {
                    activeScene.tick();
                }
            }
            if (!this.identifyMode && Math.abs((lazyIndexValue = this.lazyIndex.getValue()) - (float)this.index) > 0.001953125f) {
                this.scenes.get(lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1).tick();
            }
            this.extendedTickTimer = this.extendedTickLength;
        } else {
            --this.extendedTickTimer;
        }
        this.progressBar.tick();
        if (activeScene.currentTime == activeScene.totalTime - 1) {
            this.finishingFlashWarmup = 30;
        }
        if (this.finishingFlashWarmup > 0) {
            --this.finishingFlashWarmup;
            if (this.finishingFlashWarmup == 0) {
                this.finishingFlash.setValue(1.0);
                this.finishingFlash.setValue(1.0);
            }
        }
        this.updateIdentifiedItem(activeScene);
    }

    public PonderScene getActiveScene() {
        return this.scenes.get(this.index);
    }

    public void seekToTime(int time) {
        if (this.getActiveScene().currentTime > time) {
            this.replay();
        }
        this.getActiveScene().seekToTime(time);
        if (time != 0) {
            this.coolDownAfterSkip();
        }
    }

    public void updateIdentifiedItem(PonderScene activeScene) {
        this.hoveredTooltipItem = ItemStack.field_190927_a;
        this.hoveredBlockPos = null;
        if (!this.identifyMode) {
            return;
        }
        MainWindow w = this.minecraft.func_228018_at_();
        double mouseX = this.minecraft.field_71417_B.func_198024_e() * (double)w.func_198107_o() / (double)w.func_198105_m();
        double mouseY = this.minecraft.field_71417_B.func_198026_f() * (double)w.func_198087_p() / (double)w.func_198083_n();
        PonderScene.SceneTransform t = activeScene.getTransform();
        Vec3d vec1 = t.screenToScene(mouseX, mouseY, 1000, 0.0f);
        Vec3d vec2 = t.screenToScene(mouseX, mouseY, -100, 0.0f);
        Pair<ItemStack, BlockPos> pair = activeScene.rayTraceScene(vec1, vec2);
        this.hoveredTooltipItem = pair.getFirst();
        this.hoveredBlockPos = pair.getSecond();
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (this.scroll(delta > 0.0)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, delta);
    }

    protected void replay() {
        this.identifyMode = false;
        PonderScene scene = this.scenes.get(this.index);
        if (PonderUI.hasShiftDown()) {
            List<PonderStoryBoardEntry> list = PonderRegistry.all.get(scene.component);
            PonderStoryBoardEntry sb = list.get(this.index);
            Template activeTemplate = PonderRegistry.loadSchematic(sb.getSchematicName());
            PonderWorld world = new PonderWorld(BlockPos.field_177992_a, (World)Minecraft.func_71410_x().field_71441_e);
            activeTemplate.func_186253_b((IWorld)world, BlockPos.field_177992_a, new PlacementSettings());
            world.createBackup();
            scene = PonderRegistry.compileScene(this.index, sb, world);
            scene.begin();
            this.scenes.set(this.index, scene);
        }
        scene.begin();
    }

    protected boolean scroll(boolean forward) {
        int prevIndex = this.index;
        this.index = forward ? this.index + 1 : this.index - 1;
        this.index = MathHelper.func_76125_a((int)this.index, (int)0, (int)(this.scenes.size() - 1));
        if (prevIndex != this.index) {
            this.scenes.get(prevIndex).fadeOut();
            this.scenes.get(this.index).begin();
            this.lazyIndex.chase(this.index, 0.25, LerpedFloat.Chaser.EXP);
            this.identifyMode = false;
            return true;
        }
        this.index = prevIndex;
        return false;
    }

    @Override
    protected void renderWindow(int mouseX, int mouseY, float partialTicks) {
        partialTicks = PonderUI.getPartialTicks();
        RenderSystem.enableBlend();
        this.renderVisibleScenes(mouseX, mouseY, this.skipCooling > 0 ? 0.0f : (this.identifyMode ? ponderPartialTicksPaused : partialTicks));
        this.renderWidgets(mouseX, mouseY, this.identifyMode ? ponderPartialTicksPaused : partialTicks);
    }

    public void renderBackground() {
        super.renderBackground();
    }

    protected void renderVisibleScenes(int mouseX, int mouseY, float partialTicks) {
        this.renderScene(mouseX, mouseY, this.index, partialTicks);
        float lazyIndexValue = this.lazyIndex.getValue(partialTicks);
        if (Math.abs(lazyIndexValue - (float)this.index) > 0.001953125f) {
            this.renderScene(mouseX, mouseY, lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1, partialTicks);
        }
    }

    protected void renderScene(int mouseX, int mouseY, int i, float partialTicks) {
        float flash;
        SuperRenderTypeBuffer buffer = SuperRenderTypeBuffer.getInstance();
        PonderScene story = this.scenes.get(i);
        MatrixStack ms = new MatrixStack();
        double value = this.lazyIndex.getValue(this.minecraft.func_184121_ak());
        double diff = (double)i - value;
        double slide = MathHelper.func_219803_d((double)(diff * diff), (double)200.0, (double)600.0) * diff;
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)800.0);
        ms.func_227860_a_();
        ms.func_227861_a_(0.0, 0.0, -800.0);
        story.transform.updateScreenParams(this.width, this.height, slide);
        story.transform.apply(ms, partialTicks, false);
        story.transform.updateSceneRVE(partialTicks);
        story.renderScene(buffer, ms, partialTicks);
        buffer.draw();
        MutableBoundingBox bounds = story.getBounds();
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)ms.func_227866_c_().func_227870_a_());
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)story.basePlateOffsetX, (double)0.0, (double)story.basePlateOffsetZ);
        RenderSystem.scaled((double)1.0, (double)-1.0, (double)1.0);
        float alpha = flash = this.finishingFlash.getValue(partialTicks) * 0.9f;
        flash *= flash;
        flash = flash * 2.0f - 1.0f;
        flash *= flash;
        flash = 1.0f - flash;
        for (int f = 0; f < 4; ++f) {
            RenderSystem.translated((double)story.basePlateSize, (double)0.0, (double)0.0);
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)0.0, (double)0.0, (double)-9.765625E-4);
            if (flash > 0.0f) {
                RenderSystem.pushMatrix();
                RenderSystem.scaled((double)1.0, (double)(0.5 + (double)flash * 0.75), (double)1.0);
                GuiUtils.drawGradientRect((int)0, (int)0, (int)-1, (int)(-story.basePlateSize), (int)0, (int)13041609, (int)ColorHelper.applyAlpha(-1429798967, alpha));
                RenderSystem.popMatrix();
            }
            RenderSystem.translated((double)0.0, (double)0.0, (double)0.001953125);
            GuiUtils.drawGradientRect((int)0, (int)0, (int)0, (int)(-story.basePlateSize), (int)4, (int)0x66000000, (int)0);
            RenderSystem.popMatrix();
            RenderSystem.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        RenderSystem.popMatrix();
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        RenderSystem.popMatrix();
        ms.func_227865_b_();
        RenderSystem.popMatrix();
    }

    protected void renderWidgets(int mouseX, int mouseY, float partialTicks) {
        boolean finished;
        float fade = this.fadeIn.getValue(partialTicks);
        float lazyIndexValue = this.lazyIndex.getValue(partialTicks);
        float indexDiff = Math.abs(lazyIndexValue - (float)this.index);
        PonderScene activeScene = this.scenes.get(this.index);
        int textColor = 0xEEEEEE;
        boolean noWidgetsHovered = true;
        for (Widget widget : this.widgets) {
            noWidgetsHovered &= !widget.isMouseOver((double)mouseX, (double)mouseY);
        }
        int tooltipColor = -6052957;
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)800.0);
        int x = 59;
        int y = 31;
        String title = activeScene.getTitle();
        int wordWrappedHeight = this.font.func_78267_b(title, this.left.x - 51);
        int streakHeight = 26 + wordWrappedHeight;
        UIRenderHelper.streak(0.0f, x - 4, y - 12 + streakHeight / 2, streakHeight, (int)(150.0f * fade), 0x101010);
        UIRenderHelper.streak(180.0f, x - 4, y - 12 + streakHeight / 2, streakHeight, (int)(30.0f * fade), 0x101010);
        PonderUI.renderBox(21, 21, 30, 30, false);
        GuiGameElement.of(this.stack).at(x - 39, y - 11).scale(2.0).render();
        this.drawString(this.font, Lang.translate(PONDERING, new Object[0]), x, y - 6, tooltipColor);
        RenderSystem.translated((double)(x += 0), (double)(y += 8), (double)0.0);
        RenderSystem.rotatef((float)(indexDiff * -75.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.translated((double)0.0, (double)0.0, (double)5.0);
        FontHelper.drawSplitString(this.font, title, 0, 0, this.left.x - 51, ColorHelper.applyAlpha(textColor, 1.0f - indexDiff));
        RenderSystem.popMatrix();
        if (this.chapter != null) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)(this.chap.x - 4 - 4), (double)this.chap.y, (double)0.0);
            UIRenderHelper.streak(180.0f, 4, 10, 26, (int)(150.0f * fade), 0x101010);
            this.drawRightAlignedString(this.font, Lang.translate(IN_CHAPTER, new Object[0]), 0, 0, tooltipColor);
            this.drawRightAlignedString(this.font, Lang.translate("ponder.chapter." + this.chapter.getId(), new Object[0]), 0, 12, -1118482);
            RenderSystem.popMatrix();
        }
        UIRenderHelper.breadcrumbArrow(this.width / 2 - 20, this.height - 51, 20, 20, 5, 1084922265, 548051353);
        UIRenderHelper.breadcrumbArrow(this.width / 2 + 20, this.height - 51, -20, 20, -5, 1084922265, 548051353);
        UIRenderHelper.breadcrumbArrow(this.width / 2 - 90, this.height - 51, 70, 20, 5, 1084922265, 279615897);
        UIRenderHelper.breadcrumbArrow(this.width / 2 + 90, this.height - 51, -70, 20, -5, 1084922265, 279615897);
        if (this.identifyMode) {
            if (noWidgetsHovered && mouseY < this.height - 80) {
                RenderSystem.pushMatrix();
                RenderSystem.translated((double)mouseX, (double)mouseY, (double)100.0);
                if (this.hoveredTooltipItem.func_190926_b()) {
                    String tooltip = Lang.createTranslationTextComponent(IDENTIFY_MODE, new StringTextComponent(this.minecraft.field_71474_y.field_74316_C.getKeyBinding().func_197978_k()).func_211708_a(TextFormatting.WHITE)).func_211708_a(TextFormatting.GRAY).func_150254_d();
                    this.renderTooltip(this.font.func_78271_c(tooltip, this.width / 3), 0, 0);
                } else {
                    this.renderTooltip(this.hoveredTooltipItem, 0, 0);
                }
                if (this.hoveredBlockPos != null) {
                    // empty if block
                }
                RenderSystem.popMatrix();
            }
            this.scan.flash();
        } else {
            this.scan.dim();
        }
        if (this.isComfyReadingEnabled()) {
            this.slowMode.flash();
        } else {
            this.slowMode.dim();
        }
        float scenePT = this.skipCooling > 0 ? 0.0f : partialTicks;
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)100.0);
        this.renderOverlay(this.index, scenePT);
        if (indexDiff > 0.001953125f) {
            this.renderOverlay(lazyIndexValue < (float)this.index ? this.index - 1 : this.index + 1, scenePT);
        }
        RenderSystem.popMatrix();
        this.widgets.forEach(w -> {
            if (w instanceof PonderButton) {
                PonderButton mtdButton = (PonderButton)((Object)w);
                mtdButton.fade(fade);
            }
        });
        if (this.index == 0 || this.index == 1 && lazyIndexValue < (float)this.index) {
            this.left.fade(lazyIndexValue);
        }
        if (this.index == this.scenes.size() - 1 || this.index == this.scenes.size() - 2 && lazyIndexValue > (float)this.index) {
            this.right.fade((float)this.scenes.size() - lazyIndexValue - 1.0f);
        }
        if (finished = activeScene.isFinished()) {
            this.right.flash();
        } else {
            this.right.dim();
        }
        List<PonderTag> sceneTags = activeScene.tags;
        boolean highlightAll = sceneTags.contains(PonderTag.Highlight.ALL);
        double s = Minecraft.func_71410_x().func_228018_at_().func_198100_s();
        IntStream.range(0, this.tagButtons.size()).forEach(i -> {
            RenderSystem.pushMatrix();
            LerpedFloat chase = this.tagFades.get(i);
            PonderButton button = this.tagButtons.get(i);
            if (button.isMouseOver(mouseX, mouseY)) {
                chase.updateChaseTarget(1.0f);
            } else {
                chase.updateChaseTarget(0.0f);
            }
            chase.tickChaser();
            if (highlightAll || sceneTags.contains(this.tags.get(i))) {
                button.flash();
            } else {
                button.dim();
            }
            int x = button.x + button.getWidth() + 4;
            int y = button.y - 2;
            RenderSystem.translated((double)x, (double)((float)y + 5.0f * (1.0f - fade)), (double)800.0);
            float fadedWidth = 200.0f * chase.getValue(partialTicks);
            UIRenderHelper.streak(0.0f, 0, 12, 26, (int)fadedWidth, 0x101010);
            GL11.glScissor((int)((int)((double)x * s)), (int)0, (int)((int)((double)fadedWidth * s)), (int)((int)((double)this.height * s)));
            GL11.glEnable((int)3089);
            String tagName = this.tags.get(i).getTitle();
            this.drawString(tagName, 3, 8, 0xFFEEDD);
            GL11.glDisable((int)3089);
            RenderSystem.popMatrix();
        });
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)500.0);
        int tooltipY = this.height - 16;
        if (this.scan.isHovered()) {
            this.drawCenteredString(this.font, Lang.translate(IDENTIFY, new Object[0]), this.scan.x + 10, tooltipY, tooltipColor);
        }
        if (this.index != 0 && this.left.isHovered()) {
            this.drawCenteredString(this.font, Lang.translate(PREVIOUS, new Object[0]), this.left.x + 10, tooltipY, tooltipColor);
        }
        if (this.close.isHovered()) {
            this.drawCenteredString(this.font, Lang.translate(CLOSE, new Object[0]), this.close.x + 10, tooltipY, tooltipColor);
        }
        if (this.index != this.scenes.size() - 1 && this.right.isHovered()) {
            this.drawCenteredString(this.font, Lang.translate(NEXT, new Object[0]), this.right.x + 10, tooltipY, tooltipColor);
        }
        if (this.replay.isHovered()) {
            this.drawCenteredString(this.font, Lang.translate(REPLAY, new Object[0]), this.replay.x + 10, tooltipY, tooltipColor);
        }
        if (this.slowMode.isHovered()) {
            this.drawCenteredString(this.font, Lang.translate(SLOW_TEXT, new Object[0]), this.slowMode.x + 5, tooltipY, tooltipColor);
        }
        RenderSystem.popMatrix();
    }

    protected void lowerButtonGroup(int index, int mouseX, int mouseY, float fade, AllIcons icon, KeyBinding key) {
        int bWidth = 20;
        int bHeight = 20;
        int bX = (this.width - bWidth) / 2 + (index - 1) * (bWidth + 8);
        int bY = this.height - bHeight - 31;
        RenderSystem.pushMatrix();
        if (fade < this.fadeIn.getChaseTarget()) {
            RenderSystem.translated((double)0.0, (double)((1.0f - fade) * 5.0f), (double)0.0);
        }
        boolean hovered = this.isMouseOver(mouseX, mouseY, bX, bY, bWidth, bHeight);
        PonderUI.renderBox(bX, bY, bWidth, bHeight, hovered);
        icon.draw(bX + 2, bY + 2);
        this.drawCenteredString(this.font, key.func_197978_k(), bX + bWidth / 2 + 8, bY + bHeight - 6, -10461088);
        RenderSystem.popMatrix();
    }

    private void renderOverlay(int i, float partialTicks) {
        if (this.identifyMode) {
            return;
        }
        RenderSystem.pushMatrix();
        PonderScene story = this.scenes.get(i);
        MatrixStack ms = new MatrixStack();
        story.renderOverlay(this, ms, this.skipCooling > 0 ? 0.0f : (this.identifyMode ? ponderPartialTicksPaused : partialTicks));
        RenderSystem.popMatrix();
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        MutableBoolean handled = new MutableBoolean(false);
        this.widgets.forEach(w -> {
            if (handled.booleanValue()) {
                return;
            }
            if (!w.isMouseOver(x, y)) {
                return;
            }
            if (w instanceof PonderButton) {
                PonderButton mtdButton = (PonderButton)((Object)w);
                mtdButton.runCallback(x, y);
                handled.setTrue();
                return;
            }
        });
        if (handled.booleanValue()) {
            return true;
        }
        if (!this.identifyMode || this.hoveredBlockPos != null) {
            // empty if block
        }
        return super.mouseClicked(x, y, button);
    }

    @Override
    public boolean keyPressed(int code, int p_keyPressed_2_, int p_keyPressed_3_) {
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        int sCode = settings.field_74368_y.getKey().func_197937_c();
        int aCode = settings.field_74370_x.getKey().func_197937_c();
        int dCode = settings.field_74366_z.getKey().func_197937_c();
        int qCode = settings.field_74316_C.getKey().func_197937_c();
        if (code == sCode) {
            this.replay();
            return true;
        }
        if (code == aCode) {
            this.scroll(false);
            return true;
        }
        if (code == dCode) {
            this.scroll(true);
            return true;
        }
        if (code == qCode) {
            boolean bl = this.identifyMode = !this.identifyMode;
            if (!this.identifyMode) {
                this.scenes.get(this.index).deselect();
            }
            return true;
        }
        return super.keyPressed(code, p_keyPressed_2_, p_keyPressed_3_);
    }

    @Override
    protected String getBreadcrumbTitle() {
        if (this.chapter != null) {
            return Lang.translate("ponder.chapter." + this.chapter.getId(), new Object[0]);
        }
        return this.stack.func_77973_b().func_200296_o().func_150254_d();
    }

    public FontRenderer getFontRenderer() {
        return this.font;
    }

    protected boolean isMouseOver(double mouseX, double mouseY, int x, int y, int w, int h) {
        boolean hovered = !(mouseX < (double)x) && !(mouseX > (double)(x + w));
        return hovered &= !(mouseY < (double)y) && !(mouseY > (double)(y + h));
    }

    public void drawString(String s, int x, int y, int color) {
        this.drawString(this.font, s, x, y, color);
    }

    public static void renderBox(int x, int y, int w, int h, boolean highlighted) {
        PonderUI.renderBox(x, y, w, h, -16777216, highlighted ? -251662627 : 1090514653, highlighted ? 1627385565 : 553643741);
    }

    public static void renderSpeechBox(int x, int y, int w, int h, boolean highlighted, Pointing pointing, boolean returnWithLocalTransform) {
        if (!returnWithLocalTransform) {
            RenderSystem.pushMatrix();
        }
        int boxX = x;
        int boxY = y;
        int divotX = x;
        int divotY = y;
        int divotRotation = 0;
        int divotSize = 8;
        int distance = 1;
        int divotRadius = divotSize / 2;
        switch (pointing) {
            default: {
                divotRotation = 0;
                boxX -= w / 2;
                boxY -= h + divotSize + 1 + distance;
                divotX -= divotRadius;
                divotY -= divotSize + distance;
                break;
            }
            case LEFT: {
                divotRotation = 90;
                boxX += divotSize + 1 + distance;
                boxY -= h / 2;
                divotX += distance;
                divotY -= divotRadius;
                break;
            }
            case RIGHT: {
                divotRotation = 270;
                boxX -= w + divotSize + 1 + distance;
                boxY -= h / 2;
                divotX -= divotSize + distance;
                divotY -= divotRadius;
                break;
            }
            case UP: {
                divotRotation = 180;
                boxX -= w / 2;
                boxY += divotSize + 1 + distance;
                divotX -= divotRadius;
                divotY += distance;
            }
        }
        PonderUI.renderBox(boxX, boxY, w, h, highlighted);
        RenderSystem.pushMatrix();
        AllGuiTextures toRender = highlighted ? AllGuiTextures.SPEECH_TOOLTIP_HIGHLIGHT : AllGuiTextures.SPEECH_TOOLTIP;
        RenderSystem.translated((double)(divotX + divotRadius), (double)(divotY + divotRadius), (double)10.0);
        RenderSystem.rotatef((float)divotRotation, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.translated((double)(-divotRadius), (double)(-divotRadius), (double)0.0);
        toRender.draw(0, 0);
        RenderSystem.popMatrix();
        if (returnWithLocalTransform) {
            RenderSystem.translated((double)boxX, (double)boxY, (double)0.0);
            return;
        }
        RenderSystem.popMatrix();
    }

    public static void renderBox(int x, int y, int w, int h, int backgroundColor, int borderColorStart, int borderColorEnd) {
        int z = 100;
        GuiUtils.drawGradientRect((int)z, (int)(x - 3), (int)(y - 4), (int)(x + w + 3), (int)(y - 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)z, (int)(x - 3), (int)(y + h + 3), (int)(x + w + 3), (int)(y + h + 4), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)z, (int)(x - 3), (int)(y - 3), (int)(x + w + 3), (int)(y + h + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)z, (int)(x - 4), (int)(y - 3), (int)(x - 3), (int)(y + h + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)z, (int)(x + w + 3), (int)(y - 3), (int)(x + w + 4), (int)(y + h + 3), (int)backgroundColor, (int)backgroundColor);
        GuiUtils.drawGradientRect((int)z, (int)(x - 3), (int)(y - 3 + 1), (int)(x - 3 + 1), (int)(y + h + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((int)z, (int)(x + w + 2), (int)(y - 3 + 1), (int)(x + w + 3), (int)(y + h + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
        GuiUtils.drawGradientRect((int)z, (int)(x - 3), (int)(y - 3), (int)(x + w + 3), (int)(y - 3 + 1), (int)borderColorStart, (int)borderColorStart);
        GuiUtils.drawGradientRect((int)z, (int)(x - 3), (int)(y + h + 2), (int)(x + w + 3), (int)(y + h + 3), (int)borderColorEnd, (int)borderColorEnd);
    }

    public ItemStack getHoveredTooltipItem() {
        return this.hoveredTooltipItem;
    }

    public ItemStack getSubject() {
        return this.stack;
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        if (other instanceof PonderUI) {
            return this.stack.func_77969_a(((PonderUI)other).stack);
        }
        return super.isEquivalentTo(other);
    }

    @Override
    public void shareContextWith(NavigatableSimiScreen other) {
        if (other instanceof PonderUI) {
            PonderUI ponderUI = (PonderUI)other;
            ponderUI.referredToByTag = this.referredToByTag;
        }
    }

    public static float getPartialTicks() {
        float renderPartialTicks = Minecraft.func_71410_x().func_184121_ak();
        if (Minecraft.func_71410_x().field_71462_r instanceof PonderUI) {
            PonderUI ui = (PonderUI)Minecraft.func_71410_x().field_71462_r;
            if (ui.identifyMode) {
                return ponderPartialTicksPaused;
            }
            return (renderPartialTicks + (float)(ui.extendedTickLength - ui.extendedTickTimer)) / (float)(ui.extendedTickLength + 1);
        }
        return renderPartialTicks;
    }

    @Override
    public boolean isPauseScreen() {
        return true;
    }

    public void coolDownAfterSkip() {
        this.skipCooling = 15;
    }

    public void removed() {
        super.removed();
        this.hoveredTooltipItem = ItemStack.field_190927_a;
    }

    public boolean isComfyReadingEnabled() {
        return (Boolean)AllConfigs.CLIENT.comfyReading.get();
    }

    public void setComfyReadingEnabled(boolean slowTextMode) {
        AllConfigs.CLIENT.comfyReading.set(slowTextMode);
    }

    private /* synthetic */ void lambda$init$5() {
        this.userViewMode = !this.userViewMode;
    }
}

