/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class SceneBuildingUtil {
    public final SelectionUtil select;
    public final VectorUtil vector;
    public final PositionUtil grid;
    private final MutableBoundingBox sceneBounds;

    SceneBuildingUtil(MutableBoundingBox sceneBounds) {
        this.sceneBounds = sceneBounds;
        this.select = new SelectionUtil();
        this.vector = new VectorUtil();
        this.grid = new PositionUtil();
    }

    public class SelectionUtil {
        public Selection everywhere() {
            return Selection.of(SceneBuildingUtil.this.sceneBounds);
        }

        public Selection position(int x, int y, int z) {
            return this.position(SceneBuildingUtil.this.grid.at(x, y, z));
        }

        public Selection position(BlockPos pos) {
            return this.cuboid(pos, (Vec3i)BlockPos.field_177992_a);
        }

        public Selection fromTo(int x, int y, int z, int x2, int y2, int z2) {
            return this.fromTo(new BlockPos(x, y, z), new BlockPos(x2, y2, z2));
        }

        public Selection fromTo(BlockPos pos1, BlockPos pos2) {
            return this.cuboid(pos1, (Vec3i)pos2.func_177973_b((Vec3i)pos1));
        }

        public Selection column(int x, int z) {
            return this.cuboid(new BlockPos(x, 1, z), new Vec3i(0, SceneBuildingUtil.this.sceneBounds.func_78882_c(), 0));
        }

        public Selection layer(int y) {
            return this.layers(y, 1);
        }

        public Selection layersFrom(int y) {
            return this.layers(y, SceneBuildingUtil.this.sceneBounds.func_78882_c() - y);
        }

        public Selection layers(int y, int height) {
            return this.cuboid(new BlockPos(0, y, 0), new Vec3i(SceneBuildingUtil.this.sceneBounds.func_78883_b() - 1, Math.min(SceneBuildingUtil.this.sceneBounds.func_78882_c() - y, height) - 1, SceneBuildingUtil.this.sceneBounds.func_78880_d() - 1));
        }

        public Selection cuboid(BlockPos origin, Vec3i size) {
            return Selection.of(new MutableBoundingBox((Vec3i)origin, (Vec3i)origin.func_177971_a(size)));
        }
    }

    public class VectorUtil {
        public Vec3d centerOf(int x, int y, int z) {
            return this.centerOf(SceneBuildingUtil.this.grid.at(x, y, z));
        }

        public Vec3d centerOf(BlockPos pos) {
            return VecHelper.getCenterOf((Vec3i)pos);
        }

        public Vec3d topOf(int x, int y, int z) {
            return this.blockSurface(SceneBuildingUtil.this.grid.at(x, y, z), Direction.UP);
        }

        public Vec3d topOf(BlockPos pos) {
            return this.blockSurface(pos, Direction.UP);
        }

        public Vec3d blockSurface(BlockPos pos, Direction face) {
            return this.blockSurface(pos, face, 0.0f);
        }

        public Vec3d blockSurface(BlockPos pos, Direction face, float margin) {
            return this.centerOf(pos).func_178787_e(new Vec3d(face.func_176730_m()).func_186678_a((double)(0.5f + margin)));
        }

        public Vec3d of(double x, double y, double z) {
            return new Vec3d(x, y, z);
        }
    }

    public class PositionUtil {
        public BlockPos at(int x, int y, int z) {
            return new BlockPos(x, y, z);
        }

        public BlockPos zero() {
            return this.at(0, 0, 0);
        }
    }
}

