/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.simibubi.create.foundation.utility.outliner.Outline;
import com.simibubi.create.foundation.utility.outliner.Outliner;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public abstract class Selection
implements Predicate<BlockPos> {
    public static Selection of(MutableBoundingBox bb) {
        return new Simple(bb);
    }

    public abstract Selection add(Selection var1);

    public abstract Selection substract(Selection var1);

    public abstract Selection copy();

    public abstract Vec3d getCenter();

    public abstract void forEach(Consumer<BlockPos> var1);

    public abstract Outline.OutlineParams makeOutline(Outliner var1, Object var2);

    public Outline.OutlineParams makeOutline(Outliner outliner) {
        return this.makeOutline(outliner, this);
    }

    private static class Simple
    extends Selection {
        private MutableBoundingBox bb;
        private AxisAlignedBB aabb;

        public Simple(MutableBoundingBox bb) {
            this.bb = bb;
            this.aabb = this.getAABB();
        }

        @Override
        public boolean test(BlockPos t) {
            return this.bb.func_175898_b((Vec3i)t);
        }

        @Override
        public Selection add(Selection other) {
            return new Compound(this).add(other);
        }

        @Override
        public Selection substract(Selection other) {
            return new Compound(this).substract(other);
        }

        @Override
        public void forEach(Consumer<BlockPos> callback) {
            BlockPos.func_229383_a_((MutableBoundingBox)this.bb).forEach(callback);
        }

        @Override
        public Vec3d getCenter() {
            return this.aabb.func_189972_c();
        }

        @Override
        public Outline.OutlineParams makeOutline(Outliner outliner, Object slot) {
            return outliner.showAABB(slot, this.aabb);
        }

        private AxisAlignedBB getAABB() {
            return new AxisAlignedBB((double)this.bb.field_78897_a, (double)this.bb.field_78895_b, (double)this.bb.field_78896_c, (double)(this.bb.field_78893_d + 1), (double)(this.bb.field_78894_e + 1), (double)(this.bb.field_78892_f + 1));
        }

        @Override
        public Selection copy() {
            return new Simple(new MutableBoundingBox(this.bb));
        }
    }

    private static class Compound
    extends Selection {
        Set<BlockPos> posSet;
        Vec3d center;

        public Compound(Simple initial) {
            this.posSet = new HashSet<BlockPos>();
            this.add(initial);
        }

        private Compound(Set<BlockPos> template) {
            this.posSet = new HashSet<BlockPos>(template);
        }

        @Override
        public boolean test(BlockPos t) {
            return this.posSet.contains(t);
        }

        @Override
        public Selection add(Selection other) {
            other.forEach(p -> this.posSet.add(p.func_185334_h()));
            this.center = null;
            return this;
        }

        @Override
        public Selection substract(Selection other) {
            other.forEach(p -> this.posSet.remove(p.func_185334_h()));
            this.center = null;
            return this;
        }

        @Override
        public void forEach(Consumer<BlockPos> callback) {
            this.posSet.forEach(callback);
        }

        @Override
        public Outline.OutlineParams makeOutline(Outliner outliner, Object slot) {
            return outliner.showCluster(slot, this.posSet);
        }

        @Override
        public Vec3d getCenter() {
            return this.center == null ? (this.center = this.evalCenter()) : this.center;
        }

        private Vec3d evalCenter() {
            Vec3d center = Vec3d.field_186680_a;
            if (this.posSet.isEmpty()) {
                return center;
            }
            for (BlockPos blockPos : this.posSet) {
                center = center.func_178787_e(new Vec3d((Vec3i)blockPos));
            }
            center = center.func_186678_a((double)(1.0f / (float)this.posSet.size()));
            return center.func_178787_e(new Vec3d(0.5, 0.5, 0.5));
        }

        @Override
        public Selection copy() {
            return new Compound(this.posSet);
        }
    }
}

