/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterTileEntity;
import com.simibubi.create.content.logistics.block.funnel.FunnelTileEntity;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmTileEntity;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.content.PonderPalette;
import com.simibubi.create.foundation.ponder.elements.InputWindowElement;
import com.simibubi.create.foundation.ponder.elements.WorldSectionElement;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class ArmScenes {
    public static void setup(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("mechanical_arm", "Setting up Mechanical Arms");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        ItemStack armItem = AllBlocks.MECHANICAL_ARM.asStack();
        BlockPos armPos = util.grid.at(2, 1, 2);
        Selection armSel = util.select.position(armPos);
        BlockPos inputDepot = util.grid.at(4, 2, 1);
        Vec3d depotSurface = util.vector.blockSurface(inputDepot, Direction.NORTH);
        Vec3d armSurface = util.vector.blockSurface(armPos, Direction.WEST);
        scene.idle(20);
        scene.world.setKineticSpeed(armSel, 0.0f);
        scene.world.showSection(armSel, Direction.DOWN);
        scene.idle(10);
        scene.effects.indicateRedstone(armPos);
        scene.overlay.showSelectionWithText(armSel, 70).attachKeyFrame().colored(PonderPalette.RED).text("Mechanical Arms have to be assigned their in- and outputs before they are placed").pointAt(armSurface).placeNearTarget();
        scene.idle(80);
        scene.world.showSection(util.select.fromTo(4, 1, 1, 4, 2, 1), Direction.DOWN);
        scene.world.showSection(util.select.fromTo(0, 1, 1, 0, 2, 1), Direction.DOWN);
        scene.world.hideSection(armSel, Direction.UP);
        scene.idle(20);
        scene.overlay.showControls(new InputWindowElement(depotSurface, Pointing.RIGHT).rightClick().withItem(armItem), 50);
        scene.idle(7);
        AxisAlignedBB depotBounds = AllShapes.DEPOT.func_197752_a();
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.INPUT, new Object(), depotBounds.func_72317_d(4.0, 2.0, 1.0), 400);
        scene.overlay.showText(70).attachKeyFrame().colored(PonderPalette.INPUT).text("Right-Click inventories while holding the Arm to assign them as Targets").pointAt(util.vector.blockSurface(inputDepot, Direction.WEST)).placeNearTarget();
        scene.idle(80);
        BlockPos outputDepot = util.grid.at(0, 2, 1);
        InputWindowElement input = new InputWindowElement(util.vector.blockSurface(outputDepot, Direction.NORTH), Pointing.RIGHT).rightClick().withItem(armItem);
        scene.overlay.showControls(input, 20);
        scene.idle(7);
        Object second = new Object();
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.INPUT, second, depotBounds.func_72317_d(0.0, 2.0, 1.0), 100);
        scene.idle(25);
        scene.overlay.showControls(input, 30);
        scene.idle(7);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, second, depotBounds.func_72317_d(0.0, 2.0, 1.0), 280);
        scene.overlay.showText(70).colored(PonderPalette.OUTPUT).text("Right-Click again to toggle between Input (Blue) and Output (Orange)").pointAt(util.vector.blockSurface(outputDepot, Direction.WEST)).placeNearTarget();
        scene.idle(80);
        scene.world.showSection(util.select.position(1, 1, 0), Direction.DOWN);
        scene.idle(15);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.INPUT, new Object(), depotBounds.func_72317_d(1.0, 1.0, 0.0), 43);
        scene.overlay.showText(50).colored(PonderPalette.WHITE).text("Left-Click components to remove their Selection").pointAt(util.vector.blockSurface(util.grid.at(1, 1, 0), Direction.WEST)).placeNearTarget();
        scene.idle(35);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(util.grid.at(1, 1, 0)), Pointing.DOWN).leftClick().withItem(armItem), 30);
        scene.idle(50);
        scene.world.showSection(armSel, Direction.DOWN);
        scene.idle(10);
        Vec3d armTop = armSurface.func_72441_c(0.5, 1.5, 0.0);
        scene.overlay.showText(70).attachKeyFrame().colored(PonderPalette.GREEN).text("Once placed, the Mechanical Arm will target the blocks selected previously").pointAt(armTop).placeNearTarget();
        scene.idle(80);
        scene.effects.indicateSuccess(armPos);
        scene.world.showSection(util.select.fromTo(2, 1, 5, 2, 1, 3).add(util.select.position(2, 0, 5)), Direction.DOWN);
        ItemStack copper = AllItems.COPPER_INGOT.asStack();
        scene.world.createItemOnBeltLike(inputDepot, Direction.SOUTH, copper);
        scene.idle(10);
        scene.world.setKineticSpeed(armSel, -48.0f);
        scene.idle(20);
        scene.world.instructArm(armPos, ArmTileEntity.Phase.MOVE_TO_INPUT, ItemStack.field_190927_a, 0);
        scene.idle(24);
        scene.world.removeItemsFromBelt(inputDepot);
        scene.world.instructArm(armPos, ArmTileEntity.Phase.SEARCH_OUTPUTS, copper, -1);
        scene.idle(20);
        scene.world.instructArm(armPos, ArmTileEntity.Phase.MOVE_TO_OUTPUT, copper, 0);
        scene.idle(24);
        scene.world.createItemOnBeltLike(outputDepot, Direction.UP, copper);
        scene.world.instructArm(armPos, ArmTileEntity.Phase.SEARCH_INPUTS, ItemStack.field_190927_a, -1);
        scene.idle(44);
        scene.world.showSection(util.select.fromTo(1, 1, 4, 1, 3, 4), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.position(4, 1, 2), Direction.DOWN);
        scene.idle(5);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, new Object(), depotBounds.func_72317_d(0.0, 2.0, 1.0), 60);
        scene.idle(5);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.INPUT, new Object(), depotBounds.func_72317_d(4.0, 2.0, 1.0), 60);
        scene.idle(5);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, new Object(), depotBounds.func_72317_d(1.0, 1.0, 0.0), 60);
        scene.idle(5);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.INPUT, new Object(), depotBounds.func_72317_d(1.0, 3.0, 4.0), 60);
        scene.idle(5);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.INPUT, new Object(), depotBounds.func_72317_d(4.0, 1.0, 2.0), 60);
        scene.idle(5);
        scene.overlay.showText(80).attachKeyFrame().text("They can have any amount of in- and outputs within their range").pointAt(util.vector.blockSurface(util.grid.at(1, 3, 4), Direction.WEST)).placeNearTarget();
        inputDepot = util.grid.at(1, 3, 4);
        outputDepot = util.grid.at(1, 1, 0);
        copper = AllBlocks.COPPER_BLOCK.asStack();
        scene.world.createItemOnBeltLike(inputDepot, Direction.SOUTH, copper);
        scene.idle(20);
        scene.world.instructArm(armPos, ArmTileEntity.Phase.MOVE_TO_INPUT, ItemStack.field_190927_a, 2);
        scene.idle(24);
        scene.world.removeItemsFromBelt(inputDepot);
        scene.world.instructArm(armPos, ArmTileEntity.Phase.SEARCH_OUTPUTS, copper, -1);
        scene.idle(20);
        scene.world.instructArm(armPos, ArmTileEntity.Phase.MOVE_TO_OUTPUT, copper, 2);
        scene.idle(24);
        scene.world.createItemOnBeltLike(outputDepot, Direction.UP, copper);
        scene.world.instructArm(armPos, ArmTileEntity.Phase.SEARCH_INPUTS, ItemStack.field_190927_a, -1);
        scene.world.hideSection(util.select.fromTo(4, 2, 1, 4, 1, 1), Direction.UP);
        scene.idle(2);
        scene.world.hideSection(util.select.fromTo(1, 1, 4, 1, 3, 4), Direction.UP);
        scene.idle(5);
        scene.world.hideSection(util.select.fromTo(0, 1, 1, 0, 2, 1), Direction.UP);
        scene.idle(2);
        scene.world.hideSection(util.select.position(1, 1, 0), Direction.UP);
        scene.idle(5);
        scene.world.hideSection(util.select.position(4, 1, 2), Direction.UP);
        scene.idle(15);
        scene.world.showSection(util.select.fromTo(4, 1, 3, 4, 2, 3), Direction.NORTH);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 3, 0, 2, 3), Direction.NORTH);
        scene.idle(15);
        Object in = new Object();
        Object out = new Object();
        AxisAlignedBB chestBounds = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
        AxisAlignedBB funnelBounds = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.RED, in, chestBounds.func_72317_d(4.0, 2.0, 3.0), 120);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.RED, out, chestBounds.func_72317_d(0.0, 2.0, 3.0), 120);
        scene.overlay.showText(80).attachKeyFrame().text("However, not every type of Inventory can be interacted with directly").colored(PonderPalette.RED).placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(0, 2, 3), Direction.WEST));
        scene.idle(90);
        scene.world.showSection(util.select.fromTo(4, 1, 2, 4, 2, 2), Direction.SOUTH);
        scene.idle(5);
        scene.world.showSection(util.select.position(0, 2, 2), Direction.SOUTH);
        scene.idle(10);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.INPUT, in, depotBounds.func_72317_d(4.0, 1.0, 2.0), 80);
        scene.idle(5);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, out, funnelBounds.func_72317_d(0.0, 2.0, 2.0), 80);
        scene.idle(5);
        scene.overlay.showText(60).text("Funnels and Depots can help to Bridge that gap").colored(PonderPalette.OUTPUT).placeNearTarget().pointAt(util.vector.topOf(util.grid.at(0, 2, 2)).func_72441_c(0.0, 0.0, 0.25));
        scene.idle(70);
        ItemStack sword = new ItemStack((IItemProvider)Items.field_151010_B);
        inputDepot = util.grid.at(4, 1, 2);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(inputDepot), Pointing.RIGHT).withItem(sword), 30);
        scene.world.createItemOnBeltLike(inputDepot, Direction.SOUTH, sword);
        scene.idle(20);
        scene.world.instructArm(armPos, ArmTileEntity.Phase.MOVE_TO_INPUT, ItemStack.field_190927_a, 1);
        scene.idle(24);
        scene.world.removeItemsFromBelt(inputDepot);
        scene.world.instructArm(armPos, ArmTileEntity.Phase.SEARCH_OUTPUTS, sword, -1);
        scene.idle(20);
        scene.world.instructArm(armPos, ArmTileEntity.Phase.MOVE_TO_OUTPUT, sword, 1);
        scene.idle(24);
        scene.world.flapFunnel(util.grid.at(0, 2, 2), false);
        scene.world.instructArm(armPos, ArmTileEntity.Phase.SEARCH_INPUTS, ItemStack.field_190927_a, -1);
        scene.idle(5);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(util.grid.at(0, 2, 3), Direction.WEST), Pointing.LEFT).withItem(sword), 30);
    }

    public static void filtering(SceneBuilder scene, SceneBuildingUtil util) {
        BlockPos funnelPos;
        int i;
        scene.title("mechanical_arm_filtering", "Filtering Outputs of the Mechanical Arm");
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(0.9f);
        scene.world.setKineticSpeed(util.select.fromTo(4, 1, 4, 6, 0, 5), 0.0f);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(10);
        scene.world.showSection(util.select.fromTo(4, 1, 4, 5, 1, 5), Direction.DOWN);
        scene.idle(10);
        for (int x = 0; x < 2; ++x) {
            scene.idle(3);
            scene.world.showSection(util.select.position(x + 1, 1, 4), Direction.DOWN);
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                scene.world.showSection(util.select.position(y == 1 ? x + 3 : 5 - x, y + 1, 1), Direction.DOWN);
                scene.idle(2);
            }
        }
        scene.world.showSection(util.select.position(2, 1, 1), Direction.EAST);
        ItemStack sand = new ItemStack((IItemProvider)Items.field_221548_A, 64);
        ItemStack sulphur = new ItemStack((IItemProvider)Items.field_151016_H, 64);
        scene.world.createItemOnBeltLike(util.grid.at(2, 1, 4), Direction.SOUTH, sand);
        scene.world.createItemOnBeltLike(util.grid.at(1, 1, 4), Direction.SOUTH, sulphur);
        scene.overlay.showSelectionWithText(util.select.fromTo(2, 1, 4, 1, 1, 4), 60).text("Inputs").placeNearTarget().colored(PonderPalette.INPUT);
        scene.idle(50);
        scene.overlay.showSelectionWithText(util.select.fromTo(5, 3, 1, 3, 1, 1), 40).text("Outputs").placeNearTarget().colored(PonderPalette.OUTPUT);
        scene.idle(50);
        scene.overlay.showText(80).attachKeyFrame().text("Sometimes it is desirable to restrict targets of the Arm by matching a filter").placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(3, 3, 1), Direction.WEST));
        scene.idle(90);
        scene.rotateCameraY(-120.0f);
        scene.idle(20);
        scene.overlay.showSelectionWithText(util.select.position(4, 1, 4), 80).colored(PonderPalette.RED).text("Mechanical Arms by themselves do not provide any options for filtering").placeNearTarget();
        scene.idle(90);
        for (int y = 0; y < 3; ++y) {
            scene.world.showSection(util.select.fromTo(5, y + 1, 2, 3, y + 1, 2), Direction.NORTH);
            scene.idle(2);
        }
        Vec3d filterSlot = util.vector.of(3.5, 3.75, 2.6);
        scene.overlay.showFilterSlotInput(filterSlot, 80);
        scene.idle(10);
        scene.overlay.showText(80).attachKeyFrame().colored(PonderPalette.GREEN).pointAt(filterSlot).text("Brass Funnels as Targets do however communicate their own filter to the Arm").placeNearTarget();
        scene.idle(90);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                ItemStack item = (x + y) % 2 == 0 ? sulphur : sand;
                scene.overlay.showControls(new InputWindowElement(filterSlot.func_72441_c((double)(2 - x), (double)(-y), 0.0), Pointing.LEFT).rightClick().withItem(item), 5);
                scene.idle(7);
                scene.world.setFilterData(util.select.position(5 - x, 3 - y, 2), FunnelTileEntity.class, item);
                scene.idle(4);
            }
        }
        scene.world.setKineticSpeed(util.select.fromTo(4, 1, 4, 6, 0, 5), 24.0f);
        scene.world.multiplyKineticSpeed(util.select.position(5, 1, 5), -1.0f);
        scene.world.multiplyKineticSpeed(util.select.position(4, 1, 4), 2.0f);
        scene.idle(10);
        BlockPos armPos = util.grid.at(4, 1, 4);
        scene.world.instructArm(armPos, ArmTileEntity.Phase.MOVE_TO_INPUT, ItemStack.field_190927_a, 1);
        scene.idle(24);
        scene.world.instructArm(armPos, ArmTileEntity.Phase.SEARCH_OUTPUTS, sand, -1);
        scene.idle(20);
        scene.overlay.showText(80).attachKeyFrame().pointAt(util.vector.topOf(2, 1, 4)).text("The Arm is smart enough not to pick up items it couldn't distribute").placeNearTarget();
        scene.idle(90);
        for (i = 0; i < 4; ++i) {
            int index = i * 2 + 1;
            scene.world.instructArm(armPos, ArmTileEntity.Phase.MOVE_TO_OUTPUT, sand, index);
            scene.idle(24);
            funnelPos = util.grid.at(5 - index % 3, 1 + index / 3, 2);
            scene.world.flapFunnel(funnelPos, false);
            scene.world.instructArm(armPos, ArmTileEntity.Phase.SEARCH_INPUTS, i == 3 ? ItemStack.field_190927_a : sand, -1);
            scene.world.modifyTileEntity(funnelPos.func_177978_c(), MechanicalCrafterTileEntity.class, mct -> mct.getInventory().insertItem(0, sand.func_77946_l(), false));
            scene.idle(10);
        }
        scene.world.instructArm(armPos, ArmTileEntity.Phase.MOVE_TO_INPUT, ItemStack.field_190927_a, 0);
        scene.idle(24);
        scene.world.instructArm(armPos, ArmTileEntity.Phase.SEARCH_OUTPUTS, sulphur, -1);
        scene.idle(20);
        scene.rotateCameraY(120.0f);
        scene.world.setCraftingResult(util.grid.at(3, 1, 1), new ItemStack((IItemProvider)Blocks.field_150335_W));
        for (i = 0; i < 5; ++i) {
            int index = i * 2;
            scene.world.instructArm(armPos, ArmTileEntity.Phase.MOVE_TO_OUTPUT, sulphur, index);
            scene.idle(24);
            funnelPos = util.grid.at(3 + index % 3, 1 + index / 3, 2);
            scene.world.flapFunnel(funnelPos, false);
            scene.world.instructArm(armPos, ArmTileEntity.Phase.SEARCH_INPUTS, i == 4 ? ItemStack.field_190927_a : sulphur, -1);
            scene.world.modifyTileEntity(funnelPos.func_177978_c(), MechanicalCrafterTileEntity.class, mct -> mct.getInventory().insertItem(0, sulphur.func_77946_l(), false));
            scene.idle(10);
        }
        scene.idle(120);
    }

    public static void modes(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("mechanical_arm_modes", "Distribution modes of the Mechanical Arm");
        scene.configureBasePlate(0, 1, 5);
        scene.world.setBlock(util.grid.at(3, 1, 0), Blocks.field_180401_cv.func_176223_P(), false);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(3, 1, 4, 4, 1, 5), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(1, 1, 4, 1, 2, 5), Direction.NORTH);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(1, 1, 1, 5, 1, 2), Direction.SOUTH);
        scene.idle(10);
        AxisAlignedBB depotBox = AllShapes.DEPOT.func_197752_a();
        AxisAlignedBB beltBox = depotBox.func_191195_a(0.0, -0.1875, 0.0).func_72314_b(1.0, 0.0, 0.0);
        BlockPos depotPos = util.grid.at(1, 1, 4);
        BlockPos armPos = util.grid.at(3, 1, 4);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.INPUT, depotBox, depotBox.func_72317_d(1.0, 1.0, 4.0), 60);
        scene.overlay.showText(30).text("Input").pointAt(util.vector.blockSurface(depotPos, Direction.WEST)).placeNearTarget().colored(PonderPalette.INPUT);
        scene.idle(40);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.OUTPUT, depotBox, beltBox.func_72317_d(2.0, 1.0, 2.0), 40);
        scene.overlay.showText(40).text("Outputs").pointAt(util.vector.blockSurface(util.grid.at(1, 1, 2), Direction.WEST)).placeNearTarget().colored(PonderPalette.OUTPUT);
        scene.idle(50);
        ItemStack item = new ItemStack((IItemProvider)Items.field_151126_ay);
        scene.world.createItemOnBeltLike(depotPos, Direction.SOUTH, item);
        scene.overlay.showText(60).attachKeyFrame().text("Whenever an Arm has to choose between multiple valid outputs...").pointAt(util.vector.blockSurface(util.grid.at(2, 1, 2), Direction.UP)).placeNearTarget().colored(PonderPalette.OUTPUT);
        scene.idle(70);
        Vec3d scrollSlot = util.vector.of(3.5, 1.25, 4.0);
        scene.overlay.showFilterSlotInput(scrollSlot, 120);
        scene.overlay.showText(50).text("...it will act according to its setting").pointAt(scrollSlot).placeNearTarget();
        scene.idle(60);
        scene.overlay.showControls(new InputWindowElement(scrollSlot, Pointing.RIGHT).scroll().withWrench(), 40);
        scene.idle(10);
        scene.overlay.showText(50).text("Scrolling with a Wrench will allow you to configure it").pointAt(scrollSlot).placeNearTarget();
        scene.idle(60);
        ElementLink<WorldSectionElement> blockage = scene.world.showIndependentSection(util.select.position(4, 1, 0), Direction.UP);
        scene.world.moveSection(blockage, util.vector.of(-1.0, 0.0, 0.0), 0);
        for (int i = 0; i < 20; ++i) {
            if (i == 2) {
                scene.overlay.showText(60).attachKeyFrame().text("Round Robin mode simply cycles through all outputs that are available").pointAt(util.vector.blockSurface(util.grid.at(2, 1, 2), Direction.UP)).placeNearTarget().colored(PonderPalette.OUTPUT);
            }
            if (i == 6) continue;
            if (i == 7) {
                scene.overlay.showText(60).attachKeyFrame().text("If an output is unable to take more items, it will be skipped").pointAt(util.vector.blockSurface(util.grid.at(3, 1, 2), Direction.UP)).placeNearTarget().colored(PonderPalette.GREEN);
            }
            if (i == 12) {
                scene.world.moveSection(blockage, util.vector.of(-1.0, 0.0, 0.0), 10);
                scene.world.setBlock(util.grid.at(3, 1, 0), Blocks.field_180401_cv.func_176223_P(), false);
            }
            int index = i % 3;
            if (i == 13) {
                scene.world.setBlock(util.grid.at(2, 1, 0), Blocks.field_180401_cv.func_176223_P(), false);
                ElementLink<WorldSectionElement> blockage2 = scene.world.showIndependentSection(util.select.position(4, 1, 0), Direction.UP);
                scene.world.moveSection(blockage2, util.vector.of(-2.0, 0.0, 0.0), 0);
                scene.overlay.showText(60).attachKeyFrame().text("Prefer First prioritizes the outputs selected earliest when configuring this Arm").pointAt(util.vector.blockSurface(util.grid.at(3, 1, 2), Direction.UP)).placeNearTarget().colored(PonderPalette.GREEN);
                index = 0;
            }
            if (i == 14) {
                index = 1;
            }
            if (i == 15) {
                index = 1;
            }
            if (i >= 16) {
                index = 2;
            }
            scene.idle(5);
            scene.world.instructArm(armPos, ArmTileEntity.Phase.MOVE_TO_INPUT, ItemStack.field_190927_a, 0);
            scene.idle(12);
            scene.world.instructArm(armPos, ArmTileEntity.Phase.SEARCH_OUTPUTS, item, -1);
            scene.world.removeItemsFromBelt(depotPos);
            scene.idle(5);
            if (i == 9) {
                scene.overlay.showText(80).attachKeyFrame().text("Forced Round Robin mode will never skip outputs, and instead wait until they are free").pointAt(util.vector.blockSurface(util.grid.at(3, 1, 2), Direction.UP)).placeNearTarget().colored(PonderPalette.RED);
                scene.idle(40);
                scene.world.moveSection(blockage, util.vector.of(1.0, 0.0, 0.0), 10);
                scene.world.setBlock(util.grid.at(3, 1, 0), Blocks.field_150350_a.func_176223_P(), false);
                scene.idle(50);
                scene.world.multiplyKineticSpeed(util.select.fromTo(1, 1, 1, 5, 0, 3), 2.0f);
            }
            scene.world.instructArm(armPos, ArmTileEntity.Phase.MOVE_TO_OUTPUT, item, index);
            scene.world.createItemOnBeltLike(depotPos, Direction.SOUTH, item);
            scene.idle(12);
            scene.world.instructArm(armPos, ArmTileEntity.Phase.SEARCH_INPUTS, ItemStack.field_190927_a, -1);
            scene.world.createItemOnBelt(util.grid.at(3 - index, 1, 2), Direction.UP, item);
        }
    }

    public static void redstone(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("mechanical_arm_redstone", "Controlling Mechanical Arms with Redstone");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(1, 1, 3, 2, 1, 4), Direction.DOWN);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(3, 1, 5, 4, 1, 3), Direction.WEST);
        scene.idle(5);
        scene.world.showSection(util.select.position(4, 1, 2), Direction.SOUTH);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(2, 1, 1, 4, 1, 1), Direction.EAST);
        scene.idle(10);
        Selection redstone = util.select.fromTo(1, 1, 0, 1, 1, 2);
        scene.world.showSection(redstone, Direction.SOUTH);
        BlockPos armPos = util.grid.at(1, 1, 3);
        BlockPos leverPos = util.grid.at(1, 1, 0);
        ItemStack item = new ItemStack((IItemProvider)Items.field_221762_cq);
        scene.world.createItemOnBeltLike(util.grid.at(4, 1, 1), Direction.SOUTH, item);
        for (int i = 0; i < 3; ++i) {
            scene.idle(12);
            if (i == 1) {
                scene.world.toggleRedstonePower(redstone);
                scene.effects.indicateRedstone(leverPos);
                scene.idle(10);
                scene.overlay.showText(60).colored(PonderPalette.RED).attachKeyFrame().pointAt(util.vector.topOf(armPos.func_177984_a())).placeNearTarget().text("When powered by Redstone, Mechanical Arms will not activate");
                scene.idle(70);
                scene.world.toggleRedstonePower(redstone);
            }
            if (i == 2) {
                scene.idle(60);
                scene.world.toggleRedstonePower(redstone);
                scene.idle(3);
                scene.world.toggleRedstonePower(redstone);
                scene.effects.indicateRedstone(leverPos);
            }
            scene.world.instructArm(armPos, ArmTileEntity.Phase.MOVE_TO_INPUT, ItemStack.field_190927_a, 0);
            scene.idle(18);
            scene.world.instructArm(armPos, ArmTileEntity.Phase.SEARCH_OUTPUTS, item, -1);
            scene.world.removeItemsFromBelt(util.grid.at(3, 1, 1));
            scene.idle(5);
            if (i == 1) {
                scene.world.toggleRedstonePower(redstone);
                scene.effects.indicateRedstone(leverPos);
                scene.overlay.showText(60).pointAt(util.vector.topOf(armPos.func_177984_a())).placeNearTarget().text("Before stopping, it will finish any started cycles");
            }
            scene.idle(10);
            if (i == 2) {
                scene.overlay.showText(100).colored(PonderPalette.GREEN).attachKeyFrame().pointAt(util.vector.topOf(armPos.func_177984_a())).placeNearTarget().text("Thus, a negative pulse can be used to trigger exactly one activation cycle");
            }
            scene.world.instructArm(armPos, ArmTileEntity.Phase.MOVE_TO_OUTPUT, item, 0);
            scene.world.createItemOnBeltLike(util.grid.at(4, 1, 1), Direction.SOUTH, item);
            scene.idle(18);
            scene.world.instructArm(armPos, ArmTileEntity.Phase.SEARCH_INPUTS, ItemStack.field_190927_a, -1);
            scene.world.createItemOnBelt(util.grid.at(3, 1, 3), Direction.UP, item);
        }
        scene.idle(5);
    }
}

