/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.contraptions.components.actors.HarvesterTileEntity;
import com.simibubi.create.content.contraptions.components.actors.PortableItemInterfaceTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.chassis.LinearChassisBlock;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.content.PonderPalette;
import com.simibubi.create.foundation.ponder.elements.EntityElement;
import com.simibubi.create.foundation.ponder.elements.InputWindowElement;
import com.simibubi.create.foundation.ponder.elements.ParrotElement;
import com.simibubi.create.foundation.ponder.elements.WorldSectionElement;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class MovementActorScenes {
    public static void psiTransfer(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("portable_storage_interface", "Contraption Storage Exchange");
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(0.95f);
        scene.setSceneOffsetY(-1.0f);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(5);
        BlockPos bearing = util.grid.at(5, 1, 2);
        scene.world.showSection(util.select.position(bearing), Direction.DOWN);
        scene.idle(5);
        ElementLink<WorldSectionElement> contraption = scene.world.showIndependentSection(util.select.fromTo(5, 2, 2, 6, 3, 2), Direction.DOWN);
        scene.world.configureCenterOfRotation(contraption, util.vector.centerOf(bearing));
        scene.idle(10);
        scene.world.rotateBearing(bearing, 360.0f, 70);
        scene.world.rotateSection(contraption, 0.0, 360.0, 0.0, 70);
        scene.overlay.showText(60).pointAt(util.vector.topOf(bearing.func_177981_b(2))).colored(PonderPalette.RED).placeNearTarget().text("Inventories on moving contraptions cannot be accessed by players.");
        scene.idle(70);
        BlockPos psi = util.grid.at(4, 2, 2);
        scene.world.showSectionAndMerge(util.select.position(psi), Direction.EAST, contraption);
        scene.idle(13);
        scene.effects.superGlue(psi, Direction.EAST, true);
        scene.overlay.showText(80).pointAt(util.vector.topOf(psi)).colored(PonderPalette.GREEN).placeNearTarget().text("This component can interact with storage without the need to stop the contraption.");
        scene.idle(90);
        BlockPos psi2 = psi.func_177985_f(2);
        scene.world.showSection(util.select.position(psi2), Direction.DOWN);
        scene.overlay.showSelectionWithText(util.select.position(psi.func_177976_e()), 50).colored(PonderPalette.RED).placeNearTarget().text("Place a second one with a gap of 1 or 2 blocks inbetween");
        scene.idle(55);
        scene.world.rotateBearing(bearing, 360.0f, 60);
        scene.world.rotateSection(contraption, 0.0, 360.0, 0.0, 60);
        scene.idle(20);
        scene.overlay.showText(40).placeNearTarget().pointAt(util.vector.of(3.0, 3.0, 2.5)).text("Whenever they pass by each other, they will engage in a connection");
        scene.idle(35);
        Selection both = util.select.fromTo(2, 2, 2, 4, 2, 2);
        Class<PortableItemInterfaceTileEntity> psiClass = PortableItemInterfaceTileEntity.class;
        scene.world.modifyTileNBT(both, psiClass, nbt -> {
            nbt.func_74776_a("Distance", 1.0f);
            nbt.func_74776_a("Timer", 40.0f);
        });
        scene.idle(20);
        scene.overlay.showOutline(PonderPalette.GREEN, psi, util.select.fromTo(5, 3, 2, 6, 3, 2), 80);
        scene.idle(10);
        scene.overlay.showSelectionWithText(util.select.position(psi2), 70).placeNearTarget().colored(PonderPalette.GREEN).text("While engaged, the stationary interface will represent ALL inventories on the contraption");
        scene.idle(80);
        BlockPos hopper = util.grid.at(2, 3, 2);
        scene.world.showSection(util.select.position(hopper), Direction.DOWN);
        scene.overlay.showText(70).placeNearTarget().pointAt(util.vector.topOf(hopper)).text("Items can now be inserted...");
        ItemStack itemStack = AllItems.COPPER_INGOT.asStack();
        Vec3d entitySpawn = util.vector.topOf(hopper.func_177981_b(3));
        ElementLink<EntityElement> entity1 = scene.world.createItemEntity(entitySpawn, util.vector.of(0.0, 0.2, 0.0), itemStack);
        scene.idle(10);
        ElementLink<EntityElement> entity2 = scene.world.createItemEntity(entitySpawn, util.vector.of(0.0, 0.2, 0.0), itemStack);
        scene.idle(10);
        scene.world.modifyEntity(entity1, Entity::func_70106_y);
        scene.idle(10);
        scene.world.modifyEntity(entity2, Entity::func_70106_y);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(5, 3, 2), Pointing.DOWN).withItem(itemStack), 40);
        scene.idle(30);
        scene.world.hideSection(util.select.position(hopper), Direction.UP);
        scene.idle(15);
        BlockPos beltPos = util.grid.at(1, 1, 2);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 1, 2, 6), Direction.DOWN);
        scene.idle(10);
        scene.world.createItemOnBelt(beltPos, Direction.EAST, itemStack.func_77946_l());
        scene.overlay.showText(40).placeNearTarget().pointAt(util.vector.topOf(beltPos.func_177984_a())).text("...or extracted from the contraption");
        scene.idle(15);
        scene.world.createItemOnBelt(beltPos, Direction.EAST, itemStack);
        scene.idle(20);
        scene.world.modifyEntities(ItemEntity.class, Entity::func_70106_y);
        scene.idle(15);
        scene.world.modifyEntities(ItemEntity.class, Entity::func_70106_y);
        scene.overlay.showText(120).placeNearTarget().pointAt(util.vector.topOf(psi2)).text("After no items have been exchanged for a while, the contraption will continue on its way");
        scene.world.modifyTileNBT(both, psiClass, nbt -> nbt.func_74776_a("Timer", 9.0f));
        scene.idle(15);
        scene.markAsFinished();
        scene.world.rotateBearing(bearing, 270.0f, 120);
        scene.world.rotateSection(contraption, 0.0, 270.0, 0.0, 120);
    }

    public static void psiRedstone(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("portable_storage_interface_redstone", "Redstone Control");
        scene.configureBasePlate(0, 0, 5);
        scene.setSceneOffsetY(-1.0f);
        Class<PortableItemInterfaceTileEntity> psiClass = PortableItemInterfaceTileEntity.class;
        Selection psis = util.select.fromTo(1, 1, 3, 1, 3, 3);
        scene.world.modifyTileNBT(psis, psiClass, nbt -> {
            nbt.func_74776_a("Distance", 1.0f);
            nbt.func_74776_a("Timer", 40.0f);
        });
        scene.world.showSection(util.select.layer(0), Direction.UP);
        scene.idle(5);
        scene.world.showSection(util.select.layer(1), Direction.DOWN);
        scene.idle(5);
        ElementLink<WorldSectionElement> contraption = scene.world.showIndependentSection(util.select.layersFrom(2), Direction.DOWN);
        BlockPos bearing = util.grid.at(3, 1, 3);
        scene.world.configureCenterOfRotation(contraption, util.vector.topOf(bearing));
        scene.idle(20);
        scene.world.modifyTileNBT(psis, psiClass, nbt -> nbt.func_74776_a("Timer", 9.0f));
        scene.idle(20);
        scene.world.rotateBearing(bearing, 1350.0f, 300);
        scene.world.rotateSection(contraption, 0.0, 1350.0, 0.0, 300);
        scene.idle(20);
        scene.world.toggleRedstonePower(util.select.fromTo(1, 1, 1, 1, 1, 2));
        scene.effects.indicateRedstone(util.grid.at(1, 1, 1));
        scene.idle(10);
        scene.overlay.showSelectionWithText(util.select.position(1, 1, 3), 120).colored(PonderPalette.RED).text("Redstone power will prevent the stationary interface from engaging");
        scene.idle(20);
        scene.markAsFinished();
    }

    public static void harvester(SceneBuilder scene, SceneBuildingUtil util) {
        int i;
        int i2;
        scene.title("mechanical_harvester", "Using Mechanical Harvesters on Contraptions");
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(0.9f);
        Selection crops = util.select.fromTo(4, 1, 2, 3, 1, 2).add(util.select.fromTo(3, 1, 1, 2, 1, 1).add(util.select.position(2, 1, 3)).add(util.select.position(1, 1, 2)));
        scene.world.setBlocks(crops, (BlockState)Blocks.field_150464_aj.func_176223_P().func_206870_a((IProperty)CropsBlock.field_176488_a, (Comparable)Integer.valueOf(7)), false);
        scene.world.showSection(util.select.layer(0), Direction.UP);
        BlockPos bearingPos = util.grid.at(4, 1, 4);
        scene.idle(5);
        scene.world.showSection(crops, Direction.UP);
        scene.world.showSection(util.select.position(bearingPos), Direction.DOWN);
        scene.idle(5);
        ElementLink<WorldSectionElement> contraption = scene.world.showIndependentSection(util.select.fromTo(4, 2, 4, 2, 2, 5).add(util.select.fromTo(2, 1, 5, 0, 1, 5)), Direction.DOWN);
        scene.world.configureCenterOfRotation(contraption, util.vector.centerOf(bearingPos));
        scene.idle(10);
        for (i2 = 0; i2 < 3; ++i2) {
            scene.world.showSectionAndMerge(util.select.position(i2, 1, 4), Direction.SOUTH, contraption);
            scene.idle(5);
        }
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(1, 1, 4), Direction.SOUTH)).text("Whenever Harvesters are moved as part of an animated Contraption...");
        scene.idle(70);
        for (i2 = 0; i2 < 3; ++i2) {
            scene.world.modifyTileEntity(util.grid.at(i2, 1, 4), HarvesterTileEntity.class, hte -> hte.setAnimatedSpeed(-150.0f));
        }
        scene.world.rotateBearing(bearingPos, -360.0f, 140);
        scene.world.rotateSection(contraption, 0.0, -360.0, 0.0, 140);
        BlockState harvested = Blocks.field_150464_aj.func_176223_P();
        ItemStack wheatItem = new ItemStack((IItemProvider)Items.field_151015_O);
        scene.idle(5);
        BlockPos current = util.grid.at(2, 1, 3);
        scene.world.setBlock(current, harvested, true);
        scene.world.createItemEntity(util.vector.centerOf(current), util.vector.of(0.0, 0.3, -0.2), wheatItem);
        scene.idle(5);
        current = util.grid.at(1, 1, 2);
        scene.world.setBlock(current, harvested, true);
        scene.world.createItemEntity(util.vector.centerOf(current), util.vector.of(0.0, 0.3, -0.2), wheatItem);
        scene.idle(5);
        current = util.grid.at(3, 1, 2);
        scene.world.setBlock(current, harvested, true);
        scene.world.createItemEntity(util.vector.centerOf(current), util.vector.of(0.1, 0.3, -0.1), wheatItem);
        current = util.grid.at(2, 1, 1);
        scene.world.setBlock(current, harvested, true);
        scene.world.createItemEntity(util.vector.centerOf(current), util.vector.of(0.1, 0.3, -0.1), wheatItem);
        scene.idle(5);
        current = util.grid.at(3, 1, 1);
        scene.world.setBlock(current, harvested, true);
        scene.world.createItemEntity(util.vector.centerOf(current), util.vector.of(0.1, 0.3, -0.1), wheatItem);
        scene.idle(5);
        current = util.grid.at(4, 1, 2);
        scene.world.setBlock(current, harvested, true);
        scene.world.createItemEntity(util.vector.centerOf(current), util.vector.of(0.2, 0.3, 0.0), wheatItem);
        scene.overlay.showText(80).pointAt(util.vector.topOf(1, 0, 2)).text("They will harvest and reset any mature crops on their way").placeNearTarget();
        scene.idle(101);
        scene.world.hideSection(crops, Direction.DOWN);
        scene.idle(15);
        scene.world.modifyEntities(ItemEntity.class, Entity::func_70106_y);
        scene.world.setBlocks(crops, (BlockState)Blocks.field_150464_aj.func_176223_P().func_206870_a((IProperty)CropsBlock.field_176488_a, (Comparable)Integer.valueOf(7)), false);
        scene.world.showSection(crops, Direction.UP);
        for (i = 0; i < 3; ++i) {
            scene.world.modifyTileEntity(util.grid.at(i, 1, 4), HarvesterTileEntity.class, hte -> hte.setAnimatedSpeed(0.0f));
        }
        scene.idle(10);
        scene.world.cycleBlockProperty(util.grid.at(1, 1, 5), (IProperty<?>)LinearChassisBlock.STICKY_TOP);
        scene.world.glueBlockOnto(util.grid.at(1, 2, 5), Direction.DOWN, contraption);
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(1, 2, 5), Direction.WEST)).sharedText("storage_on_contraption");
        scene.idle(70);
        for (i = 0; i < 3; ++i) {
            scene.world.modifyTileEntity(util.grid.at(i, 1, 4), HarvesterTileEntity.class, hte -> hte.setAnimatedSpeed(-150.0f));
        }
        scene.world.rotateBearing(bearingPos, -360.0f, 140);
        scene.world.rotateSection(contraption, 0.0, -360.0, 0.0, 140);
        scene.idle(5);
        current = util.grid.at(2, 1, 3);
        scene.world.setBlock(current, harvested, true);
        scene.idle(5);
        current = util.grid.at(1, 1, 2);
        scene.world.setBlock(current, harvested, true);
        scene.idle(5);
        current = util.grid.at(3, 1, 2);
        scene.world.setBlock(current, harvested, true);
        current = util.grid.at(2, 1, 1);
        scene.world.setBlock(current, harvested, true);
        scene.idle(5);
        current = util.grid.at(3, 1, 1);
        scene.world.setBlock(current, harvested, true);
        scene.idle(5);
        current = util.grid.at(4, 1, 2);
        scene.world.setBlock(current, harvested, true);
        scene.idle(116);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(1, 2, 5), Pointing.DOWN).withItem(wheatItem), 50);
        for (i = 0; i < 3; ++i) {
            scene.world.modifyTileEntity(util.grid.at(i, 1, 4), HarvesterTileEntity.class, hte -> hte.setAnimatedSpeed(0.0f));
        }
    }

    public static void plough(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("mechanical_plough", "Using Mechanical Ploughs on Contraptions");
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(0.9f);
        Selection garbage = util.select.fromTo(2, 1, 3, 1, 1, 2);
        Selection kinetics = util.select.fromTo(5, 1, 6, 5, 1, 2);
        Selection dynamic = util.select.fromTo(4, 0, 6, 5, 1, 6);
        scene.showBasePlate();
        ElementLink<WorldSectionElement> cogs = scene.world.showIndependentSection(util.select.fromTo(4, 0, 6, 5, 1, 6), Direction.UP);
        scene.idle(5);
        scene.world.showSection(kinetics.substract(dynamic), Direction.DOWN);
        ElementLink<WorldSectionElement> pistonHead = scene.world.showIndependentSection(util.select.fromTo(5, 1, 1, 7, 1, 1), Direction.DOWN);
        scene.world.moveSection(pistonHead, util.vector.of(0.0, 0.0, 1.0), 0);
        scene.idle(5);
        ElementLink<WorldSectionElement> contraption = scene.world.showIndependentSection(util.select.fromTo(4, 1, 3, 4, 1, 2), Direction.DOWN);
        scene.idle(10);
        scene.world.showSectionAndMerge(util.select.position(3, 1, 3), Direction.EAST, contraption);
        scene.idle(5);
        scene.world.showSectionAndMerge(util.select.position(3, 1, 2), Direction.EAST, contraption);
        scene.idle(20);
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(3, 1, 3), Direction.EAST)).text("Whenever Ploughs are moved as part of an animated Contraption...");
        scene.idle(50);
        scene.world.showSection(garbage, Direction.EAST);
        scene.idle(20);
        scene.world.setKineticSpeed(util.select.position(4, 0, 6), -8.0f);
        scene.world.setKineticSpeed(kinetics, 16.0f);
        scene.world.moveSection(pistonHead, util.vector.of(-2.0, 0.0, 0.0), 60);
        scene.world.moveSection(contraption, util.vector.of(-2.0, 0.0, 0.0), 60);
        scene.idle(15);
        Vec3d m = util.vector.of(-0.1, 0.2, 0.0);
        scene.world.destroyBlock(util.grid.at(2, 1, 3));
        scene.world.createItemEntity(util.vector.centerOf(2, 1, 3), m, new ItemStack((IItemProvider)Items.field_221746_ci));
        scene.world.destroyBlock(util.grid.at(2, 1, 2));
        scene.world.createItemEntity(util.vector.centerOf(2, 1, 2), m, new ItemStack((IItemProvider)Items.field_221657_bQ));
        scene.idle(30);
        scene.world.destroyBlock(util.grid.at(1, 1, 3));
        scene.world.createItemEntity(util.vector.centerOf(1, 1, 3), m, new ItemStack((IItemProvider)Items.field_221742_cg));
        scene.world.destroyBlock(util.grid.at(1, 1, 2));
        scene.world.createItemEntity(util.vector.centerOf(1, 1, 2), m, new ItemStack((IItemProvider)Items.field_151137_ax));
        scene.overlay.showText(60).placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(1, 1, 3), Direction.EAST)).text("...they will break blocks without a solid collision hitbox");
        scene.idle(50);
        scene.world.modifyKineticSpeed(util.select.everywhere(), f -> Float.valueOf(-f.floatValue()));
        scene.world.moveSection(pistonHead, util.vector.of(2.0, 0.0, 0.0), 40);
        scene.world.moveSection(contraption, util.vector.of(2.0, 0.0, 0.0), 40);
        scene.world.hideSection(garbage, Direction.UP);
        scene.idle(40);
        scene.world.setBlocks(garbage, Blocks.field_150433_aE.func_176223_P(), false);
        scene.world.modifyEntities(ItemEntity.class, Entity::func_70106_y);
        ElementLink<WorldSectionElement> chest = scene.world.showIndependentSection(util.select.position(4, 2, 2), Direction.DOWN);
        scene.overlay.showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(4, 2, 2), Direction.WEST)).sharedText("storage_on_contraption");
        scene.idle(15);
        scene.effects.superGlue(util.grid.at(4, 2, 2), Direction.DOWN, true);
        scene.idle(45);
        scene.world.showSection(garbage, Direction.EAST);
        scene.idle(20);
        scene.world.modifyKineticSpeed(util.select.everywhere(), f -> Float.valueOf(-f.floatValue()));
        scene.world.moveSection(pistonHead, util.vector.of(-2.0, 0.0, 0.0), 60);
        scene.world.moveSection(contraption, util.vector.of(-2.0, 0.0, 0.0), 60);
        scene.world.moveSection(chest, util.vector.of(-2.0, 0.0, 0.0), 60);
        scene.idle(15);
        scene.world.destroyBlock(util.grid.at(2, 1, 3));
        scene.world.destroyBlock(util.grid.at(2, 1, 2));
        scene.idle(30);
        scene.world.destroyBlock(util.grid.at(1, 1, 3));
        scene.world.destroyBlock(util.grid.at(1, 1, 2));
        scene.idle(15);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(2, 2, 2), Pointing.DOWN).withItem(new ItemStack((IItemProvider)Items.field_151126_ay)), 40);
        scene.idle(40);
        scene.world.hideIndependentSection(chest, Direction.UP);
        scene.world.modifyKineticSpeed(util.select.everywhere(), f -> Float.valueOf(-f.floatValue()));
        scene.world.moveSection(pistonHead, util.vector.of(2.0, 0.0, 0.0), 40);
        scene.world.moveSection(contraption, util.vector.of(2.0, 0.0, 0.0), 40);
        scene.idle(40);
        Selection dirt = util.select.fromTo(2, 0, 3, 1, 0, 2);
        scene.world.hideSection(dirt, Direction.DOWN);
        scene.idle(15);
        scene.world.setBlocks(dirt, Blocks.field_196658_i.func_176223_P(), false);
        scene.world.showSection(dirt, Direction.UP);
        scene.overlay.showText(60).placeNearTarget().attachKeyFrame().pointAt(util.vector.blockSurface(util.grid.at(3, 1, 3), Direction.EAST)).text("Additionally, ploughs can create farmland");
        scene.idle(30);
        scene.world.modifyKineticSpeed(util.select.everywhere(), f -> Float.valueOf(-f.floatValue()));
        scene.world.moveSection(pistonHead, util.vector.of(-2.0, 0.0, 0.0), 60);
        scene.world.moveSection(contraption, util.vector.of(-2.0, 0.0, 0.0), 60);
        scene.world.moveSection(chest, util.vector.of(-2.0, 0.0, 0.0), 60);
        scene.idle(15);
        scene.world.setBlocks(util.select.fromTo(2, 0, 2, 2, 0, 3), Blocks.field_150458_ak.func_176223_P(), true);
        scene.idle(30);
        scene.world.setBlocks(util.select.fromTo(1, 0, 2, 1, 0, 3), Blocks.field_150458_ak.func_176223_P(), true);
        scene.idle(20);
        scene.world.modifyKineticSpeed(util.select.everywhere(), f -> Float.valueOf(-f.floatValue()));
        scene.world.moveSection(pistonHead, util.vector.of(2.0, 0.0, 0.0), 40);
        scene.world.moveSection(contraption, util.vector.of(2.0, 0.0, 0.0), 40);
        scene.idle(50);
        scene.world.setKineticSpeed(util.select.everywhere(), 0.0f);
        scene.world.hideSection(kinetics.substract(dynamic), Direction.EAST);
        scene.world.hideSection(dirt, Direction.DOWN);
        scene.world.hideIndependentSection(pistonHead, Direction.EAST);
        scene.world.moveSection(cogs, util.vector.of(-1.0, 0.0, 0.0), 15);
        scene.idle(15);
        scene.world.restoreBlocks(dirt);
        scene.world.showSection(dirt, Direction.UP);
        scene.world.showSection(util.select.fromTo(4, 1, 6, 4, 3, 4), Direction.NORTH);
        scene.idle(15);
        scene.world.showSectionAndMerge(util.select.fromTo(4, 3, 3, 4, 2, 3), Direction.DOWN, contraption);
        scene.idle(15);
        BlockPos bearingPos = util.grid.at(4, 3, 4);
        scene.addKeyframe();
        scene.world.setKineticSpeed(util.select.position(4, 0, 6), 8.0f);
        scene.world.setKineticSpeed(util.select.position(5, 1, 6), -16.0f);
        scene.world.setKineticSpeed(util.select.position(4, 3, 5), -16.0f);
        scene.world.setKineticSpeed(util.select.position(4, 1, 5), -16.0f);
        scene.world.setKineticSpeed(util.select.position(4, 2, 5), 16.0f);
        scene.world.modifyKineticSpeed(util.select.everywhere(), f -> Float.valueOf(-2.0f * f.floatValue()));
        scene.world.configureCenterOfRotation(contraption, util.vector.centerOf(bearingPos));
        scene.world.rotateSection(contraption, 0.0, 0.0, 90.0, 20);
        scene.world.rotateBearing(bearingPos, 90.0f, 20);
        scene.idle(10);
        ElementLink<ParrotElement> birb = scene.special.createBirb(util.vector.topOf(3, 0, 2).func_72441_c(0.0, 0.0, 0.5), ParrotElement.FlappyPose::new);
        scene.idle(11);
        scene.world.modifyKineticSpeed(util.select.everywhere(), f -> Float.valueOf(-2.0f * f.floatValue()));
        scene.world.rotateSection(contraption, 0.0, 0.0, -135.0, 10);
        scene.world.rotateBearing(bearingPos, -135.0f, 10);
        scene.idle(7);
        scene.special.moveParrot(birb, util.vector.of(-20.0, 15.0, 0.0), 20);
        scene.special.rotateParrot(birb, 0.0, 360.0, 0.0, 20);
        scene.idle(3);
        scene.world.setKineticSpeed(util.select.everywhere(), 0.0f);
        scene.idle(20);
        scene.overlay.showText(60).placeNearTarget().pointAt(util.vector.centerOf(util.grid.at(1, 3, 2))).text("...they can also launch entities without hurting them");
        scene.idle(30);
    }
}

