/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.IScreenRenderable;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.content.PonderTag;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;

public class PonderChapter
implements IScreenRenderable {
    private final String id;
    private final ResourceLocation icon;

    private PonderChapter(String id) {
        this.id = id;
        this.icon = new ResourceLocation("create", "textures/ponder/chapter/" + id + ".png");
    }

    @Override
    public void draw(AbstractGui screen, int x, int y) {
        RenderSystem.pushMatrix();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.icon);
        RenderSystem.scaled((double)0.25, (double)0.25, (double)1.0);
        AbstractGui.blit((int)x, (int)y, (int)0, (float)0.0f, (float)0.0f, (int)64, (int)64, (int)64, (int)64);
        RenderSystem.popMatrix();
    }

    @Nonnull
    public static PonderChapter of(String id) {
        PonderChapter chapter = PonderRegistry.chapters.getChapter(id);
        if (chapter == null) {
            chapter = PonderRegistry.chapters.addChapter(new PonderChapter(id));
        }
        return chapter;
    }

    public PonderChapter addTagsToChapter(PonderTag ... tags) {
        for (PonderTag t : tags) {
            PonderRegistry.tags.add(t, this);
        }
        return this;
    }

    public String getId() {
        return this.id;
    }
}

