/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.crank.ValveHandleBlock;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.ponder.NavigatableSimiScreen;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.ponder.content.PonderChapter;
import com.simibubi.create.foundation.ponder.ui.ChapterLabel;
import com.simibubi.create.foundation.ponder.ui.LayoutHelper;
import com.simibubi.create.foundation.ponder.ui.PonderButton;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.client.MainWindow;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class PonderIndexScreen
extends NavigatableSimiScreen {
    protected final List<PonderChapter> chapters;
    private final double chapterXmult = 0.5;
    private final double chapterYmult = 0.3;
    protected Rectangle2d chapterArea;
    protected final List<Item> items;
    private final double itemXmult = 0.5;
    private double itemYmult = 0.75;
    protected Rectangle2d itemArea;
    private ItemStack hoveredItem = ItemStack.field_190927_a;

    public PonderIndexScreen() {
        this.chapters = new ArrayList<PonderChapter>();
        this.items = new ArrayList<Item>();
    }

    @Override
    protected void init() {
        this.widgets.clear();
        super.init();
        this.chapters.clear();
        this.items.clear();
        PonderRegistry.all.keySet().stream().map(key -> {
            Block b;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(key);
            if (item == null && (b = (Block)ForgeRegistries.BLOCKS.getValue(key)) != null) {
                item = b.func_199767_j();
            }
            return item;
        }).filter(Objects::nonNull).filter(PonderIndexScreen::exclusions).forEach(this.items::add);
        boolean hasChapters = !this.chapters.isEmpty();
        LayoutHelper layout = LayoutHelper.centeredHorizontal(this.chapters.size(), MathHelper.func_76125_a((int)((int)Math.ceil((float)this.chapters.size() / 4.0f)), (int)1, (int)4), 200, 38, 16);
        this.chapterArea = layout.getArea();
        int chapterCenterX = (int)((double)this.width * 0.5);
        int chapterCenterY = (int)((double)this.height * 0.3);
        for (PonderChapter chapter : this.chapters) {
            ChapterLabel label = new ChapterLabel(chapter, chapterCenterX + layout.getX(), chapterCenterY + layout.getY(), (mouseX, mouseY) -> {
                this.centerScalingOn((int)mouseX, (int)mouseY);
                ScreenOpener.transitionTo(PonderUI.of(chapter));
            });
            this.widgets.add(label);
            layout.next();
        }
        if (!hasChapters) {
            this.itemYmult = 0.5;
        }
        int maxItemRows = hasChapters ? 4 : 7;
        layout = LayoutHelper.centeredHorizontal(this.items.size(), MathHelper.func_76125_a((int)((int)Math.ceil((float)this.items.size() / 11.0f)), (int)1, (int)maxItemRows), 28, 28, 8);
        this.itemArea = layout.getArea();
        int itemCenterX = (int)((double)this.width * 0.5);
        int itemCenterY = (int)((double)this.height * this.itemYmult);
        for (Item item : this.items) {
            PonderButton button = new PonderButton(itemCenterX + layout.getX() + 4, itemCenterY + layout.getY() + 4, (x, y) -> {
                if (!PonderRegistry.all.containsKey(item.getRegistryName())) {
                    return;
                }
                this.centerScalingOn((int)x, (int)y);
                ScreenOpener.transitionTo(PonderUI.of(new ItemStack((IItemProvider)item)));
            }).showing(new ItemStack((IItemProvider)item));
            button.fade(1.0f);
            this.widgets.add(button);
            layout.next();
        }
    }

    private static boolean exclusions(Item item) {
        Block block;
        return !(item instanceof BlockItem) || !((block = ((BlockItem)item).func_179223_d()) instanceof ValveHandleBlock) || AllBlocks.COPPER_VALVE_HANDLE.is(item);
    }

    @Override
    public void tick() {
        super.tick();
        ++PonderUI.ponderTicks;
        this.hoveredItem = ItemStack.field_190927_a;
        MainWindow w = this.minecraft.func_228018_at_();
        double mouseX = this.minecraft.field_71417_B.func_198024_e() * (double)w.func_198107_o() / (double)w.func_198105_m();
        double mouseY = this.minecraft.field_71417_B.func_198026_f() * (double)w.func_198087_p() / (double)w.func_198083_n();
        for (Widget widget : this.widgets) {
            if (!(widget instanceof PonderButton) || !widget.isMouseOver(mouseX, mouseY)) continue;
            this.hoveredItem = ((PonderButton)widget).getItem();
        }
    }

    @Override
    protected void renderWindow(int mouseX, int mouseY, float partialTicks) {
        int x = (int)((double)this.width * 0.5);
        int y = (int)((double)this.height * 0.3);
        if (!this.chapters.isEmpty()) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)x, (double)y, (double)0.0);
            UIRenderHelper.streak(0.0f, this.chapterArea.func_199318_a() - 10, this.chapterArea.func_199319_b() - 20, 20, 220, 0x101010);
            this.drawString(this.font, "Topics to Ponder about", this.chapterArea.func_199318_a() - 5, this.chapterArea.func_199319_b() - 25, -2232577);
            RenderSystem.popMatrix();
        }
        x = (int)((double)this.width * 0.5);
        y = (int)((double)this.height * this.itemYmult);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)x, (double)y, (double)0.0);
        UIRenderHelper.streak(0.0f, this.itemArea.func_199318_a() - 10, this.itemArea.func_199319_b() - 20, 20, 220, 0x101010);
        this.drawString(this.font, "Items to inspect", this.itemArea.func_199318_a() - 5, this.itemArea.func_199319_b() - 25, -2232577);
        RenderSystem.popMatrix();
    }

    @Override
    protected void renderWindowForeground(int mouseX, int mouseY, float partialTicks) {
        if (this.hoveredItem.func_190926_b()) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)200.0);
        this.renderTooltip(this.hoveredItem, mouseX, mouseY);
        RenderSystem.popMatrix();
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        MutableBoolean handled = new MutableBoolean(false);
        this.widgets.forEach(w -> {
            if (handled.booleanValue()) {
                return;
            }
            if (!w.isMouseOver(x, y)) {
                return;
            }
            if (w instanceof PonderButton) {
                PonderButton btn = (PonderButton)((Object)w);
                btn.runCallback(x, y);
                handled.setTrue();
            }
        });
        if (handled.booleanValue()) {
            return true;
        }
        return super.mouseClicked(x, y, button);
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        return other instanceof PonderIndexScreen;
    }

    public ItemStack getHoveredTooltipItem() {
        return this.hoveredItem;
    }

    @Override
    public boolean isPauseScreen() {
        return true;
    }
}

