/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.IScreenRenderable;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PonderTag
implements IScreenRenderable {
    public static final PonderTag KINETIC_RELAYS = new PonderTag("kinetic_relays").item((IItemProvider)AllBlocks.COGWHEEL.get(), true, false).defaultLang("Kinetic Blocks", "Components which help relaying Rotational Force elsewhere");
    public static final PonderTag KINETIC_SOURCES = new PonderTag("kinetic_sources").item((IItemProvider)AllBlocks.WATER_WHEEL.get(), true, false).defaultLang("Kinetic Sources", "Components which generate Rotational Force");
    public static final PonderTag KINETIC_APPLIANCES = new PonderTag("kinetic_appliances").item((IItemProvider)AllBlocks.MECHANICAL_PRESS.get(), true, false).defaultLang("Kinetic Appliances", "Components which make use of Rotational Force");
    public static final PonderTag FLUIDS = new PonderTag("fluids").item((IItemProvider)AllBlocks.FLUID_PIPE.get(), true, false).defaultLang("Fluid Manipulators", "Components which help relaying and making use of Fluids");
    public static final PonderTag LOGISTICS = new PonderTag("logistics").item((IItemProvider)Blocks.field_150486_ae, true, false).defaultLang("Item Transportation", "Components which help moving items around");
    public static final PonderTag REDSTONE = new PonderTag("redstone").item((IItemProvider)Items.field_151137_ax, true, false).defaultLang("Logic Components", "Components which help with redstone engineering");
    public static final PonderTag DECORATION = new PonderTag("decoration").item((IItemProvider)Items.field_221912_fn, true, false).defaultLang("Aesthetics", "Components used mostly for decorative purposes");
    public static final PonderTag CREATIVE = new PonderTag("creative").item((IItemProvider)AllBlocks.CREATIVE_CRATE.get(), true, false).defaultLang("Creative Mode", "Components not usually available for Survival Mode");
    public static final PonderTag MOVEMENT_ANCHOR = new PonderTag("movement_anchor").item((IItemProvider)AllBlocks.MECHANICAL_PISTON.get(), true, false).defaultLang("Movement Anchors", "Components which allow the creation of moving contraptions, animating an attached structure in a variety of ways");
    public static final PonderTag CONTRAPTION_ACTOR = new PonderTag("contraption_actor").item((IItemProvider)AllBlocks.MECHANICAL_HARVESTER.get(), true, false).defaultLang("Contraption Actors", "Components which expose special behaviour when attached to a moving contraption");
    public static final PonderTag CONTRAPTION_ASSEMBLY = new PonderTag("contraption_assembly").item((IItemProvider)AllItems.SUPER_GLUE.get(), true, false).defaultLang("Block Attachment Utility", "Tools and Components used to assemble structures moved as an animated Contraption");
    public static final PonderTag SAILS = new PonderTag("windmill_sails").item((IItemProvider)AllBlocks.WINDMILL_BEARING.get(), true, true).defaultLang("Sails for Windmill Bearings", "Blocks that count towards the strength of a Windmill Contraption when assembled. Each of these have equal efficiency in doing so.");
    public static final PonderTag ARM_TARGETS = new PonderTag("arm_targets").item((IItemProvider)AllBlocks.MECHANICAL_ARM.get()).defaultLang("Targets for Mechanical Arms", "Components which can be selected as inputs or outputs to the Mechanical Arm");
    private final String id;
    private ResourceLocation icon;
    private ItemStack itemIcon = ItemStack.field_190927_a;
    private ItemStack mainItem = ItemStack.field_190927_a;

    public String getTitle() {
        return PonderLocalization.getTag(this.id);
    }

    public String getDescription() {
        return PonderLocalization.getTagDescription(this.id);
    }

    public PonderTag(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public PonderTag defaultLang(String title, String description) {
        PonderLocalization.registerTag(this.id, title, description);
        return this;
    }

    public ItemStack getMainItem() {
        return this.mainItem;
    }

    public PonderTag idAsIcon() {
        return this.icon(this.id);
    }

    public PonderTag icon(String location) {
        this.icon = new ResourceLocation("create", "textures/ponder/tag/" + location + ".png");
        return this;
    }

    public PonderTag item(IItemProvider item) {
        return this.item(item, true, true);
    }

    public PonderTag item(IItemProvider item, boolean useAsIcon, boolean useAsMainItem) {
        if (useAsIcon) {
            this.itemIcon = new ItemStack(item);
        }
        if (useAsMainItem) {
            this.mainItem = new ItemStack(item);
        }
        return this;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(AbstractGui screen, int x, int y) {
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)x, (double)y, (double)0.0);
        if (this.icon != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.icon);
            RenderSystem.scaled((double)0.25, (double)0.25, (double)1.0);
            AbstractGui.blit((int)0, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)64, (int)64, (int)64, (int)64);
        } else if (!this.itemIcon.func_190926_b()) {
            RenderSystem.translated((double)-4.0, (double)-4.0, (double)0.0);
            RenderSystem.scaled((double)1.5, (double)1.5, (double)1.5);
            GuiGameElement.of(this.itemIcon).render();
        }
        RenderSystem.popMatrix();
    }

    public static void register() {
    }

    public static class Highlight {
        public static final PonderTag ALL = new PonderTag("_all");
    }
}

