/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.UIRenderHelper;
import com.simibubi.create.foundation.ponder.NavigatableSimiScreen;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.ponder.content.PonderChapter;
import com.simibubi.create.foundation.ponder.content.PonderTag;
import com.simibubi.create.foundation.ponder.ui.ChapterLabel;
import com.simibubi.create.foundation.ponder.ui.LayoutHelper;
import com.simibubi.create.foundation.ponder.ui.PonderButton;
import com.simibubi.create.foundation.utility.FontHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.client.MainWindow;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class PonderTagScreen
extends NavigatableSimiScreen {
    public static final String ASSOCIATED = "ponder.associated";
    private final PonderTag tag;
    protected final List<Item> items;
    private final double itemXmult = 0.5;
    protected Rectangle2d itemArea;
    protected final List<PonderChapter> chapters;
    private final double chapterXmult = 0.5;
    private final double chapterYmult = 0.75;
    protected Rectangle2d chapterArea;
    private final double mainYmult = 0.15;
    private ItemStack hoveredItem = ItemStack.field_190927_a;

    public PonderTagScreen(PonderTag tag) {
        this.tag = tag;
        this.items = new ArrayList<Item>();
        this.chapters = new ArrayList<PonderChapter>();
    }

    @Override
    protected void init() {
        this.widgets.clear();
        super.init();
        this.items.clear();
        PonderRegistry.tags.getItems(this.tag).stream().filter(rl -> this.tag.getMainItem().func_190926_b() || !this.tag.getMainItem().func_77973_b().getRegistryName().equals(rl)).map(key -> {
            Block b;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(key);
            if (item == null && (b = (Block)ForgeRegistries.BLOCKS.getValue(key)) != null) {
                item = b.func_199767_j();
            }
            return item;
        }).filter(Objects::nonNull).forEach(this.items::add);
        int rowCount = MathHelper.func_76125_a((int)((int)Math.ceil((double)this.items.size() / 11.0)), (int)1, (int)3);
        LayoutHelper layout = LayoutHelper.centeredHorizontal(this.items.size(), rowCount, 28, 28, 8);
        this.itemArea = layout.getArea();
        int itemCenterX = (int)((double)this.width * 0.5);
        int itemCenterY = this.getItemsY();
        for (Item i : this.items) {
            boolean canClick = PonderRegistry.all.containsKey(i.getRegistryName());
            PonderButton button = new PonderButton(itemCenterX + layout.getX() + 4, itemCenterY + layout.getY() + 4, (mouseX, mouseY) -> {
                if (!canClick) {
                    return;
                }
                this.centerScalingOn((int)mouseX, (int)mouseY);
                ScreenOpener.transitionTo(PonderUI.of(new ItemStack((IItemProvider)i), this.tag));
            }).showing(new ItemStack((IItemProvider)i));
            if (!canClick) {
                if (i.getRegistryName().func_110624_b().equals("create")) {
                    button.customColors(1889027328, 1885938688);
                } else {
                    button.customColors(0x505000FF, 1345323127);
                }
            }
            button.fade(1.0f);
            this.widgets.add(button);
            layout.next();
        }
        if (!this.tag.getMainItem().func_190926_b()) {
            ResourceLocation registryName = this.tag.getMainItem().func_77973_b().getRegistryName();
            boolean canClick = PonderRegistry.all.containsKey(registryName);
            PonderButton button = new PonderButton(itemCenterX - layout.getTotalWidth() / 2 - 42, itemCenterY - 10, (mouseX, mouseY) -> {
                if (!canClick) {
                    return;
                }
                this.centerScalingOn((int)mouseX, (int)mouseY);
                ScreenOpener.transitionTo(PonderUI.of(this.tag.getMainItem(), this.tag));
            }).showing(this.tag.getMainItem());
            if (!canClick) {
                if (registryName.func_110624_b().equals("create")) {
                    button.customColors(1889027328, 1885938688);
                } else {
                    button.customColors(0x505000FF, 1345323127);
                }
            }
            button.fade(1.0f);
            this.widgets.add(button);
        }
        this.chapters.clear();
        this.chapters.addAll(PonderRegistry.tags.getChapters(this.tag));
        rowCount = MathHelper.func_76125_a((int)((int)Math.ceil((float)this.chapters.size() / 3.0f)), (int)1, (int)3);
        layout = LayoutHelper.centeredHorizontal(this.chapters.size(), rowCount, 200, 38, 16);
        this.chapterArea = layout.getArea();
        int chapterCenterX = (int)((double)this.width * 0.5);
        int chapterCenterY = (int)((double)this.height * 0.75);
        for (PonderChapter chapter : this.chapters) {
            ChapterLabel label = new ChapterLabel(chapter, chapterCenterX + layout.getX(), chapterCenterY + layout.getY(), (mouseX, mouseY) -> {
                this.centerScalingOn((int)mouseX, (int)mouseY);
                ScreenOpener.transitionTo(PonderUI.of(chapter));
            });
            this.widgets.add(label);
            layout.next();
        }
    }

    @Override
    public void tick() {
        super.tick();
        ++PonderUI.ponderTicks;
        this.hoveredItem = ItemStack.field_190927_a;
        MainWindow w = this.minecraft.func_228018_at_();
        double mouseX = this.minecraft.field_71417_B.func_198024_e() * (double)w.func_198107_o() / (double)w.func_198105_m();
        double mouseY = this.minecraft.field_71417_B.func_198026_f() * (double)w.func_198087_p() / (double)w.func_198083_n();
        for (Widget widget : this.widgets) {
            if (widget == this.backTrack || !(widget instanceof PonderButton) || !widget.isMouseOver(mouseX, mouseY)) continue;
            this.hoveredItem = ((PonderButton)widget).getItem();
        }
    }

    @Override
    protected void renderWindow(int mouseX, int mouseY, float partialTicks) {
        this.renderItems(mouseX, mouseY, partialTicks);
        this.renderChapters(mouseX, mouseY, partialTicks);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)(this.width / 2 - 120), (double)((double)this.height * 0.15 - 40.0), (double)0.0);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)0.0, (double)0.0, (double)800.0);
        int x = 59;
        int y = 31;
        String title = this.tag.getTitle();
        int streakHeight = 35;
        UIRenderHelper.streak(0.0f, x - 4, y - 12 + streakHeight / 2, streakHeight, 240, 0x101010);
        PonderUI.renderBox(21, 21, 30, 30, false);
        this.drawString(this.font, Lang.translate("ponder.pondering", new Object[0]), x, y - 6, -6052957);
        RenderSystem.translated((double)(x += 0), (double)(y += 8), (double)0.0);
        RenderSystem.translated((double)0.0, (double)0.0, (double)5.0);
        this.font.func_211126_b(title, 0.0f, 0.0f, 0xEEEEEE);
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)23.0, (double)23.0, (double)0.0);
        RenderSystem.scaled((double)1.66, (double)1.66, (double)1.66);
        this.tag.draw((AbstractGui)this, 0, 0);
        RenderSystem.popMatrix();
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        int w = (int)((double)this.width * 0.45);
        x = (this.width - w) / 2;
        y = this.getItemsY() - 10 + Math.max(this.itemArea.func_199317_d(), 48);
        String desc = this.tag.getDescription();
        int h = this.font.func_78267_b(desc, w);
        PonderUI.renderBox(x - 3, y - 3, w + 6, h + 6, false);
        RenderSystem.translated((double)0.0, (double)0.0, (double)100.0);
        FontHelper.drawSplitString(this.font, desc, x, y, w, 0xEEEEEE);
        RenderSystem.popMatrix();
    }

    protected void renderItems(int mouseX, int mouseY, float partialTicks) {
        if (this.items.isEmpty()) {
            return;
        }
        int x = (int)((double)this.width * 0.5);
        int y = this.getItemsY();
        String relatedTitle = Lang.translate(ASSOCIATED, new Object[0]);
        int stringWidth = this.font.func_78256_a(relatedTitle);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)x, (double)y, (double)0.0);
        PonderUI.renderBox((this.sWidth - stringWidth) / 2 - 5, this.itemArea.func_199319_b() - 21, stringWidth + 10, 10, false);
        RenderSystem.translated((double)0.0, (double)0.0, (double)200.0);
        this.drawCenteredString(this.font, relatedTitle, this.sWidth / 2, this.itemArea.func_199319_b() - 20, 0xEEEEEE);
        UIRenderHelper.streak(0.0f, 0, 0, this.itemArea.func_199317_d() + 10, this.itemArea.func_199316_c() / 2 + 75, 0x101010);
        UIRenderHelper.streak(180.0f, 0, 0, this.itemArea.func_199317_d() + 10, this.itemArea.func_199316_c() / 2 + 75, 0x101010);
        RenderSystem.popMatrix();
    }

    public int getItemsY() {
        return (int)(0.15 * (double)this.height + 85.0);
    }

    protected void renderChapters(int mouseX, int mouseY, float partialTicks) {
        if (this.chapters.isEmpty()) {
            return;
        }
        int chapterX = (int)((double)this.width * 0.5);
        int chapterY = (int)((double)this.height * 0.75);
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)chapterX, (double)chapterY, (double)0.0);
        UIRenderHelper.streak(0.0f, this.chapterArea.func_199318_a() - 10, this.chapterArea.func_199319_b() - 20, 20, 220, 0x101010);
        this.drawString(this.font, "More Topics to Ponder about", this.chapterArea.func_199318_a() - 5, this.chapterArea.func_199319_b() - 25, -2232577);
        RenderSystem.popMatrix();
    }

    @Override
    protected void renderWindowForeground(int mouseX, int mouseY, float partialTicks) {
        RenderSystem.pushMatrix();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableDepthTest();
        RenderSystem.translated((double)0.0, (double)0.0, (double)200.0);
        if (!this.hoveredItem.func_190926_b()) {
            this.renderTooltip(this.hoveredItem, mouseX, mouseY);
        }
        RenderSystem.enableDepthTest();
        RenderSystem.enableRescaleNormal();
        RenderSystem.popMatrix();
    }

    @Override
    protected String getBreadcrumbTitle() {
        return this.tag.getTitle();
    }

    public ItemStack getHoveredTooltipItem() {
        return this.hoveredItem;
    }

    @Override
    public boolean mouseClicked(double x, double y, int button) {
        MutableBoolean handled = new MutableBoolean(false);
        this.widgets.forEach(w -> {
            if (handled.booleanValue()) {
                return;
            }
            if (!w.isMouseOver(x, y)) {
                return;
            }
            if (w instanceof PonderButton) {
                PonderButton mtdButton = (PonderButton)((Object)w);
                mtdButton.runCallback(x, y);
                handled.setTrue();
                return;
            }
        });
        if (handled.booleanValue()) {
            return true;
        }
        return super.mouseClicked(x, y, button);
    }

    @Override
    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        if (other instanceof PonderTagScreen) {
            return this.tag == ((PonderTagScreen)other).tag;
        }
        return super.isEquivalentTo(other);
    }

    @Override
    public boolean isPauseScreen() {
        return true;
    }

    public PonderTag getTag() {
        return this.tag;
    }

    public void removed() {
        super.removed();
        this.hoveredItem = ItemStack.field_190927_a;
    }
}

