/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.ponder.content.PonderPalette;
import com.simibubi.create.foundation.ponder.elements.AnimatedOverlayElement;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;

public class InputWindowElement
extends AnimatedOverlayElement {
    private Pointing direction;
    String key;
    AllIcons icon;
    ItemStack item = ItemStack.field_190927_a;
    private Vec3d sceneSpace;

    public InputWindowElement clone() {
        InputWindowElement inputWindowElement = new InputWindowElement(this.sceneSpace, this.direction);
        inputWindowElement.key = this.key;
        inputWindowElement.icon = this.icon;
        inputWindowElement.item = this.item.func_77946_l();
        return inputWindowElement;
    }

    public InputWindowElement(Vec3d sceneSpace, Pointing direction) {
        this.sceneSpace = sceneSpace;
        this.direction = direction;
    }

    public InputWindowElement withItem(ItemStack stack) {
        this.item = stack;
        return this;
    }

    public InputWindowElement withWrench() {
        this.item = AllItems.WRENCH.asStack();
        return this;
    }

    public InputWindowElement scroll() {
        this.icon = AllIcons.I_SCROLL;
        return this;
    }

    public InputWindowElement rightClick() {
        this.icon = AllIcons.I_RMB;
        return this;
    }

    public InputWindowElement showing(AllIcons icon) {
        this.icon = icon;
        return this;
    }

    public InputWindowElement leftClick() {
        this.icon = AllIcons.I_LMB;
        return this;
    }

    public InputWindowElement whileSneaking() {
        this.key = "sneak_and";
        return this;
    }

    public InputWindowElement whileCTRL() {
        this.key = "ctrl_and";
        return this;
    }

    @Override
    protected void render(PonderScene scene, PonderUI screen, MatrixStack ms, float partialTicks, float fade) {
        String text;
        float xFade;
        FontRenderer font = screen.getFontRenderer();
        int width = 0;
        int height = 0;
        float f = this.direction == Pointing.RIGHT ? -1.0f : (xFade = this.direction == Pointing.LEFT ? 1.0f : 0.0f);
        float yFade = this.direction == Pointing.DOWN ? -1.0f : (this.direction == Pointing.UP ? 1.0f : 0.0f);
        xFade *= 10.0f * (1.0f - fade);
        yFade *= 10.0f * (1.0f - fade);
        boolean hasItem = !this.item.func_190926_b();
        boolean hasText = this.key != null;
        boolean hasIcon = this.icon != null;
        int keyWidth = 0;
        String string = text = hasText ? PonderLocalization.getShared(this.key) : "";
        if (fade < 0.0625f) {
            return;
        }
        Vec2f sceneToScreen = scene.getTransform().sceneToScreen(this.sceneSpace, partialTicks);
        if (hasIcon) {
            width += 24;
            height = 24;
        }
        if (hasText) {
            keyWidth = font.func_78256_a(text);
            width += keyWidth;
        }
        if (hasItem) {
            width += 24;
            height = 24;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)(sceneToScreen.field_189982_i + xFade), (double)(sceneToScreen.field_189983_j + yFade), (double)400.0);
        PonderUI.renderSpeechBox(0, 0, width, height, false, this.direction, true);
        if (hasText) {
            font.getClass();
            font.func_211126_b(text, 2.0f, (float)((height - 9) / 2 + 2), ColorHelper.applyAlpha(PonderPalette.WHITE.getColor(), fade));
        }
        if (hasIcon) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)keyWidth, (double)0.0, (double)0.0);
            RenderSystem.scaled((double)1.5, (double)1.5, (double)1.5);
            this.icon.draw(0, 0);
            RenderSystem.popMatrix();
        }
        if (hasItem) {
            GuiGameElement.of(this.item).at(keyWidth + (hasIcon ? 24 : 0), 0.0).scale(1.5).render();
            RenderSystem.disableDepthTest();
        }
        RenderSystem.popMatrix();
    }
}

