/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.ponder.content.PonderPalette;
import com.simibubi.create.foundation.ponder.elements.AnimatedOverlayElement;
import com.simibubi.create.foundation.utility.ColorHelper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class TextWindowElement
extends AnimatedOverlayElement {
    Supplier<String> textGetter = () -> "(?) No text was provided";
    String bakedText;
    int y;
    Vec3d vec;
    boolean nearScene = false;
    int color = PonderPalette.WHITE.getColor();

    @Override
    protected void render(PonderScene scene, PonderUI screen, MatrixStack ms, float partialTicks, float fade) {
        if (this.bakedText == null) {
            this.bakedText = this.textGetter.get();
        }
        if (fade < 0.0625f) {
            return;
        }
        Vec2f sceneToScreen = this.vec != null ? scene.getTransform().sceneToScreen(this.vec, partialTicks) : new Vec2f((float)(screen.width / 2), (float)((screen.height - 200) / 2 + this.y - 8));
        float yDiff = ((float)(screen.height / 2) - sceneToScreen.field_189983_j - 10.0f) / 100.0f;
        int targetX = (int)((float)screen.width * MathHelper.func_219799_g((float)(yDiff * yDiff), (float)0.75f, (float)0.625f));
        if (this.nearScene) {
            targetX = (int)Math.min((float)targetX, sceneToScreen.field_189982_i + 50.0f);
        }
        int textWidth = Math.min(screen.width - targetX, 180);
        List list = screen.getFontRenderer().func_78271_c(this.bakedText, textWidth);
        int boxWidth = 0;
        for (String string : list) {
            boxWidth = Math.max(boxWidth, screen.getFontRenderer().func_78256_a(string));
        }
        int boxHeight = screen.getFontRenderer().func_78267_b(this.bakedText, boxWidth);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)sceneToScreen.field_189983_j, (float)400.0f);
        PonderUI.renderBox(targetX - 10, 3, boxWidth, boxHeight - 1, -1442840576, 820951808, 284080896);
        int brighterColor = ColorHelper.mixAlphaColors(this.color, -35, 0.5f);
        if (this.vec != null) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)sceneToScreen.field_189982_i, (float)0.0f, (float)0.0f);
            double lineTarget = ((float)targetX - sceneToScreen.field_189982_i) * fade;
            RenderSystem.scaled((double)lineTarget, (double)1.0, (double)1.0);
            GuiUtils.drawGradientRect((int)-100, (int)0, (int)0, (int)1, (int)1, (int)brighterColor, (int)brighterColor);
            GuiUtils.drawGradientRect((int)-100, (int)0, (int)1, (int)1, (int)2, (int)-11974327, (int)-13027015);
            RenderSystem.popMatrix();
        }
        for (int i = 0; i < list.size(); ++i) {
            String s = (String)list.get(i);
            screen.getFontRenderer().func_211126_b(s, (float)(targetX - 10), (float)(3 + 9 * i), ColorHelper.applyAlpha(brighterColor, fade));
        }
        RenderSystem.popMatrix();
    }

    public int getColor() {
        return this.color;
    }

    public class Builder {
        private PonderScene scene;

        public Builder(PonderScene scene) {
            this.scene = scene;
        }

        public Builder colored(PonderPalette color) {
            TextWindowElement.this.color = color.getColor();
            return this;
        }

        public Builder pointAt(Vec3d vec) {
            TextWindowElement.this.vec = vec;
            return this;
        }

        public Builder independent(int y) {
            TextWindowElement.this.y = y;
            return this;
        }

        public Builder independent() {
            return this.independent(0);
        }

        public Builder text(String defaultText) {
            TextWindowElement.this.textGetter = this.scene.registerText(defaultText);
            return this;
        }

        public Builder sharedText(String key) {
            TextWindowElement.this.textGetter = () -> PonderLocalization.getShared(key);
            return this;
        }

        public Builder placeNearTarget() {
            TextWindowElement.this.nearScene = true;
            return this;
        }

        public Builder attachKeyFrame() {
            this.scene.builder().addLazyKeyframe();
            return this;
        }
    }
}

