/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.instructions;

import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.elements.PonderSceneElement;
import com.simibubi.create.foundation.ponder.instructions.TickingInstruction;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.util.math.Vec3d;

public class AnimateElementInstruction<T extends PonderSceneElement>
extends TickingInstruction {
    protected Vec3d deltaPerTick;
    protected Vec3d totalDelta;
    protected Vec3d target;
    protected ElementLink<T> link;
    protected T element;
    private BiConsumer<T, Vec3d> setter;
    private Function<T, Vec3d> getter;

    protected AnimateElementInstruction(ElementLink<T> link, Vec3d totalDelta, int ticks, BiConsumer<T, Vec3d> setter, Function<T, Vec3d> getter) {
        super(false, ticks);
        this.link = link;
        this.setter = setter;
        this.getter = getter;
        this.deltaPerTick = totalDelta.func_186678_a(1.0 / (double)ticks);
        this.totalDelta = totalDelta;
        this.target = totalDelta;
    }

    @Override
    protected final void firstTick(PonderScene scene) {
        super.firstTick(scene);
        this.element = (PonderSceneElement)scene.resolve(this.link);
        if (this.element == null) {
            return;
        }
        this.target = this.getter.apply(this.element).func_178787_e(this.totalDelta);
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (this.element == null) {
            return;
        }
        if (this.remainingTicks == 0) {
            this.setter.accept(this.element, this.target);
            this.setter.accept(this.element, this.target);
            return;
        }
        this.setter.accept(this.element, this.getter.apply(this.element).func_178787_e(this.deltaPerTick));
    }
}

