/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.instructions;

import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.instructions.WorldModifyInstruction;
import java.util.function.UnaryOperator;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class ReplaceBlocksInstruction
extends WorldModifyInstruction {
    private UnaryOperator<BlockState> stateToUse;
    private boolean replaceAir;
    private boolean spawnParticles;

    public ReplaceBlocksInstruction(Selection selection, UnaryOperator<BlockState> stateToUse, boolean replaceAir, boolean spawnParticles) {
        super(selection);
        this.stateToUse = stateToUse;
        this.replaceAir = replaceAir;
        this.spawnParticles = spawnParticles;
    }

    @Override
    protected void runModification(Selection selection, PonderScene scene) {
        PonderWorld world = scene.getWorld();
        selection.forEach(pos -> {
            if (!world.getBounds().func_175898_b((Vec3i)pos)) {
                return;
            }
            BlockState prevState = world.func_180495_p((BlockPos)pos);
            if (!this.replaceAir && prevState == Blocks.field_150350_a.func_176223_P()) {
                return;
            }
            if (this.spawnParticles) {
                world.addBlockDestroyEffects((BlockPos)pos, prevState);
            }
            world.func_175656_a((BlockPos)pos, (BlockState)this.stateToUse.apply(prevState));
        });
    }

    @Override
    protected boolean needsRedraw() {
        return true;
    }
}

