/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.instructions;

import com.simibubi.create.foundation.ponder.PonderScene;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.instructions.WorldModifyInstruction;
import com.simibubi.create.foundation.tileEntity.SyncedTileEntity;
import java.util.function.UnaryOperator;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class TileEntityDataInstruction
extends WorldModifyInstruction {
    private boolean redraw;
    private UnaryOperator<CompoundNBT> data;
    private Class<? extends TileEntity> type;

    public TileEntityDataInstruction(Selection selection, Class<? extends TileEntity> type, UnaryOperator<CompoundNBT> data, boolean redraw) {
        super(selection);
        this.type = type;
        this.data = data;
        this.redraw = redraw;
    }

    @Override
    protected void runModification(Selection selection, PonderScene scene) {
        PonderWorld world = scene.getWorld();
        selection.forEach(pos -> {
            if (!world.getBounds().func_175898_b((Vec3i)pos)) {
                return;
            }
            TileEntity tileEntity = world.func_175625_s((BlockPos)pos);
            if (!this.type.isInstance(tileEntity)) {
                return;
            }
            CompoundNBT apply = (CompoundNBT)this.data.apply(tileEntity.func_189515_b(new CompoundNBT()));
            if (tileEntity instanceof SyncedTileEntity) {
                ((SyncedTileEntity)tileEntity).readClientUpdate(apply);
            }
            tileEntity.func_145839_a(apply);
        });
    }

    @Override
    protected boolean needsRedraw() {
        return this.redraw;
    }
}

