/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.gui.GuiGameElement;
import com.simibubi.create.foundation.gui.IScreenRenderable;
import com.simibubi.create.foundation.gui.widgets.AbstractSimiWidget;
import com.simibubi.create.foundation.ponder.PonderUI;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;

public class PonderButton
extends AbstractSimiWidget {
    private IScreenRenderable icon;
    private ItemStack item;
    protected boolean pressed;
    private BiConsumer<Integer, Integer> onClick;
    private int xFadeModifier;
    private int yFadeModifier;
    private float fade;
    private KeyBinding shortcut;
    private LerpedFloat flash;
    private Couple<Integer> customPassiveBorder;
    public static final int SIZE = 20;

    public PonderButton(int x, int y, BiConsumer<Integer, Integer> onClick, int width, int height) {
        super(x, y, width, height);
        this.onClick = onClick;
        this.flash = LerpedFloat.linear().startWithValue(0.0);
    }

    public PonderButton(int x, int y, BiConsumer<Integer, Integer> onClick) {
        this(x, y, onClick, 20, 20);
    }

    public PonderButton(int x, int y, Runnable onClick) {
        this(x, y, (Integer $, Integer $$) -> onClick.run());
    }

    public PonderButton showing(IScreenRenderable icon) {
        this.icon = icon;
        return this;
    }

    public PonderButton showing(ItemStack item) {
        this.item = item;
        return this;
    }

    public PonderButton customColors(int start, int end) {
        this.customPassiveBorder = Couple.create(start, end);
        return this;
    }

    public PonderButton shortcut(KeyBinding key) {
        this.shortcut = key;
        return this;
    }

    public PonderButton fade(int xModifier, int yModifier) {
        this.xFadeModifier = xModifier;
        this.yFadeModifier = yModifier;
        return this;
    }

    public void fade(float fade) {
        this.fade = fade;
    }

    public void flash() {
        float value = this.flash.getValue();
        this.flash.setValue(value + (1.0f - value) * 0.2f);
    }

    public void dim() {
        float value = this.flash.getValue();
        this.flash.setValue(value * 0.5f);
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        int borderColorStart;
        float flashValue;
        if (!this.visible) {
            return;
        }
        if (this.fade < 0.1f) {
            return;
        }
        this.isHovered = this.isMouseOver(mouseX, mouseY) && this.fade > 0.75f;
        RenderSystem.pushMatrix();
        RenderSystem.disableDepthTest();
        if (this.fade < 1.0f) {
            RenderSystem.translated((double)((1.0f - this.fade) * -5.0f * (float)this.xFadeModifier), (double)((1.0f - this.fade) * -5.0f * (float)this.yFadeModifier), (double)0.0);
        }
        if ((flashValue = this.flash.getValue(partialTicks)) > 0.1f) {
            this.fade = (float)((double)this.fade * ((double)(3.0f * flashValue) + Math.sin(((float)PonderUI.ponderTicks + partialTicks) / 6.0f)));
        }
        int backgroundColor = ColorHelper.applyAlpha(-587202560, this.fade);
        int n = this.customPassiveBorder != null ? (Integer)this.customPassiveBorder.getFirst() : (borderColorStart = this.isHovered ? 0x70FFFFFF : 1084922265);
        int borderColorEnd = this.customPassiveBorder != null ? (Integer)this.customPassiveBorder.getSecond() : (this.isHovered ? 0x30FFFFFF : 548051353);
        borderColorStart = ColorHelper.applyAlpha(borderColorStart, this.fade);
        borderColorEnd = ColorHelper.applyAlpha(borderColorEnd, this.fade);
        PonderUI.renderBox(this.x, this.y, this.width, this.height, backgroundColor, borderColorStart, borderColorEnd);
        RenderSystem.translated((double)0.0, (double)0.0, (double)800.0);
        if (this.icon != null) {
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.fade);
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)(this.x + 2), (double)(this.y + 2), (double)0.0);
            RenderSystem.scaled((double)((double)(this.width - 4) / 16.0), (double)((double)(this.height - 4) / 16.0), (double)1.0);
            this.icon.draw((AbstractGui)this, 0, 0);
            RenderSystem.popMatrix();
        }
        if (this.item != null) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)0.0, (double)0.0, (double)-800.0);
            GuiGameElement.of(this.item).at(this.x - 2, this.y - 2).scale(1.5).render();
            RenderSystem.popMatrix();
        }
        if (this.shortcut != null) {
            this.drawCenteredString(Minecraft.func_71410_x().field_71466_p, this.shortcut.func_197978_k(), this.x + this.width / 2 + 8, this.y + this.height - 6, ColorHelper.applyAlpha(-10461088, this.fade));
        }
        RenderSystem.popMatrix();
    }

    public void runCallback(double mouseX, double mouseY) {
        this.onClick.accept((int)mouseX, (int)mouseY);
    }

    public void onClick(double p_onClick_1_, double p_onClick_3_) {
        super.onClick(p_onClick_1_, p_onClick_3_);
        this.pressed = true;
    }

    public void onRelease(double p_onRelease_1_, double p_onRelease_3_) {
        super.onRelease(p_onRelease_1_, p_onRelease_3_);
        this.pressed = false;
    }

    public void setToolTip(String text) {
        this.toolTip.clear();
        this.toolTip.add(text);
    }

    public ItemStack getItem() {
        return this.item;
    }

    public boolean isMouseOver(double x, double y) {
        double m = 4.0;
        x = Math.floor(x);
        y = Math.floor(y);
        return !(!this.active || !this.visible || x < (double)this.x - m || x > (double)(this.x + this.width) + m - 1.0 || y < (double)this.y - m || y > (double)(this.y + this.height) + m - 1.0);
    }
}

