/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderDispatcher;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.render.TemplateBuffer;
import com.simibubi.create.foundation.utility.MatrixStacker;
import it.unimi.dsi.fastutil.longs.Long2DoubleMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class SuperByteBuffer
extends TemplateBuffer {
    private MatrixStack transforms;
    private SpriteShiftFunc spriteShiftFunc;
    private boolean shouldLight;
    private int packedLightCoords;
    private int otherBlockLight;
    private Matrix4f lightTransform;
    private boolean shouldColor;
    private int r;
    private int g;
    private int b;
    private int a;
    private static final Long2DoubleMap skyLightCache = new Long2DoubleOpenHashMap();
    private static final Long2DoubleMap blockLightCache = new Long2DoubleOpenHashMap();
    Vector4f pos = new Vector4f();
    Vector3f normal = new Vector3f();
    Vector4f lightPos = new Vector4f();

    public SuperByteBuffer(BufferBuilder buf) {
        super(buf);
        this.transforms = new MatrixStack();
    }

    public static float getUnInterpolatedU(TextureAtlasSprite sprite, float u) {
        float f = sprite.func_94212_f() - sprite.func_94209_e();
        return (u - sprite.func_94209_e()) / f * 16.0f;
    }

    public static float getUnInterpolatedV(TextureAtlasSprite sprite, float v) {
        float f = sprite.func_94210_h() - sprite.func_94206_g();
        return (v - sprite.func_94206_g()) / f * 16.0f;
    }

    public void renderInto(MatrixStack input, IVertexBuilder builder) {
        ByteBuffer buffer = this.template;
        if (buffer.limit() == 0) {
            return;
        }
        ((Buffer)buffer).rewind();
        Matrix3f normalMat = this.transforms.func_227866_c_().func_227872_b_().func_226121_d_();
        Matrix4f modelMat = input.func_227866_c_().func_227870_a_().func_226601_d_();
        Matrix4f localTransforms = this.transforms.func_227866_c_().func_227870_a_();
        modelMat.func_226595_a_(localTransforms);
        if (this.shouldLight && this.lightTransform != null) {
            skyLightCache.clear();
            blockLightCache.clear();
        }
        float f = 0.5f;
        int vertexCount = this.vertexCount(buffer);
        for (int i = 0; i < vertexCount; ++i) {
            float x = this.getX(buffer, i);
            float y = this.getY(buffer, i);
            float z = this.getZ(buffer, i);
            byte r = this.getR(buffer, i);
            byte g = this.getG(buffer, i);
            byte b = this.getB(buffer, i);
            byte a = this.getA(buffer, i);
            float normalX = (float)this.getNX(buffer, i) / 127.0f;
            float normalY = (float)this.getNY(buffer, i) / 127.0f;
            float normalZ = (float)this.getNZ(buffer, i) / 127.0f;
            float staticDiffuse = LightUtil.diffuseLight((float)normalX, (float)normalY, (float)normalZ);
            this.normal.func_195905_a(normalX, normalY, normalZ);
            this.normal.func_229188_a_(normalMat);
            float nx = this.normal.func_195899_a();
            float ny = this.normal.func_195900_b();
            float nz = this.normal.func_195902_c();
            float instanceDiffuse = LightUtil.diffuseLight((float)nx, (float)ny, (float)nz);
            this.pos.func_195911_a(x, y, z, 1.0f);
            this.pos.func_229372_a_(modelMat);
            builder.func_225582_a_((double)this.pos.func_195910_a(), (double)this.pos.func_195913_b(), (double)this.pos.func_195914_c());
            if (this.shouldColor) {
                int colorR = Math.min(255, (int)((float)this.r * instanceDiffuse));
                int colorG = Math.min(255, (int)((float)this.g * instanceDiffuse));
                int colorB = Math.min(255, (int)((float)this.b * instanceDiffuse));
                builder.func_225586_a_(colorR, colorG, colorB, this.a);
            } else {
                float diffuseMult = instanceDiffuse / staticDiffuse;
                int colorR = Math.min(255, (int)((float)Byte.toUnsignedInt(r) * diffuseMult));
                int colorG = Math.min(255, (int)((float)Byte.toUnsignedInt(g) * diffuseMult));
                int colorB = Math.min(255, (int)((float)Byte.toUnsignedInt(b) * diffuseMult));
                builder.func_225586_a_(colorR, colorG, colorB, (int)a);
            }
            float u = this.getU(buffer, i);
            float v = this.getV(buffer, i);
            if (this.spriteShiftFunc != null) {
                this.spriteShiftFunc.shift(builder, u, v);
            } else {
                builder.func_225583_a_(u, v);
            }
            if (this.shouldLight) {
                int light = this.packedLightCoords;
                if (this.lightTransform != null) {
                    this.lightPos.func_195911_a((x - f) * 15.0f / 16.0f + f, (y - f) * 15.0f / 16.0f + f, (z - f) * 15.0f / 16.0f + f, 1.0f);
                    this.lightPos.func_229372_a_(localTransforms);
                    this.lightPos.func_229372_a_(this.lightTransform);
                    light = SuperByteBuffer.getLight((World)Minecraft.func_71410_x().field_71441_e, this.lightPos);
                    if (this.otherBlockLight >= 0) {
                        light = ContraptionRenderDispatcher.getMaxBlockLight(light, this.otherBlockLight);
                    }
                }
                builder.func_227886_a_(light);
            } else {
                builder.func_227886_a_(this.getLight(buffer, i));
            }
            builder.func_225584_a_(nx, ny, nz).func_181675_d();
        }
        this.transforms = new MatrixStack();
        this.spriteShiftFunc = null;
        this.shouldColor = false;
        this.shouldLight = false;
        this.otherBlockLight = -1;
    }

    public MatrixStacker matrixStacker() {
        return MatrixStacker.of(this.transforms);
    }

    public SuperByteBuffer translate(Vec3d vec) {
        return this.translate(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public SuperByteBuffer translate(double x, double y, double z) {
        return this.translate((float)x, (float)y, (float)z);
    }

    public SuperByteBuffer translate(float x, float y, float z) {
        this.transforms.func_227861_a_((double)x, (double)y, (double)z);
        return this;
    }

    public SuperByteBuffer transform(MatrixStack stack) {
        this.transforms.func_227866_c_().func_227870_a_().func_226595_a_(stack.func_227866_c_().func_227870_a_());
        this.transforms.func_227866_c_().func_227872_b_().func_226118_b_(stack.func_227866_c_().func_227872_b_());
        return this;
    }

    public SuperByteBuffer rotate(Direction axis, float radians) {
        if (radians == 0.0f) {
            return this;
        }
        this.transforms.func_227863_a_(axis.func_229386_k_().func_229193_c_(radians));
        return this;
    }

    public SuperByteBuffer rotate(Quaternion q) {
        this.transforms.func_227863_a_(q);
        return this;
    }

    public SuperByteBuffer rotateCentered(Direction axis, float radians) {
        return this.translate(0.5f, 0.5f, 0.5f).rotate(axis, radians).translate(-0.5f, -0.5f, -0.5f);
    }

    public SuperByteBuffer rotateCentered(Quaternion q) {
        return this.translate(0.5f, 0.5f, 0.5f).rotate(q).translate(-0.5f, -0.5f, -0.5f);
    }

    public SuperByteBuffer shiftUV(SpriteShiftEntry entry) {
        this.spriteShiftFunc = (builder, u, v) -> {
            float targetU = entry.getTarget().func_94214_a((double)SuperByteBuffer.getUnInterpolatedU(entry.getOriginal(), u));
            float targetV = entry.getTarget().func_94207_b((double)SuperByteBuffer.getUnInterpolatedV(entry.getOriginal(), v));
            builder.func_225583_a_(targetU, targetV);
        };
        return this;
    }

    public SuperByteBuffer shiftUVScrolling(SpriteShiftEntry entry, float scrollV) {
        this.spriteShiftFunc = (builder, u, v) -> {
            float targetU = u - entry.getOriginal().func_94209_e() + entry.getTarget().func_94209_e();
            float targetV = v - entry.getOriginal().func_94206_g() + entry.getTarget().func_94206_g() + scrollV;
            builder.func_225583_a_(targetU, targetV);
        };
        return this;
    }

    public SuperByteBuffer shiftUVtoSheet(SpriteShiftEntry entry, float uTarget, float vTarget, int sheetSize) {
        this.spriteShiftFunc = (builder, u, v) -> {
            float targetU = entry.getTarget().func_94214_a((double)(SuperByteBuffer.getUnInterpolatedU(entry.getOriginal(), u) / (float)sheetSize + uTarget * 16.0f));
            float targetV = entry.getTarget().func_94207_b((double)(SuperByteBuffer.getUnInterpolatedV(entry.getOriginal(), v) / (float)sheetSize + vTarget * 16.0f));
            builder.func_225583_a_(targetU, targetV);
        };
        return this;
    }

    public SuperByteBuffer light(int packedLightCoords) {
        this.shouldLight = true;
        this.lightTransform = null;
        this.packedLightCoords = packedLightCoords;
        return this;
    }

    public SuperByteBuffer light(Matrix4f lightTransform) {
        this.shouldLight = true;
        this.lightTransform = lightTransform;
        return this;
    }

    public SuperByteBuffer light(Matrix4f lightTransform, int otherBlockLight) {
        this.shouldLight = true;
        this.lightTransform = lightTransform;
        this.otherBlockLight = otherBlockLight;
        return this;
    }

    public SuperByteBuffer color(int color) {
        this.shouldColor = true;
        this.r = color >> 16 & 0xFF;
        this.g = color >> 8 & 0xFF;
        this.b = color & 0xFF;
        this.a = 255;
        return this;
    }

    private static int getLight(World world, Vector4f lightPos) {
        BlockPos.Mutable pos = new BlockPos.Mutable();
        double sky = 0.0;
        double block = 0.0;
        pos.func_189532_c((double)(lightPos.func_195910_a() + 0.0f), (double)(lightPos.func_195913_b() + 0.0f), (double)(lightPos.func_195914_c() + 0.0f));
        return (int)(sky += skyLightCache.computeIfAbsent(pos.func_218275_a(), $ -> world.func_226658_a_(LightType.SKY, (BlockPos)pos))) << 20 | (int)(block += blockLightCache.computeIfAbsent(pos.func_218275_a(), $ -> world.func_226658_a_(LightType.BLOCK, (BlockPos)pos))) << 4;
    }

    @Override
    public boolean isEmpty() {
        return this.template.limit() == 0;
    }

    @FunctionalInterface
    public static interface SpriteShiftFunc {
        public void shift(IVertexBuilder var1, float var2, float var3);
    }

    public static interface IVertexLighter {
        public int getPackedLight(float var1, float var2, float var3);
    }
}

