/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.gl;

import com.google.common.collect.Lists;
import com.simibubi.create.foundation.render.backend.gl.shader.ProgramFogMode;
import java.util.Collections;
import java.util.List;

public enum GlFogMode {
    NONE(ProgramFogMode.None::new),
    LINEAR(ProgramFogMode.Linear::new, "USE_FOG_LINEAR"),
    EXP2(ProgramFogMode.Exp2::new, "USE_FOG_EXP2");

    public static final String USE_FOG = "USE_FOG";
    private final ProgramFogMode.Factory fogFactory;
    private final List<String> defines;

    private GlFogMode(ProgramFogMode.Factory fogFactory) {
        this.fogFactory = fogFactory;
        this.defines = Collections.emptyList();
    }

    private GlFogMode(ProgramFogMode.Factory fogFactory, String name) {
        this.fogFactory = fogFactory;
        this.defines = Lists.newArrayList((Object[])new String[]{USE_FOG, name});
    }

    public List<String> getDefines() {
        return this.defines;
    }

    public ProgramFogMode.Factory getFogFactory() {
        return this.fogFactory;
    }
}

