/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.gl.attrib;

import com.simibubi.create.foundation.render.backend.gl.attrib.IAttribSpec;
import com.simibubi.create.foundation.render.backend.gl.attrib.IVertexAttrib;
import java.util.ArrayList;
import java.util.Arrays;

public class VertexFormat {
    private final ArrayList<IVertexAttrib> allAttributes;
    private final int numAttributes;
    private final int stride;

    public VertexFormat(ArrayList<IVertexAttrib> allAttributes) {
        this.allAttributes = allAttributes;
        int numAttributes = 0;
        int stride = 0;
        for (IVertexAttrib attrib : allAttributes) {
            IAttribSpec spec = attrib.attribSpec();
            numAttributes += spec.getAttributeCount();
            stride += spec.getSize();
        }
        this.numAttributes = numAttributes;
        this.stride = stride;
    }

    public int getShaderAttributeCount() {
        return this.numAttributes;
    }

    public int getStride() {
        return this.stride;
    }

    public void vertexAttribPointers(int index) {
        int offset = 0;
        for (IVertexAttrib attrib : this.allAttributes) {
            IAttribSpec spec = attrib.attribSpec();
            spec.vertexAttribPointer(this.stride, index, offset);
            index += spec.getAttributeCount();
            offset += spec.getSize();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ArrayList<IVertexAttrib> allAttributes = new ArrayList();

        public <A extends Enum<A>> Builder addAttributes(Class<A> attribEnum) {
            this.allAttributes.addAll(Arrays.asList(attribEnum.getEnumConstants()));
            return this;
        }

        public VertexFormat build() {
            return new VertexFormat(this.allAttributes);
        }
    }
}

