/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.instancing;

import com.simibubi.create.foundation.render.backend.Backend;
import com.simibubi.create.foundation.render.backend.BufferedModel;
import com.simibubi.create.foundation.render.backend.core.ModelAttributes;
import com.simibubi.create.foundation.render.backend.gl.GlBuffer;
import com.simibubi.create.foundation.render.backend.gl.GlVertexArray;
import com.simibubi.create.foundation.render.backend.gl.attrib.VertexFormat;
import com.simibubi.create.foundation.render.backend.instancing.InstanceData;
import com.simibubi.create.foundation.render.backend.instancing.InstancedTileRenderer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import net.minecraft.client.renderer.BufferBuilder;
import org.lwjgl.opengl.GL15;

public abstract class InstancedModel<D extends InstanceData>
extends BufferedModel {
    public static final VertexFormat FORMAT = VertexFormat.builder().addAttributes(ModelAttributes.class).build();
    public final InstancedTileRenderer<?> renderer;
    protected GlVertexArray vao;
    protected GlBuffer instanceVBO;
    protected int glBufferSize = -1;
    protected int glInstanceCount = 0;
    protected final ArrayList<D> data = new ArrayList();
    boolean anyToRemove;
    boolean anyToUpdate;

    public InstancedModel(InstancedTileRenderer<?> renderer, BufferBuilder buf) {
        super(buf);
        this.renderer = renderer;
    }

    @Override
    protected void init() {
        this.vao = new GlVertexArray();
        this.instanceVBO = new GlBuffer(34962);
        this.vao.with(vao -> super.init());
    }

    @Override
    protected void initModel() {
        super.initModel();
        this.setupAttributes();
    }

    public int instanceCount() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.instanceCount() == 0;
    }

    @Override
    protected void deleteInternal() {
        super.deleteInternal();
        this.instanceVBO.delete();
        this.vao.delete();
    }

    public synchronized D createInstance() {
        D instanceData = this.newInstance();
        ((InstanceData)instanceData).dirty = true;
        this.anyToUpdate = true;
        this.data.add(instanceData);
        return instanceData;
    }

    protected abstract D newInstance();

    @Override
    protected void doRender() {
        this.vao.with(vao -> {
            this.renderSetup();
            if (this.glInstanceCount > 0) {
                Backend.compat.drawArraysInstanced(7, 0, this.vertexCount, this.glInstanceCount);
            }
        });
    }

    protected void renderSetup() {
        if (this.anyToRemove) {
            this.removeDeletedInstances();
        }
        this.instanceVBO.bind();
        if (!this.realloc()) {
            if (this.anyToRemove) {
                this.clearBufferTail();
            }
            if (this.anyToUpdate) {
                this.updateBuffer();
            }
        }
        this.glInstanceCount = this.data.size();
        this.informAttribDivisors();
        this.instanceVBO.unbind();
        this.anyToRemove = false;
        this.anyToUpdate = false;
    }

    private void informAttribDivisors() {
        int staticAttributes = this.getModelFormat().getShaderAttributeCount();
        this.getInstanceFormat().vertexAttribPointers(staticAttributes);
        for (int i = 0; i < this.getInstanceFormat().getShaderAttributeCount(); ++i) {
            Backend.compat.vertexAttribDivisor(i + staticAttributes, 1);
        }
    }

    private void clearBufferTail() {
        int size = this.data.size();
        int offset = size * this.getInstanceFormat().getStride();
        int length = this.glBufferSize - offset;
        if (length > 0) {
            this.instanceVBO.map(offset, length, buffer -> buffer.put(new byte[length]));
        }
    }

    private void updateBuffer() {
        int size = this.data.size();
        if (size <= 0) {
            return;
        }
        int stride = this.getInstanceFormat().getStride();
        BitSet dirtySet = this.getDirtyBitSet();
        if (dirtySet.isEmpty()) {
            return;
        }
        int firstDirty = dirtySet.nextSetBit(0);
        int lastDirty = dirtySet.previousSetBit(size);
        int offset = firstDirty * stride;
        int length = (1 + lastDirty - firstDirty) * stride;
        if (length > 0) {
            this.instanceVBO.map(offset, length, buffer -> dirtySet.stream().forEach(i -> {
                InstanceData d = (InstanceData)this.data.get(i);
                buffer.position(i * stride - offset);
                d.write((ByteBuffer)buffer);
            }));
        }
    }

    private BitSet getDirtyBitSet() {
        int size = this.data.size();
        BitSet dirtySet = new BitSet(size);
        for (int i = 0; i < size; ++i) {
            InstanceData element = (InstanceData)this.data.get(i);
            if (!element.dirty) continue;
            dirtySet.set(i);
            element.dirty = false;
        }
        return dirtySet;
    }

    private boolean realloc() {
        int stride;
        int size = this.data.size();
        int requiredSize = size * (stride = this.getInstanceFormat().getStride());
        if (requiredSize > this.glBufferSize) {
            this.glBufferSize = requiredSize + stride * 16;
            GL15.glBufferData((int)this.instanceVBO.getBufferType(), (long)this.glBufferSize, (int)35044);
            this.instanceVBO.map(this.glBufferSize, buffer -> {
                for (InstanceData datum : this.data) {
                    datum.write((ByteBuffer)buffer);
                }
            });
            this.glInstanceCount = size;
            return true;
        }
        return false;
    }

    private void removeDeletedInstances() {
        int oldSize = this.data.size();
        int removeCount = 0;
        BitSet removeSet = new BitSet(oldSize);
        for (int i = 0; i < oldSize; ++i) {
            InstanceData element = (InstanceData)this.data.get(i);
            if (!element.removed) continue;
            removeSet.set(i);
            ++removeCount;
        }
        int newSize = oldSize - removeCount;
        int i = 0;
        for (int j = 0; i < oldSize && j < newSize; ++i, ++j) {
            if ((i = removeSet.nextClearBit(i)) == j) continue;
            InstanceData element = (InstanceData)this.data.get(i);
            this.data.set(j, element);
            element.dirty = true;
        }
        this.anyToUpdate = true;
        this.data.subList(newSize, oldSize).clear();
    }

    @Override
    protected void copyVertex(ByteBuffer constant, int i) {
        constant.putFloat(this.getX(this.template, i));
        constant.putFloat(this.getY(this.template, i));
        constant.putFloat(this.getZ(this.template, i));
        constant.put(this.getNX(this.template, i));
        constant.put(this.getNY(this.template, i));
        constant.put(this.getNZ(this.template, i));
        constant.putFloat(this.getU(this.template, i));
        constant.putFloat(this.getV(this.template, i));
    }

    @Override
    protected VertexFormat getModelFormat() {
        return FORMAT;
    }

    protected abstract VertexFormat getInstanceFormat();

    @Override
    protected int getTotalShaderAttributeCount() {
        return this.getInstanceFormat().getShaderAttributeCount() + super.getTotalShaderAttributeCount();
    }
}

