/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.instancing;

import com.google.common.collect.Maps;
import com.simibubi.create.foundation.render.backend.instancing.IRendererFactory;
import com.simibubi.create.foundation.render.backend.instancing.InstancedTileRenderer;
import com.simibubi.create.foundation.render.backend.instancing.TileEntityInstance;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;

public class InstancedTileRenderRegistry {
    public static final InstancedTileRenderRegistry instance = new InstancedTileRenderRegistry();
    private final Map<TileEntityType<?>, IRendererFactory<?>> renderers = Maps.newHashMap();

    public <T extends TileEntity> void register(TileEntityType<? extends T> type, IRendererFactory<? super T> rendererFactory) {
        this.renderers.put(type, rendererFactory);
    }

    @Nullable
    public <T extends TileEntity> TileEntityInstance<? super T> create(InstancedTileRenderer<?> manager, T tile) {
        TileEntityType type = tile.func_200662_C();
        IRendererFactory<?> factory = this.renderers.get(type);
        if (factory == null) {
            return null;
        }
        return factory.create(manager, tile);
    }
}

