/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.render.backend.instancing;

import com.simibubi.create.foundation.render.backend.core.IFlatLight;
import com.simibubi.create.foundation.render.backend.core.ModelData;
import com.simibubi.create.foundation.render.backend.core.OrientedData;
import com.simibubi.create.foundation.render.backend.instancing.IInstance;
import com.simibubi.create.foundation.render.backend.instancing.InstancedModel;
import com.simibubi.create.foundation.render.backend.instancing.InstancedTileRenderer;
import com.simibubi.create.foundation.render.backend.instancing.RenderMaterial;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public abstract class TileEntityInstance<T extends TileEntity>
implements IInstance {
    protected final InstancedTileRenderer<?> renderer;
    protected final T tile;
    protected final World world;
    protected final BlockPos pos;
    protected final BlockPos instancePos;
    protected final BlockState blockState;

    public TileEntityInstance(InstancedTileRenderer<?> renderer, T tile) {
        this.renderer = renderer;
        this.tile = tile;
        this.world = tile.func_145831_w();
        this.pos = tile.func_174877_v();
        this.blockState = tile.func_195044_w();
        this.instancePos = this.pos.func_177973_b((Vec3i)renderer.getOriginCoordinate());
    }

    protected void update() {
    }

    public void updateLight() {
    }

    public abstract void remove();

    public boolean shouldReset() {
        return this.tile.func_195044_w() != this.blockState;
    }

    public BlockPos getInstancePosition() {
        return this.instancePos;
    }

    @Override
    public BlockPos getWorldPosition() {
        return this.pos;
    }

    protected void relight(BlockPos pos, IFlatLight<?> ... models) {
        this.relight(this.world.func_226658_a_(LightType.BLOCK, pos), this.world.func_226658_a_(LightType.SKY, pos), models);
    }

    protected <L extends IFlatLight<?>> void relight(BlockPos pos, Stream<L> models) {
        this.relight(this.world.func_226658_a_(LightType.BLOCK, pos), this.world.func_226658_a_(LightType.SKY, pos), models);
    }

    protected void relight(int block, int sky, IFlatLight<?> ... models) {
        this.relight(block, sky, Arrays.stream(models));
    }

    protected <L extends IFlatLight<?>> void relight(int block, int sky, Stream<L> models) {
        models.forEach(model -> ((IFlatLight)model.setBlockLight(block)).setSkyLight(sky));
    }

    protected RenderMaterial<?, InstancedModel<ModelData>> getTransformMaterial() {
        return this.renderer.getTransformMaterial();
    }

    protected RenderMaterial<?, InstancedModel<OrientedData>> getOrientedMaterial() {
        return this.renderer.getOrientedMaterial();
    }
}

