/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.renderState.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.INamedIconOptions;
import com.simibubi.create.foundation.utility.ColorHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.outliner.ChasingAABBOutline;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class ValueBox
extends ChasingAABBOutline {
    protected String label = "Value Box";
    protected String sublabel = "";
    protected String scrollTooltip = "";
    protected Vec3d labelOffset = Vec3d.field_186680_a;
    protected int passiveColor;
    protected int highlightColor;
    public boolean isPassive;
    protected BlockPos pos;
    protected ValueBoxTransform transform;
    protected BlockState blockState;

    public ValueBox(String label, AxisAlignedBB bb, BlockPos pos) {
        super(bb);
        this.label = label;
        this.pos = pos;
        this.blockState = Minecraft.func_71410_x().field_71441_e.func_180495_p(pos);
    }

    public ValueBox transform(ValueBoxTransform transform) {
        this.transform = transform;
        return this;
    }

    public ValueBox offsetLabel(Vec3d offset) {
        this.labelOffset = offset;
        return this;
    }

    public ValueBox subLabel(String sublabel) {
        this.sublabel = sublabel;
        return this;
    }

    public ValueBox scrollTooltip(String scrollTip) {
        this.scrollTooltip = scrollTip;
        return this;
    }

    public ValueBox withColors(int passive, int highlight) {
        this.passiveColor = passive;
        this.highlightColor = highlight;
        return this;
    }

    public ValueBox passive(boolean passive) {
        this.isPassive = passive;
        return this;
    }

    @Override
    public void render(MatrixStack ms, SuperRenderTypeBuffer buffer, float pt) {
        boolean hasTransform;
        boolean bl = hasTransform = this.transform != null;
        if (this.transform instanceof ValueBoxTransform.Sided && this.params.getHighlightedFace() != null) {
            ((ValueBoxTransform.Sided)this.transform).fromSide(this.params.getHighlightedFace());
        }
        if (hasTransform && !this.transform.shouldRender(this.blockState)) {
            return;
        }
        ms.func_227860_a_();
        ms.func_227861_a_((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p());
        if (hasTransform) {
            this.transform.transform(this.blockState, ms);
        }
        this.transformNormals = ms.func_227866_c_().func_227872_b_().func_226121_d_();
        this.params.colored(this.isPassive ? this.passiveColor : this.highlightColor);
        super.render(ms, buffer, pt);
        float fontScale = hasTransform ? -this.transform.getFontScale() : -0.015625f;
        ms.func_227862_a_(fontScale, fontScale, fontScale);
        ms.func_227860_a_();
        this.renderContents(ms, buffer);
        ms.func_227865_b_();
        if (!this.isPassive) {
            ms.func_227860_a_();
            ms.func_227861_a_(17.5, -0.5, 7.0);
            ms.func_227861_a_(this.labelOffset.field_72450_a, this.labelOffset.field_72448_b, this.labelOffset.field_72449_c);
            this.renderHoveringText(ms, buffer, this.label);
            if (!this.sublabel.isEmpty()) {
                ms.func_227861_a_(0.0, 10.0, 0.0);
                this.renderHoveringText(ms, buffer, this.sublabel);
            }
            if (!this.scrollTooltip.isEmpty()) {
                ms.func_227861_a_(0.0, 10.0, 0.0);
                this.renderHoveringText(ms, buffer, this.scrollTooltip, 0x998899, 0x111111);
            }
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
    }

    public void renderContents(MatrixStack ms, IRenderTypeBuffer buffer) {
    }

    protected void renderHoveringText(MatrixStack ms, IRenderTypeBuffer buffer, String text) {
        this.renderHoveringText(ms, buffer, text, this.highlightColor, ColorHelper.mixColors(this.passiveColor, 0, 0.75f));
    }

    protected void renderHoveringText(MatrixStack ms, IRenderTypeBuffer buffer, String text, int color, int shadowColor) {
        ms.func_227860_a_();
        ValueBox.drawString(ms, buffer, text, 0.0f, 0.0f, color);
        ms.func_227861_a_(0.0, 0.0, -0.25);
        ValueBox.drawString(ms, buffer, text, 1.0f, 1.0f, shadowColor);
        ms.func_227865_b_();
    }

    private static void drawString(MatrixStack ms, IRenderTypeBuffer buffer, String text, float x, float y, int color) {
        Minecraft.func_71410_x().field_71466_p.func_228079_a_(text, x, y, color, false, ms.func_227866_c_().func_227870_a_(), buffer, false, 0, 0xF000F0);
    }

    public static class IconValueBox
    extends ValueBox {
        AllIcons icon;

        public IconValueBox(String label, INamedIconOptions iconValue, AxisAlignedBB bb, BlockPos pos) {
            super(label, bb, pos);
            this.subLabel(Lang.translate(iconValue.getTranslationKey(), new Object[0]));
            this.icon = iconValue.getIcon();
        }

        @Override
        public void renderContents(MatrixStack ms, IRenderTypeBuffer buffer) {
            super.renderContents(ms, buffer);
            float scale = 64.0f;
            ms.func_227862_a_(scale, scale, scale);
            ms.func_227861_a_(-0.5, -0.5, 0.03125);
            this.icon.draw(ms, buffer, 0xFFFFFF);
        }
    }

    public static class TextValueBox
    extends ValueBox {
        String text;

        public TextValueBox(String label, AxisAlignedBB bb, BlockPos pos, String text) {
            super(label, bb, pos);
            this.text = text;
        }

        @Override
        public void renderContents(MatrixStack ms, IRenderTypeBuffer buffer) {
            boolean singleDigit;
            super.renderContents(ms, buffer);
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            float scale = 4.0f;
            ms.func_227862_a_(scale, scale, 1.0f);
            ms.func_227861_a_(-4.0, -4.0, 5.0);
            int stringWidth = font.func_78256_a(this.text);
            font.getClass();
            float numberScale = 9.0f / (float)stringWidth;
            boolean bl = singleDigit = stringWidth < 10;
            if (singleDigit) {
                numberScale /= 2.0f;
            }
            font.getClass();
            float verticalMargin = (float)(stringWidth - 9) / 2.0f;
            ms.func_227862_a_(numberScale, numberScale, numberScale);
            ms.func_227861_a_(singleDigit ? (double)(stringWidth / 2) : 0.0, singleDigit ? (double)(-verticalMargin) : (double)verticalMargin, 0.0);
            this.renderHoveringText(ms, buffer, this.text, 0xEDEDED, 0x4F4F4F);
        }
    }

    public static class ItemValueBox
    extends ValueBox {
        ItemStack stack;
        int count;

        public ItemValueBox(String label, AxisAlignedBB bb, BlockPos pos, ItemStack stack, int count) {
            super(label, bb, pos);
            this.stack = stack;
            this.count = count;
        }

        @Override
        public void renderContents(MatrixStack ms, IRenderTypeBuffer buffer) {
            super.renderContents(ms, buffer);
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            String countString = this.count == 0 ? "*" : this.count + "";
            ms.func_227861_a_(17.5, -5.0, 7.0);
            boolean isFilter = this.stack.func_77973_b() instanceof FilterItem;
            boolean isEmpty = this.stack.func_190926_b();
            float scale = 1.5f;
            ms.func_227861_a_((double)(-font.func_78256_a(countString)), 0.0, 0.0);
            if (isFilter) {
                ms.func_227861_a_(3.0, 8.0, 7.25);
            } else if (isEmpty) {
                ms.func_227861_a_(-17.0, -2.0, 3.0);
                scale = 2.0f;
            } else {
                ms.func_227861_a_(-7.0, 10.0, 10.25);
            }
            ms.func_227862_a_(scale, scale, scale);
            ValueBox.drawString(ms, buffer, countString, 0.0f, 0.0f, isFilter ? 0xFFFFFF : 0xEDEDED);
            ms.func_227861_a_(0.0, 0.0, -0.0625);
            ValueBox.drawString(ms, buffer, countString, 0.875f, 0.875f, 0x4F4F4F);
        }
    }
}

