/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.edgeInteraction;

import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.edgeInteraction.EdgeInteractionBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.RaycastHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EdgeInteractionHandler {
    @SubscribeEvent
    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        PlayerEntity player = event.getPlayer();
        Hand hand = event.getHand();
        ItemStack heldItem = player.func_184586_b(hand);
        if (player.func_225608_bj_() || player.func_175149_v()) {
            return;
        }
        EdgeInteractionBehaviour behaviour = TileEntityBehaviour.get((IBlockReader)world, pos, EdgeInteractionBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        BlockRayTraceResult ray = RaycastHelper.rayTraceRange(world, player, 10.0);
        if (ray == null) {
            return;
        }
        if (behaviour.requiredItem.orElse(heldItem.func_77973_b()) != heldItem.func_77973_b()) {
            return;
        }
        Direction activatedDirection = EdgeInteractionHandler.getActivatedDirection(world, pos, ray.func_216354_b(), ray.func_216347_e(), behaviour);
        if (activatedDirection == null) {
            return;
        }
        if (event.getSide() != LogicalSide.CLIENT) {
            behaviour.connectionCallback.apply(world, pos, pos.func_177972_a(activatedDirection));
        }
        event.setCanceled(true);
        event.setCancellationResult(ActionResultType.SUCCESS);
        world.func_184133_a(null, pos, SoundEvents.field_187620_cL, SoundCategory.BLOCKS, 0.25f, 0.1f);
    }

    public static List<Direction> getConnectiveSides(World world, BlockPos pos, Direction face, EdgeInteractionBehaviour behaviour) {
        ArrayList<Direction> sides = new ArrayList<Direction>(6);
        if (Block.func_220056_d((BlockState)world.func_180495_p(pos.func_177972_a(face)), (IBlockReader)world, (BlockPos)pos.func_177972_a(face), (Direction)face.func_176734_d())) {
            return sides;
        }
        for (Direction direction : Iterate.directions) {
            BlockPos neighbourPos;
            if (direction.func_176740_k() == face.func_176740_k() || Block.func_220056_d((BlockState)world.func_180495_p((neighbourPos = pos.func_177972_a(direction)).func_177972_a(face)), (IBlockReader)world, (BlockPos)neighbourPos.func_177972_a(face), (Direction)face.func_176734_d()) || !behaviour.connectivityPredicate.test(world, pos, face, direction)) continue;
            sides.add(direction);
        }
        return sides;
    }

    public static Direction getActivatedDirection(World world, BlockPos pos, Direction face, Vec3d hit, EdgeInteractionBehaviour behaviour) {
        for (Direction facing : EdgeInteractionHandler.getConnectiveSides(world, pos, face, behaviour)) {
            AxisAlignedBB bb = EdgeInteractionHandler.getBB(pos, facing);
            if (!bb.func_72318_a(hit)) continue;
            return facing;
        }
        return null;
    }

    static AxisAlignedBB getBB(BlockPos pos, Direction direction) {
        AxisAlignedBB bb = new AxisAlignedBB(pos);
        Vec3i vec = direction.func_176730_m();
        int x = vec.func_177958_n();
        int y = vec.func_177956_o();
        int z = vec.func_177952_p();
        double margin = 0.75;
        double absX = (double)Math.abs(x) * margin;
        double absY = (double)Math.abs(y) * margin;
        double absZ = (double)Math.abs(z) * margin;
        bb = bb.func_191195_a(absX, absY, absZ);
        bb = bb.func_72317_d(absX / 2.0, absY / 2.0, absZ / 2.0);
        bb = bb.func_72317_d((double)x / 2.0, (double)y / 2.0, (double)z / 2.0);
        bb = bb.func_186662_g(0.00390625);
        return bb;
    }
}

