/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.edgeInteraction;

import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.tileEntity.behaviour.edgeInteraction.EdgeInteractionBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.edgeInteraction.EdgeInteractionHandler;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class EdgeInteractionRenderer {
    public static void tick() {
        boolean positive;
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult target = mc.field_71476_x;
        if (target == null || !(target instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult result = (BlockRayTraceResult)target;
        ClientWorld world = mc.field_71441_e;
        BlockPos pos = result.func_216350_a();
        ClientPlayerEntity player = mc.field_71439_g;
        ItemStack heldItem = player.func_184614_ca();
        if (player.func_225608_bj_()) {
            return;
        }
        EdgeInteractionBehaviour behaviour = TileEntityBehaviour.get((IBlockReader)world, pos, EdgeInteractionBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        if (behaviour.requiredItem.orElse(heldItem.func_77973_b()) != heldItem.func_77973_b()) {
            return;
        }
        Direction face = result.func_216354_b();
        List<Direction> connectiveSides = EdgeInteractionHandler.getConnectiveSides((World)world, pos, face, behaviour);
        if (connectiveSides.isEmpty()) {
            return;
        }
        Direction closestEdge = connectiveSides.get(0);
        double bestDistance = Double.MAX_VALUE;
        Vec3d center = VecHelper.getCenterOf((Vec3i)pos);
        for (Direction direction : connectiveSides) {
            double distance = new Vec3d(direction.func_176730_m()).func_178788_d(target.func_216347_e().func_178788_d(center)).func_72433_c();
            if (distance > bestDistance) continue;
            bestDistance = distance;
            closestEdge = direction;
        }
        AxisAlignedBB bb = EdgeInteractionHandler.getBB(pos, closestEdge);
        boolean hit = bb.func_72318_a(target.func_216347_e());
        ValueBox box = new ValueBox("", bb.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p())), pos);
        Vec3d textOffset = Vec3d.field_186680_a;
        boolean bl = positive = closestEdge.func_176743_c() == Direction.AxisDirection.POSITIVE;
        if (positive) {
            textOffset = face.func_176740_k().func_176722_c() ? (closestEdge.func_176740_k().func_200128_b() ? textOffset.func_72441_c(0.0, -128.0, 0.0) : textOffset.func_72441_c(-128.0, 0.0, 0.0)) : textOffset.func_72441_c(-128.0, 0.0, 0.0);
        }
        box.offsetLabel(textOffset).withColors(8022572, 12033380).passive(!hit);
        CreateClient.outliner.showValueBox("edge", box).lineWidth(0.015625f).withFaceTexture(hit ? AllSpecialTextures.THIN_CHECKERED : null).highlightFace(face);
    }
}

