/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.filtering;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.SidedFilteringBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;

public class FilteringRenderer {
    public static void tick() {
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult target = mc.field_71476_x;
        if (target == null || !(target instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult result = (BlockRayTraceResult)target;
        ClientWorld world = mc.field_71441_e;
        BlockPos pos = result.func_216350_a();
        BlockState state = world.func_180495_p(pos);
        FilteringBehaviour behaviour = TileEntityBehaviour.get((IBlockReader)world, pos, FilteringBehaviour.TYPE);
        if (mc.field_71439_g.func_225608_bj_()) {
            return;
        }
        if (behaviour == null) {
            return;
        }
        if (behaviour instanceof SidedFilteringBehaviour && (behaviour = ((SidedFilteringBehaviour)behaviour).get(result.func_216354_b())) == null) {
            return;
        }
        if (!behaviour.isActive()) {
            return;
        }
        if (behaviour.slotPositioning instanceof ValueBoxTransform.Sided) {
            ((ValueBoxTransform.Sided)behaviour.slotPositioning).fromSide(result.func_216354_b());
        }
        if (!behaviour.slotPositioning.shouldRender(state)) {
            return;
        }
        ItemStack filter = behaviour.getFilter();
        boolean isFilterSlotted = filter.func_77973_b() instanceof FilterItem;
        boolean showCount = behaviour.isCountVisible();
        boolean fluids = behaviour.fluidFilter;
        String label = isFilterSlotted ? "" : Lang.translate(behaviour.recipeFilter ? "logistics.recipe_filter" : (fluids ? "logistics.fluid_filter" : "logistics.filter"), new Object[0]);
        boolean hit = behaviour.slotPositioning.testHit(state, target.func_216347_e().func_178788_d(new Vec3d((Vec3i)pos)));
        AxisAlignedBB emptyBB = new AxisAlignedBB(Vec3d.field_186680_a, Vec3d.field_186680_a);
        AxisAlignedBB bb = isFilterSlotted ? emptyBB.func_72314_b((double)0.45f, (double)0.31f, (double)0.2f) : emptyBB.func_186662_g(0.25);
        ValueBox box = showCount ? new ValueBox.ItemValueBox(label, bb, pos, filter, behaviour.scrollableValue) : new ValueBox(label, bb, pos);
        box.offsetLabel(behaviour.textShift).withColors(fluids ? 4223112 : 8022572, fluids ? 7384501 : 12033380).scrollTooltip(showCount && !isFilterSlotted ? "[" + Lang.translate("action.scroll", new Object[0]) + "]" : "").passive(!hit);
        CreateClient.outliner.showValueBox(Pair.of("filter", pos), box.transform(behaviour.slotPositioning)).lineWidth(0.015625f).withFaceTexture(hit ? AllSpecialTextures.THIN_CHECKERED : null).highlightFace(result.func_216354_b());
    }

    public static void renderOnTileEntity(SmartTileEntity tileEntityIn, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (tileEntityIn == null || tileEntityIn.func_145837_r()) {
            return;
        }
        FilteringBehaviour behaviour = tileEntityIn.getBehaviour(FilteringBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        if (!behaviour.isActive()) {
            return;
        }
        if (behaviour.getFilter().func_190926_b() && !(behaviour instanceof SidedFilteringBehaviour)) {
            return;
        }
        ValueBoxTransform slotPositioning = behaviour.slotPositioning;
        BlockState blockState = tileEntityIn.func_195044_w();
        if (slotPositioning instanceof ValueBoxTransform.Sided) {
            ValueBoxTransform.Sided sided = (ValueBoxTransform.Sided)slotPositioning;
            Direction side = sided.getSide();
            for (Direction d : Iterate.directions) {
                ItemStack filter = behaviour.getFilter(d);
                if (filter.func_190926_b()) continue;
                sided.fromSide(d);
                if (!slotPositioning.shouldRender(blockState)) continue;
                ms.func_227860_a_();
                slotPositioning.transform(blockState, ms);
                ValueBoxRenderer.renderItemIntoValueBox(filter, ms, buffer, light, overlay);
                ms.func_227865_b_();
            }
            sided.fromSide(side);
            return;
        }
        if (slotPositioning.shouldRender(blockState)) {
            ms.func_227860_a_();
            slotPositioning.transform(blockState, ms);
            ValueBoxRenderer.renderItemIntoValueBox(behaviour.getFilter(), ms, buffer, light, overlay);
            ms.func_227865_b_();
        }
    }
}

