/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.inventory;

import com.google.common.base.Predicates;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.BlockFace;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class InvManipulationBehaviour
extends TileEntityBehaviour {
    public static BehaviourType<InvManipulationBehaviour> TYPE = new BehaviourType();
    public static BehaviourType<InvManipulationBehaviour> EXTRACT = new BehaviourType();
    public static BehaviourType<InvManipulationBehaviour> INSERT = new BehaviourType();
    protected InterfaceProvider target;
    protected LazyOptional<IItemHandler> targetCapability;
    protected boolean simulateNext;
    protected boolean bypassSided;
    private boolean findNewNextTick;
    private BehaviourType<InvManipulationBehaviour> behaviourType;

    public static InvManipulationBehaviour forExtraction(SmartTileEntity te, InterfaceProvider target) {
        return new InvManipulationBehaviour(EXTRACT, te, target);
    }

    public static InvManipulationBehaviour forInsertion(SmartTileEntity te, InterfaceProvider target) {
        return new InvManipulationBehaviour(INSERT, te, target);
    }

    public InvManipulationBehaviour(SmartTileEntity te, InterfaceProvider target) {
        this(TYPE, te, target);
    }

    private InvManipulationBehaviour(BehaviourType<InvManipulationBehaviour> type, SmartTileEntity te, InterfaceProvider target) {
        super(te);
        this.behaviourType = type;
        this.setLazyTickRate(5);
        this.target = target;
        this.targetCapability = LazyOptional.empty();
        this.simulateNext = false;
        this.bypassSided = false;
    }

    public InvManipulationBehaviour bypassSidedness() {
        this.bypassSided = true;
        return this;
    }

    public InvManipulationBehaviour simulate() {
        this.simulateNext = true;
        return this;
    }

    public boolean hasInventory() {
        return this.targetCapability.isPresent();
    }

    @Nullable
    public IItemHandler getInventory() {
        return (IItemHandler)this.targetCapability.orElse(null);
    }

    public ItemStack extract() {
        return this.extract(this.getAmountFromFilter());
    }

    public ItemStack extract(int amount) {
        return this.extract(amount, (Predicate<ItemStack>)Predicates.alwaysTrue());
    }

    public ItemStack extract(int amount, Predicate<ItemStack> filter) {
        return this.extract(amount, filter, ItemStack::func_77976_d);
    }

    public ItemStack extract(int amount, Predicate<ItemStack> filter, Function<ItemStack, Integer> amountThreshold) {
        boolean shouldSimulate = this.simulateNext;
        this.simulateNext = false;
        if (this.getWorld().field_72995_K) {
            return ItemStack.field_190927_a;
        }
        IItemHandler inventory = (IItemHandler)this.targetCapability.orElse(null);
        if (inventory == null) {
            return ItemStack.field_190927_a;
        }
        Predicate<ItemStack> test = this.getFilterTest(filter);
        ItemStack extract = ItemStack.field_190927_a;
        extract = amount != -1 ? ItemHelper.extract(inventory, test, amount, shouldSimulate) : ItemHelper.extract(inventory, test, amountThreshold, shouldSimulate);
        return extract;
    }

    public ItemStack insert(ItemStack stack) {
        boolean shouldSimulate = this.simulateNext;
        this.simulateNext = false;
        IItemHandler inventory = (IItemHandler)this.targetCapability.orElse(null);
        if (inventory == null) {
            return stack;
        }
        return ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)stack, (boolean)shouldSimulate);
    }

    protected Predicate<ItemStack> getFilterTest(Predicate<ItemStack> customFilter) {
        Predicate<ItemStack> test = customFilter;
        FilteringBehaviour filter = this.tileEntity.getBehaviour(FilteringBehaviour.TYPE);
        if (filter != null) {
            test = customFilter.and(filter::test);
        }
        return test;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.findNewNextTick = true;
    }

    @Override
    public void onNeighborChanged(BlockPos neighborPos) {
        BlockFace targetBlockFace = this.target.getTarget(this.getWorld(), this.tileEntity.func_174877_v(), this.tileEntity.func_195044_w());
        if (targetBlockFace.getConnectedPos().equals((Object)neighborPos)) {
            this.onHandlerInvalidated(this.targetCapability);
        }
    }

    protected void onHandlerInvalidated(LazyOptional<IItemHandler> handler) {
        this.findNewNextTick = true;
        this.targetCapability = LazyOptional.empty();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (!this.targetCapability.isPresent()) {
            this.findNewCapability();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.findNewNextTick) {
            this.findNewNextTick = false;
            this.findNewCapability();
        }
    }

    public int getAmountFromFilter() {
        int amount = -1;
        FilteringBehaviour filter = this.tileEntity.getBehaviour(FilteringBehaviour.TYPE);
        if (filter != null && !filter.anyAmount()) {
            amount = filter.getAmount();
        }
        return amount;
    }

    public void findNewCapability() {
        BlockFace targetBlockFace = this.target.getTarget(this.getWorld(), this.tileEntity.func_174877_v(), this.tileEntity.func_195044_w()).getOpposite();
        BlockPos pos = targetBlockFace.getPos();
        World world = this.getWorld();
        this.targetCapability = LazyOptional.empty();
        if (!world.func_195588_v(pos)) {
            return;
        }
        TileEntity invTE = world.func_175625_s(pos);
        if (invTE == null) {
            return;
        }
        LazyOptional lazyOptional = this.targetCapability = this.bypassSided ? invTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) : invTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, targetBlockFace.getFace());
        if (this.targetCapability.isPresent()) {
            this.targetCapability.addListener(this::onHandlerInvalidated);
        }
    }

    @Override
    public BehaviourType<?> getType() {
        return this.behaviourType;
    }

    @FunctionalInterface
    public static interface InterfaceProvider {
        public static InterfaceProvider towardBlockFacing() {
            return (w, p, s) -> new BlockFace(p, s.func_196959_b((IProperty)BlockStateProperties.field_208155_H) ? (Direction)s.func_177229_b((IProperty)BlockStateProperties.field_208155_H) : (Direction)s.func_177229_b((IProperty)BlockStateProperties.field_208157_J));
        }

        public static InterfaceProvider oppositeOfBlockFacing() {
            return (w, p, s) -> new BlockFace(p, (s.func_196959_b((IProperty)BlockStateProperties.field_208155_H) ? (Direction)s.func_177229_b((IProperty)BlockStateProperties.field_208155_H) : (Direction)s.func_177229_b((IProperty)BlockStateProperties.field_208157_J)).func_176734_d());
        }

        public BlockFace getTarget(World var1, BlockPos var2, BlockState var3);
    }
}

