/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.linked;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.apache.commons.lang3.tuple.Pair;

public class LinkBehaviour
extends TileEntityBehaviour {
    public static BehaviourType<LinkBehaviour> TYPE = new BehaviourType();
    RedstoneLinkNetworkHandler.Frequency frequencyFirst = RedstoneLinkNetworkHandler.Frequency.EMPTY;
    RedstoneLinkNetworkHandler.Frequency frequencyLast = RedstoneLinkNetworkHandler.Frequency.EMPTY;
    ValueBoxTransform firstSlot;
    ValueBoxTransform secondSlot;
    Vec3d textShift;
    public boolean newPosition;
    private Mode mode;
    private IntSupplier transmission;
    private IntConsumer signalCallback;

    protected LinkBehaviour(SmartTileEntity te, Pair<ValueBoxTransform, ValueBoxTransform> slots) {
        super(te);
        this.firstSlot = (ValueBoxTransform)slots.getLeft();
        this.secondSlot = (ValueBoxTransform)slots.getRight();
        this.textShift = Vec3d.field_186680_a;
        this.newPosition = true;
    }

    public static LinkBehaviour receiver(SmartTileEntity te, Pair<ValueBoxTransform, ValueBoxTransform> slots, IntConsumer signalCallback) {
        LinkBehaviour behaviour = new LinkBehaviour(te, slots);
        behaviour.signalCallback = signalCallback;
        behaviour.mode = Mode.RECEIVE;
        return behaviour;
    }

    public static LinkBehaviour transmitter(SmartTileEntity te, Pair<ValueBoxTransform, ValueBoxTransform> slots, IntSupplier transmission) {
        LinkBehaviour behaviour = new LinkBehaviour(te, slots);
        behaviour.transmission = transmission;
        behaviour.mode = Mode.TRANSMIT;
        return behaviour;
    }

    public LinkBehaviour moveText(Vec3d shift) {
        this.textShift = shift;
        return this;
    }

    public void copyItemsFrom(LinkBehaviour behaviour) {
        if (behaviour == null) {
            return;
        }
        this.frequencyFirst = behaviour.frequencyFirst;
        this.frequencyLast = behaviour.frequencyLast;
    }

    public boolean isListening() {
        return this.mode == Mode.RECEIVE;
    }

    public int getTransmittedStrength() {
        return this.mode == Mode.TRANSMIT ? this.transmission.getAsInt() : 0;
    }

    public void updateReceiver(int networkPower) {
        if (!this.newPosition) {
            return;
        }
        this.signalCallback.accept(networkPower);
    }

    public void notifySignalChange() {
        Create.redstoneLinkNetworkHandler.updateNetworkOf(this);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.tileEntity.func_145831_w().field_72995_K) {
            return;
        }
        this.getHandler().addToNetwork(this);
        this.newPosition = true;
    }

    public Pair<RedstoneLinkNetworkHandler.Frequency, RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
        return Pair.of((Object)this.frequencyFirst, (Object)this.frequencyLast);
    }

    @Override
    public void remove() {
        super.remove();
        if (this.tileEntity.func_145831_w().field_72995_K) {
            return;
        }
        this.getHandler().removeFromNetwork(this);
    }

    @Override
    public void write(CompoundNBT nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        nbt.func_218657_a("FrequencyFirst", (INBT)this.frequencyFirst.getStack().func_77955_b(new CompoundNBT()));
        nbt.func_218657_a("FrequencyLast", (INBT)this.frequencyLast.getStack().func_77955_b(new CompoundNBT()));
        nbt.func_74772_a("LastKnownPosition", this.tileEntity.func_174877_v().func_218275_a());
    }

    @Override
    public void read(CompoundNBT nbt, boolean clientPacket) {
        long positionKey;
        long positionInTag = this.tileEntity.func_174877_v().func_218275_a();
        this.newPosition = positionInTag != (positionKey = nbt.func_74763_f("LastKnownPosition"));
        super.read(nbt, clientPacket);
        this.frequencyFirst = RedstoneLinkNetworkHandler.Frequency.of(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("FrequencyFirst")));
        this.frequencyLast = RedstoneLinkNetworkHandler.Frequency.of(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("FrequencyLast")));
    }

    public void setFrequency(boolean first, ItemStack stack) {
        boolean changed;
        stack = stack.func_77946_l();
        stack.func_190920_e(1);
        ItemStack toCompare = first ? this.frequencyFirst.getStack() : this.frequencyLast.getStack();
        boolean bl = changed = !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)toCompare) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)toCompare);
        if (changed) {
            this.getHandler().removeFromNetwork(this);
        }
        if (first) {
            this.frequencyFirst = RedstoneLinkNetworkHandler.Frequency.of(stack);
        } else {
            this.frequencyLast = RedstoneLinkNetworkHandler.Frequency.of(stack);
        }
        if (!changed) {
            return;
        }
        this.tileEntity.sendData();
        this.getHandler().addToNetwork(this);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    private RedstoneLinkNetworkHandler getHandler() {
        return Create.redstoneLinkNetworkHandler;
    }

    public boolean testHit(Boolean first, Vec3d hit) {
        BlockState state = this.tileEntity.func_195044_w();
        Vec3d localHit = hit.func_178788_d(new Vec3d((Vec3i)this.tileEntity.func_174877_v()));
        return (first != false ? this.firstSlot : this.secondSlot).testHit(state, localHit);
    }

    public static class SlotPositioning {
        Function<BlockState, Pair<Vec3d, Vec3d>> offsets;
        Function<BlockState, Vec3d> rotation;
        float scale;

        public SlotPositioning(Function<BlockState, Pair<Vec3d, Vec3d>> offsetsForState, Function<BlockState, Vec3d> rotationForState) {
            this.offsets = offsetsForState;
            this.rotation = rotationForState;
            this.scale = 1.0f;
        }

        public SlotPositioning scale(float scale) {
            this.scale = scale;
            return this;
        }
    }

    static enum Mode {
        TRANSMIT,
        RECEIVE;

    }
}

