/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.BulkScrollValueBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;

public class ScrollValueRenderer {
    public static void tick() {
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult target = mc.field_71476_x;
        if (target == null || !(target instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult result = (BlockRayTraceResult)target;
        ClientWorld world = mc.field_71441_e;
        BlockPos pos = result.func_216350_a();
        Direction face = result.func_216354_b();
        ScrollValueBehaviour behaviour = TileEntityBehaviour.get((IBlockReader)world, pos, ScrollValueBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        if (!behaviour.isActive()) {
            return;
        }
        if (behaviour.needsWrench && !AllItems.WRENCH.isIn(mc.field_71439_g.func_184614_ca())) {
            return;
        }
        boolean highlight = behaviour.testHit(target.func_216347_e());
        if (behaviour instanceof BulkScrollValueBehaviour && AllKeys.ctrlDown()) {
            BulkScrollValueBehaviour bulkScrolling = (BulkScrollValueBehaviour)behaviour;
            for (SmartTileEntity smartTileEntity : bulkScrolling.getBulk()) {
                ScrollValueBehaviour other = smartTileEntity.getBehaviour(ScrollValueBehaviour.TYPE);
                if (other == null) continue;
                ScrollValueRenderer.addBox(world, smartTileEntity.func_174877_v(), face, other, highlight);
            }
        } else {
            ScrollValueRenderer.addBox(world, pos, face, behaviour, highlight);
        }
    }

    protected static void addBox(ClientWorld world, BlockPos pos, Direction face, ScrollValueBehaviour behaviour, boolean highlight) {
        ValueBox box;
        AxisAlignedBB bb = new AxisAlignedBB(Vec3d.field_186680_a, Vec3d.field_186680_a).func_186662_g(0.5).func_191195_a(0.0, 0.0, -0.5).func_72317_d(0.0, 0.0, -0.125);
        String label = behaviour.label;
        if (behaviour instanceof ScrollOptionBehaviour) {
            box = new ValueBox.IconValueBox(label, ((ScrollOptionBehaviour)behaviour).getIconForSelected(), bb, pos);
        } else {
            box = new ValueBox.TextValueBox(label, bb, pos, behaviour.formatValue());
            if (behaviour.unit != null) {
                box.subLabel("(" + behaviour.unit.apply(behaviour.scrollableValue) + ")");
            }
        }
        box.scrollTooltip("[" + Lang.translate("action.scroll", new Object[0]) + "]");
        box.offsetLabel(behaviour.textShift.func_72441_c(20.0, -10.0, 0.0)).withColors(0x5A5D5A, 11909046).passive(!highlight);
        CreateClient.outliner.showValueBox(pos, box.transform(behaviour.slotPositioning)).lineWidth(0.015625f).highlightFace(face);
    }
}

