/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.text.ITextComponent;

public final class NBTProcessors {
    private static final Map<TileEntityType<?>, UnaryOperator<CompoundNBT>> processors = new HashMap();
    private static final Map<TileEntityType<?>, UnaryOperator<CompoundNBT>> survivalProcessors = new HashMap();

    public static synchronized void addProcessor(TileEntityType<?> type, UnaryOperator<CompoundNBT> processor) {
        processors.put(type, processor);
    }

    public static synchronized void addSurvivalProcessor(TileEntityType<?> type, UnaryOperator<CompoundNBT> processor) {
        survivalProcessors.put(type, processor);
    }

    private NBTProcessors() {
    }

    @Nullable
    public static CompoundNBT process(TileEntity tileEntity, CompoundNBT compound, boolean survival) {
        if (compound == null) {
            return null;
        }
        TileEntityType type = tileEntity.func_200662_C();
        if (survival && survivalProcessors.containsKey(type)) {
            compound = (CompoundNBT)survivalProcessors.get(type).apply(compound);
        }
        if (compound != null && processors.containsKey(type)) {
            return (CompoundNBT)processors.get(type).apply(compound);
        }
        if (tileEntity instanceof MobSpawnerTileEntity) {
            return compound;
        }
        if (tileEntity.func_183000_F()) {
            return null;
        }
        return compound;
    }

    static {
        NBTProcessors.addProcessor(TileEntityType.field_200978_i, data -> {
            for (int i = 0; i < 4; ++i) {
                String s = data.func_74779_i("Text" + (i + 1));
                ITextComponent textcomponent = ITextComponent.Serializer.func_150699_a((String)(s.isEmpty() ? "\"\"" : s));
                if (textcomponent == null || textcomponent.func_150256_b() == null || textcomponent.func_150256_b().func_150235_h() == null) continue;
                return null;
            }
            return data;
        });
        NBTProcessors.addSurvivalProcessor((TileEntityType)AllTileEntities.FUNNEL.get(), data -> {
            ItemStack filter;
            if (data.func_74764_b("Filter") && (filter = ItemStack.func_199557_a((CompoundNBT)data.func_74775_l("Filter"))).func_77973_b() instanceof FilterItem) {
                data.func_82580_o("Filter");
            }
            return data;
        });
    }
}

