/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class VecHelper {
    public static final Vec3d CENTER_OF_ORIGIN = new Vec3d(0.5, 0.5, 0.5);

    public static Vec3d rotate(Vec3d vec, Vec3d rotationVec) {
        return VecHelper.rotate(vec, rotationVec.field_72450_a, rotationVec.field_72448_b, rotationVec.field_72449_c);
    }

    public static Vec3d rotate(Vec3d vec, double xRot, double yRot, double zRot) {
        return VecHelper.rotate(VecHelper.rotate(VecHelper.rotate(vec, xRot, Direction.Axis.X), yRot, Direction.Axis.Y), zRot, Direction.Axis.Z);
    }

    public static Vec3d rotateCentered(Vec3d vec, double deg, Direction.Axis axis) {
        Vec3d shift = VecHelper.getCenterOf((Vec3i)BlockPos.field_177992_a);
        return VecHelper.rotate(vec.func_178788_d(shift), deg, axis).func_178787_e(shift);
    }

    public static Vec3d rotate(Vec3d vec, double deg, Direction.Axis axis) {
        if (deg == 0.0) {
            return vec;
        }
        if (vec == Vec3d.field_186680_a) {
            return vec;
        }
        float angle = (float)(deg / 180.0 * Math.PI);
        double sin = MathHelper.func_76126_a((float)angle);
        double cos = MathHelper.func_76134_b((float)angle);
        double x = vec.field_72450_a;
        double y = vec.field_72448_b;
        double z = vec.field_72449_c;
        if (axis == Direction.Axis.X) {
            return new Vec3d(x, y * cos - z * sin, z * cos + y * sin);
        }
        if (axis == Direction.Axis.Y) {
            return new Vec3d(x * cos + z * sin, y, z * cos - x * sin);
        }
        if (axis == Direction.Axis.Z) {
            return new Vec3d(x * cos - y * sin, y * cos + x * sin, z);
        }
        return vec;
    }

    public static boolean isVecPointingTowards(Vec3d vec, Direction direction) {
        return new Vec3d(direction.func_176730_m()).func_72430_b(vec.func_72432_b()) > 0.0;
    }

    public static Vec3d getCenterOf(Vec3i pos) {
        if (pos.equals((Object)Vec3i.field_177959_e)) {
            return CENTER_OF_ORIGIN;
        }
        return new Vec3d(pos).func_72441_c(0.5, 0.5, 0.5);
    }

    public static Vec3d offsetRandomly(Vec3d vec, Random r, float radius) {
        return new Vec3d(vec.field_72450_a + (double)((r.nextFloat() - 0.5f) * 2.0f * radius), vec.field_72448_b + (double)((r.nextFloat() - 0.5f) * 2.0f * radius), vec.field_72449_c + (double)((r.nextFloat() - 0.5f) * 2.0f * radius));
    }

    public static Vec3d axisAlingedPlaneOf(Vec3d vec) {
        vec = vec.func_72432_b();
        return new Vec3d(1.0, 1.0, 1.0).func_178786_a(Math.abs(vec.field_72450_a), Math.abs(vec.field_72448_b), Math.abs(vec.field_72449_c));
    }

    public static Vec3d axisAlingedPlaneOf(Direction face) {
        return VecHelper.axisAlingedPlaneOf(new Vec3d(face.func_176730_m()));
    }

    public static ListNBT writeNBT(Vec3d vec) {
        ListNBT listnbt = new ListNBT();
        listnbt.add((Object)DoubleNBT.func_229684_a_((double)vec.field_72450_a));
        listnbt.add((Object)DoubleNBT.func_229684_a_((double)vec.field_72448_b));
        listnbt.add((Object)DoubleNBT.func_229684_a_((double)vec.field_72449_c));
        return listnbt;
    }

    public static Vec3d readNBT(ListNBT list) {
        if (list.isEmpty()) {
            return Vec3d.field_186680_a;
        }
        return new Vec3d(list.func_150309_d(0), list.func_150309_d(1), list.func_150309_d(2));
    }

    public static Vec3d voxelSpace(double x, double y, double z) {
        return new Vec3d(x, y, z).func_186678_a(0.0625);
    }

    public static int getCoordinate(Vec3i pos, Direction.Axis axis) {
        return axis.func_196052_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static float getCoordinate(Vec3d vec, Direction.Axis axis) {
        return (float)axis.func_196051_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static boolean onSameAxis(BlockPos pos1, BlockPos pos2, Direction.Axis axis) {
        if (pos1.equals((Object)pos2)) {
            return true;
        }
        for (Direction.Axis otherAxis : Direction.Axis.values()) {
            if (axis == otherAxis || VecHelper.getCoordinate((Vec3i)pos1, otherAxis) == VecHelper.getCoordinate((Vec3i)pos2, otherAxis)) continue;
            return false;
        }
        return true;
    }

    public static Vec3d clamp(Vec3d vec, float maxLength) {
        return vec.func_72433_c() > (double)maxLength ? vec.func_72432_b().func_186678_a((double)maxLength) : vec;
    }

    public static Vec3d lerp(float p, Vec3d from, Vec3d to) {
        return from.func_178787_e(to.func_178788_d(from).func_186678_a((double)p));
    }

    public static Vec3d clampComponentWise(Vec3d vec, float maxLength) {
        return new Vec3d(MathHelper.func_151237_a((double)vec.field_72450_a, (double)(-maxLength), (double)maxLength), MathHelper.func_151237_a((double)vec.field_72448_b, (double)(-maxLength), (double)maxLength), MathHelper.func_151237_a((double)vec.field_72449_c, (double)(-maxLength), (double)maxLength));
    }

    public static Vec3d project(Vec3d vec, Vec3d ontoVec) {
        if (ontoVec.equals((Object)Vec3d.field_186680_a)) {
            return Vec3d.field_186680_a;
        }
        return ontoVec.func_186678_a(vec.func_72430_b(ontoVec) / ontoVec.func_189985_c());
    }

    @Nullable
    public static Vec3d intersectSphere(Vec3d origin, Vec3d lineDirection, Vec3d sphereCenter, double radius) {
        Vec3d diff;
        double lineDotDiff;
        double delta;
        if (lineDirection.equals((Object)Vec3d.field_186680_a)) {
            return null;
        }
        if (lineDirection.func_72433_c() != 1.0) {
            lineDirection = lineDirection.func_72432_b();
        }
        if ((delta = (lineDotDiff = lineDirection.func_72430_b(diff = origin.func_178788_d(sphereCenter))) * lineDotDiff - (diff.func_189985_c() - radius * radius)) < 0.0) {
            return null;
        }
        double t = -lineDotDiff + (double)MathHelper.func_76133_a((double)delta);
        return origin.func_178787_e(lineDirection.func_186678_a(t));
    }

    public static Vec3d projectToPlayerView(Vec3d target, float partialTicks) {
        Entity renderViewEntity;
        ActiveRenderInfo ari = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vec3d camera_pos = ari.func_216785_c();
        Quaternion camera_rotation_conj = ari.func_227995_f_().func_227068_g_();
        camera_rotation_conj.func_195892_e();
        Vector3f result3f = new Vector3f((float)(camera_pos.field_72450_a - target.field_72450_a), (float)(camera_pos.field_72448_b - target.field_72448_b), (float)(camera_pos.field_72449_c - target.field_72449_c));
        result3f.func_214905_a(camera_rotation_conj);
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74336_f && (renderViewEntity = mc.func_175606_aa()) instanceof PlayerEntity) {
            PlayerEntity playerentity = (PlayerEntity)renderViewEntity;
            float distwalked_modified = playerentity.field_70140_Q;
            float f = distwalked_modified - playerentity.field_70141_P;
            float f1 = -(distwalked_modified + f * partialTicks);
            float f2 = MathHelper.func_219799_g((float)partialTicks, (float)playerentity.field_71107_bF, (float)playerentity.field_71109_bG);
            Quaternion q2 = new Quaternion(Vector3f.field_229179_b_, Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f, true);
            q2.func_195892_e();
            result3f.func_214905_a(q2);
            Quaternion q1 = new Quaternion(Vector3f.field_229183_f_, MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 3.0f, true);
            q1.func_195892_e();
            result3f.func_214905_a(q1);
            Vector3f bob_translation = new Vector3f(MathHelper.func_76126_a((float)(f1 * (float)Math.PI)) * f2 * 0.5f, -Math.abs(MathHelper.func_76134_b((float)(f1 * (float)Math.PI)) * f2), 0.0f);
            bob_translation.setY(-bob_translation.func_195900_b());
            result3f.func_229189_a_(bob_translation);
        }
        float fov = (float)mc.field_71460_t.func_215311_a(ari, partialTicks, true);
        float half_height = (float)mc.func_228018_at_().func_198087_p() / 2.0f;
        float scale_factor = half_height / (result3f.func_195902_c() * (float)Math.tan(Math.toRadians(fov / 2.0f)));
        return new Vec3d((double)(-result3f.func_195899_a() * scale_factor), (double)(result3f.func_195900_b() * scale_factor), (double)result3f.func_195902_c());
    }
}

