/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.outliner;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.foundation.renderState.RenderTypes;
import com.simibubi.create.foundation.renderState.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.outliner.Outline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class AABBOutline
extends Outline {
    protected AxisAlignedBB bb;

    public AABBOutline(AxisAlignedBB bb) {
        this.setBounds(bb);
    }

    @Override
    public void render(MatrixStack ms, SuperRenderTypeBuffer buffer, float pt) {
        this.renderBB(ms, buffer, this.bb);
    }

    public void renderBB(MatrixStack ms, SuperRenderTypeBuffer buffer, AxisAlignedBB bb) {
        Vec3d projectedView = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        boolean noCull = bb.func_72318_a(projectedView);
        bb = bb.func_186662_g(noCull ? -0.0078125 : 0.0078125);
        noCull |= this.params.disableCull;
        Vec3d xyz = new Vec3d(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c);
        Vec3d Xyz = new Vec3d(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c);
        Vec3d xYz = new Vec3d(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c);
        Vec3d XYz = new Vec3d(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c);
        Vec3d xyZ = new Vec3d(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f);
        Vec3d XyZ = new Vec3d(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f);
        Vec3d xYZ = new Vec3d(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f);
        Vec3d XYZ = new Vec3d(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
        Vec3d start = xyz;
        this.renderAACuboidLine(ms, buffer, start, Xyz);
        this.renderAACuboidLine(ms, buffer, start, xYz);
        this.renderAACuboidLine(ms, buffer, start, xyZ);
        start = XyZ;
        this.renderAACuboidLine(ms, buffer, start, xyZ);
        this.renderAACuboidLine(ms, buffer, start, XYZ);
        this.renderAACuboidLine(ms, buffer, start, Xyz);
        start = XYz;
        this.renderAACuboidLine(ms, buffer, start, xYz);
        this.renderAACuboidLine(ms, buffer, start, Xyz);
        this.renderAACuboidLine(ms, buffer, start, XYZ);
        start = xYZ;
        this.renderAACuboidLine(ms, buffer, start, XYZ);
        this.renderAACuboidLine(ms, buffer, start, xyZ);
        this.renderAACuboidLine(ms, buffer, start, xYz);
        this.renderFace(ms, buffer, Direction.NORTH, xYz, XYz, Xyz, xyz, noCull);
        this.renderFace(ms, buffer, Direction.SOUTH, XYZ, xYZ, xyZ, XyZ, noCull);
        this.renderFace(ms, buffer, Direction.EAST, XYz, XYZ, XyZ, Xyz, noCull);
        this.renderFace(ms, buffer, Direction.WEST, xYZ, xYz, xyz, xyZ, noCull);
        this.renderFace(ms, buffer, Direction.UP, xYZ, XYZ, XYz, xYz, noCull);
        this.renderFace(ms, buffer, Direction.DOWN, xyz, Xyz, XyZ, xyZ, noCull);
    }

    protected void renderFace(MatrixStack ms, SuperRenderTypeBuffer buffer, Direction direction, Vec3d p1, Vec3d p2, Vec3d p3, Vec3d p4, boolean noCull) {
        if (!this.params.faceTexture.isPresent()) {
            return;
        }
        ResourceLocation faceTexture = this.params.faceTexture.get().getLocation();
        float alphaBefore = this.params.alpha;
        this.params.alpha = direction == this.params.getHighlightedFace() && this.params.hightlightedFaceTexture.isPresent() ? 1.0f : 0.5f;
        RenderType translucentType = RenderTypes.getOutlineTranslucent(faceTexture, !noCull);
        IVertexBuilder builder = buffer.getLateBuffer(translucentType);
        Direction.Axis axis = direction.func_176740_k();
        Vec3d uDiff = p2.func_178788_d(p1);
        Vec3d vDiff = p4.func_178788_d(p1);
        float maxU = (float)Math.abs(axis == Direction.Axis.X ? uDiff.field_72449_c : uDiff.field_72450_a);
        float maxV = (float)Math.abs(axis == Direction.Axis.Y ? vDiff.field_72449_c : vDiff.field_72448_b);
        this.putQuadUV(ms, builder, p1, p2, p3, p4, 0.0f, 0.0f, maxU, maxV, Direction.UP);
        this.params.alpha = alphaBefore;
    }

    public void setBounds(AxisAlignedBB bb) {
        this.bb = bb;
    }
}

