/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.placement;

import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CClient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.widgets.InterpolatedChasingAngle;
import com.simibubi.create.foundation.gui.widgets.InterpolatedChasingValue;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlacementHelpers {
    private static final List<IPlacementHelper> helpers = new ArrayList<IPlacementHelper>();
    private static int animationTick = 0;
    private static final InterpolatedChasingValue angle = new InterpolatedChasingAngle().withSpeed(0.25f);
    private static BlockPos target = null;
    private static BlockPos lastTarget = null;

    public static int register(IPlacementHelper helper) {
        helpers.add(helper);
        return helpers.size() - 1;
    }

    public static IPlacementHelper get(int id) {
        if (id < 0 || id >= helpers.size()) {
            throw new ArrayIndexOutOfBoundsException("id " + id + " for placement helper not known");
        }
        return helpers.get(id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tick() {
        PlacementHelpers.setTarget(null);
        PlacementHelpers.checkHelpers();
        if (target == null) {
            if (animationTick > 0) {
                animationTick = Math.max(animationTick - 2, 0);
            }
            return;
        }
        if (animationTick < 10) {
            ++animationTick;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void checkHelpers() {
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        if (world == null) {
            return;
        }
        if (!(mc.field_71476_x instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult ray = (BlockRayTraceResult)mc.field_71476_x;
        if (mc.field_71439_g == null) {
            return;
        }
        if (mc.field_71439_g.func_225608_bj_()) {
            return;
        }
        for (Hand hand : Hand.values()) {
            ItemStack heldItem = mc.field_71439_g.func_184586_b(hand);
            List filteredForHeldItem = helpers.stream().filter(helper -> helper.matchesItem(heldItem)).collect(Collectors.toList());
            if (filteredForHeldItem.isEmpty()) continue;
            BlockPos pos = ray.func_216350_a();
            BlockState state = world.func_180495_p(pos);
            List filteredForState = filteredForHeldItem.stream().filter(helper -> helper.matchesState(state)).collect(Collectors.toList());
            if (filteredForState.isEmpty()) continue;
            boolean atLeastOneMatch = false;
            for (IPlacementHelper h : filteredForState) {
                PlacementOffset offset = h.getOffset((PlayerEntity)mc.field_71439_g, (World)world, state, pos, ray, heldItem);
                if (!offset.isSuccessful()) continue;
                h.renderAt(pos, state, ray, offset);
                PlacementHelpers.setTarget(offset.getBlockPos());
                atLeastOneMatch = true;
                break;
            }
            if (!atLeastOneMatch) continue;
            return;
        }
    }

    static void setTarget(BlockPos target) {
        PlacementHelpers.target = target;
        if (target == null) {
            return;
        }
        if (lastTarget == null) {
            lastTarget = target;
            return;
        }
        if (!lastTarget.equals((Object)target)) {
            lastTarget = target;
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onRender(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player != null && animationTick > 0) {
            MainWindow res = event.getWindow();
            float screenY = (float)res.func_198087_p() / 2.0f;
            float screenX = (float)res.func_198107_o() / 2.0f;
            float progress = Math.min((float)animationTick / 10.0f, 1.0f);
            PlacementHelpers.drawDirectionIndicator(event.getPartialTicks(), screenX, screenY, progress);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawDirectionIndicator(float partialTicks, float centerX, float centerY, float progress) {
        float r = 0.8f;
        float g = 0.8f;
        float b = 0.8f;
        float a = progress * progress;
        Vec3d projTarget = VecHelper.projectToPlayerView(VecHelper.getCenterOf((Vec3i)lastTarget), partialTicks);
        Vec3d target = new Vec3d(projTarget.field_72450_a, projTarget.field_72448_b, 0.0);
        if (projTarget.field_72449_c > 0.0) {
            target = target.func_216371_e();
        }
        Vec3d norm = target.func_72432_b();
        Vec3d ref = new Vec3d(0.0, 1.0, 0.0);
        float targetAngle = AngleHelper.deg(Math.acos(norm.func_72430_b(ref)));
        angle.withSpeed(0.25f);
        if (norm.field_72450_a < 0.0) {
            targetAngle = 360.0f - targetAngle;
        }
        if (animationTick < 10) {
            angle.set(targetAngle);
        }
        angle.target(targetAngle);
        angle.tick();
        float snapSize = 22.5f;
        float snappedAngle = snapSize * (float)Math.round(angle.get(0.0f) / snapSize) % 360.0f;
        float length = 10.0f;
        CClient.PlacementIndicatorSetting mode = (CClient.PlacementIndicatorSetting)((Object)AllConfigs.CLIENT.placementIndicator.get());
        if (mode == CClient.PlacementIndicatorSetting.TRIANGLE) {
            PlacementHelpers.fadedArrow(centerX, centerY, r, g, b, a, length, snappedAngle);
        } else if (mode == CClient.PlacementIndicatorSetting.TEXTURE) {
            PlacementHelpers.textured(centerX, centerY, a, snappedAngle);
        }
    }

    private static void fadedArrow(float centerX, float centerY, float r, float g, float b, float a, float length, float snappedAngle) {
        RenderSystem.pushMatrix();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        RenderSystem.translated((double)centerX, (double)centerY, (double)0.0);
        RenderSystem.rotatef((float)angle.get(0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        double scale = (Double)AllConfigs.CLIENT.indicatorScale.get();
        RenderSystem.scaled((double)scale, (double)scale, (double)1.0);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(9, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_(0.0, (double)(-(10.0f + length)), 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        bufferbuilder.func_225582_a_(-9.0, -3.0, 0.0).func_227885_a_(r, g, b, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(-6.0, -6.0, 0.0).func_227885_a_(r, g, b, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(-3.0, -8.0, 0.0).func_227885_a_(r, g, b, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(0.0, -8.5, 0.0).func_227885_a_(r, g, b, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(3.0, -8.0, 0.0).func_227885_a_(r, g, b, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(6.0, -6.0, 0.0).func_227885_a_(r, g, b, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(9.0, -3.0, 0.0).func_227885_a_(r, g, b, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
        RenderSystem.popMatrix();
    }

    private static void textured(float centerX, float centerY, float alpha, float snappedAngle) {
        RenderSystem.pushMatrix();
        RenderSystem.enableTexture();
        AllGuiTextures.PLACEMENT_INDICATOR_SHEET.bind();
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.shadeModel((int)7425);
        RenderSystem.translated((double)centerX, (double)centerY, (double)0.0);
        double scale = (Double)AllConfigs.CLIENT.indicatorScale.get() * 0.75;
        RenderSystem.scaled((double)scale, (double)scale, (double)1.0);
        RenderSystem.scaled((double)12.0, (double)12.0, (double)1.0);
        float index = snappedAngle / 22.5f;
        float tex_size = 0.0625f;
        float tx = 0.0f;
        float ty = index * tex_size;
        float tw = 1.0f;
        float th = tex_size;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        buffer.func_225582_a_(-1.0, -1.0, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(tx, ty).func_181675_d();
        buffer.func_225582_a_(-1.0, 1.0, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(tx, ty + th).func_181675_d();
        buffer.func_225582_a_(1.0, 1.0, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(tx + tw, ty + th).func_181675_d();
        buffer.func_225582_a_(1.0, -1.0, 0.0).func_227885_a_(1.0f, 1.0f, 1.0f, alpha).func_225583_a_(tx + tw, ty).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
    }
}

