/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.placement;

import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import java.util.function.Function;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class PlacementOffset {
    private final boolean success;
    private Vec3i pos;
    private Function<BlockState, BlockState> stateTransform;
    private BlockState ghostState;

    private PlacementOffset(boolean success) {
        this.success = success;
        this.pos = BlockPos.field_177992_a;
        this.stateTransform = Function.identity();
        this.ghostState = null;
    }

    public static PlacementOffset fail() {
        return new PlacementOffset(false);
    }

    public static PlacementOffset success() {
        return new PlacementOffset(true);
    }

    public static PlacementOffset success(Vec3i pos) {
        return PlacementOffset.success().at(pos);
    }

    public static PlacementOffset success(Vec3i pos, Function<BlockState, BlockState> transform) {
        return PlacementOffset.success().at(pos).withTransform(transform);
    }

    public PlacementOffset at(Vec3i pos) {
        this.pos = pos;
        return this;
    }

    public PlacementOffset withTransform(Function<BlockState, BlockState> stateTransform) {
        this.stateTransform = stateTransform;
        return this;
    }

    public PlacementOffset withGhostState(BlockState ghostState) {
        this.ghostState = ghostState;
        return this;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public Vec3i getPos() {
        return this.pos;
    }

    public BlockPos getBlockPos() {
        if (this.pos instanceof BlockPos) {
            return (BlockPos)this.pos;
        }
        return new BlockPos(this.pos);
    }

    public Function<BlockState, BlockState> getTransform() {
        return this.stateTransform;
    }

    public boolean hasGhostState() {
        return this.ghostState != null;
    }

    public BlockState getGhostState() {
        return this.ghostState;
    }

    public boolean isReplaceable(World world) {
        if (!this.success) {
            return false;
        }
        return world.func_180495_p(new BlockPos(this.pos)).func_185904_a().func_76222_j();
    }

    public ActionResultType placeInWorld(World world, BlockItem blockItem, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (!this.isReplaceable(world)) {
            return ActionResultType.PASS;
        }
        ItemUseContext context = new ItemUseContext(player, hand, ray);
        BlockPos newPos = new BlockPos(this.pos);
        if (!world.func_175660_a(player, newPos)) {
            return ActionResultType.PASS;
        }
        BlockState state = this.stateTransform.apply(blockItem.func_179223_d().func_176223_P());
        if (state.func_196959_b((IProperty)BlockStateProperties.field_208198_y)) {
            IFluidState fluidState = world.func_204610_c(newPos);
            state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
        }
        BlockSnapshot snapshot = BlockSnapshot.getBlockSnapshot((IWorld)world, (BlockPos)newPos);
        world.func_175656_a(newPos, state);
        BlockEvent.EntityPlaceEvent event = new BlockEvent.EntityPlaceEvent(snapshot, IPlacementHelper.ID, (Entity)player);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            snapshot.restore(true, false);
            return ActionResultType.FAIL;
        }
        BlockState newState = world.func_180495_p(newPos);
        SoundType soundtype = newState.getSoundType((IWorldReader)world, newPos, (Entity)player);
        world.func_184133_a(player, newPos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)blockItem));
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player instanceof ServerPlayerEntity) {
            CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, newPos, context.func_195996_i());
        }
        if (!player.func_184812_l_()) {
            context.func_195996_i().func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }
}

